/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd;

import aQute.service.reporter.Reporter;
import com.liferay.ant.bnd.BaseBndTask;
import com.liferay.ant.bnd.Baseline;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class BaselineJarTask
extends BaseBndTask {
    private static final String _BASELINE_REPORTS_DIR = "baseline-reports";
    private String _baselineReportsDirName;
    private File _bndFile;
    private boolean _forcePackageInfo;
    private boolean _forceVersionOneOnAddedPackages;
    private File _logFile;
    private File _newCompatJarFile;
    private File _newJarFile;
    private File _oldJarFile;
    private String _reportLevel;
    private boolean _reportLevelIsDiff;
    private boolean _reportLevelIsOff = true;
    private boolean _reportLevelIsPersist;
    private boolean _reportOnlyDirtyPackages;
    private File _sourceDir;

    public void setBndFile(File bndFile) {
        this._bndFile = bndFile;
    }

    public void setNewCompatJarFile(File newCompatJarFile) {
        this._newCompatJarFile = newCompatJarFile;
    }

    public void setNewJarFile(File newJarFile) {
        this._newJarFile = newJarFile;
    }

    public void setOldJarFile(File oldJarFile) {
        this._oldJarFile = oldJarFile;
    }

    public void trace(String format, Object ... args) {
    }

    @Override
    protected void doBeforeExecute() throws BuildException {
        super.doBeforeExecute();
        if (this._bndFile == null || !this._bndFile.exists() || this._bndFile.isDirectory()) {
            if (this._bndFile != null) {
                this.log("File is either missing or is a directory " + this._bndFile.getAbsolutePath(), 0);
            }
            throw new BuildException("Bnd file is invalid");
        }
        if (this._newJarFile == null) {
            throw new BuildException("New jar file is invalid");
        }
        this._forcePackageInfo = Boolean.parseBoolean(this.project.getProperty("baseline.force.package.info"));
        this._forceVersionOneOnAddedPackages = true;
        String forceVersionOneOnAddedPackages = this.project.getProperty("baseline.added.packages.force.version.one");
        if (forceVersionOneOnAddedPackages != null) {
            this._forceVersionOneOnAddedPackages = Boolean.parseBoolean(forceVersionOneOnAddedPackages);
        }
        this._reportLevel = this.project.getProperty("baseline.jar.report.level");
        if (this._reportLevel == null) {
            this._reportLevel = "";
        }
        this._reportLevelIsDiff = this._reportLevel.equals("diff");
        this._reportLevelIsOff = this._reportLevel.equals("off");
        this._reportLevelIsPersist = this._reportLevel.equals("persist");
        if (this._reportLevelIsPersist) {
            this._reportLevelIsDiff = true;
            File bndRootFile = this.getBndRootFile();
            File rootDir = bndRootFile.getParentFile();
            File baselineReportsDir = new File(rootDir, this.getBaselineReportsDirName());
            this._logFile = new File(baselineReportsDir, this._newJarFile.getName() + ".log");
        }
        this._reportOnlyDirtyPackages = Boolean.parseBoolean(this.project.getProperty("baseline.jar.report.only.dirty.packages"));
        String sourceDirName = this.project.getProperty("plugin.source.dir");
        if (sourceDirName == null) {
            sourceDirName = this.project.getBaseDir() + "/src";
        }
        this._sourceDir = new File(sourceDirName);
    }

    @Override
    protected void doExecute() throws Exception {
        if (this._reportLevelIsOff) {
            return;
        }
        Baseline baseline = new Baseline(){

            @Override
            protected void log(Reporter reporter) {
                BaselineJarTask.this.report(reporter);
            }

            @Override
            protected void log(String output) {
                BaselineJarTask.this.log(output, 1);
            }
        };
        if (this._reportLevelIsPersist) {
            baseline.setBndFile(this._bndFile);
        }
        Properties properties = baseline.getProperties();
        properties.putAll((Map<?, ?>)this.project.getProperties());
        properties.putAll(this.getBndFileProperties());
        baseline.setForcePackageInfo(this._forcePackageInfo);
        baseline.setForceVersionOneOnAddedPackages(this._forceVersionOneOnAddedPackages);
        baseline.setLogFile(this._logFile);
        baseline.setNewCompatJarFile(this._newCompatJarFile);
        baseline.setNewJarFile(this._newJarFile);
        baseline.setOldJarFile(this._oldJarFile);
        baseline.setReportDiff(this._reportLevelIsDiff);
        baseline.setReportOnlyDirtyPackages(this._reportOnlyDirtyPackages);
        baseline.setSourceDir(this._sourceDir);
        baseline.execute();
    }

    protected String getBaselineReportsDirName() {
        if (this._baselineReportsDirName != null) {
            return this._baselineReportsDirName;
        }
        this._baselineReportsDirName = this.project.getProperty("baseline.jar.reports.dir.name");
        if (this._baselineReportsDirName == null) {
            this._baselineReportsDirName = _BASELINE_REPORTS_DIR;
        }
        return this._baselineReportsDirName;
    }

    protected Map<? extends Object, ? extends Object> getBndFileProperties() throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(this._bndFile));
        return properties;
    }
}

