/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd.metatype;

import aQute.bnd.header.Parameters;
import aQute.bnd.make.metatype.MetaTypeReader;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import java.util.Collection;

public class MetatypePlugin
implements AnalyzerPlugin {
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Parameters parameters = analyzer.parseHeader(analyzer.getProperty("-metatype"));
        Jar jar = analyzer.getJar();
        for (String name : parameters.keySet()) {
            Collection metatypeClasses = analyzer.getClasses(new String[]{"", Clazz.QUERY.ANNOTATED.toString(), "aQute.bnd.annotation.metatype.Meta$OCD", Clazz.QUERY.NAMED.toString(), name});
            for (Clazz metatypeClass : metatypeClasses) {
                jar.putResource("OSGI-INF/metatype/" + metatypeClass.getFQN() + ".xml", (Resource)new MetaTypeReader(metatypeClass, analyzer));
            }
        }
        return false;
    }

    public String toString() {
        return "MetatypePlugin";
    }
}

