/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd.resource.bundle;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.libg.filters.AndFilter;
import aQute.libg.filters.Filter;
import aQute.libg.filters.LiteralFilter;
import aQute.libg.filters.NotFilter;
import aQute.libg.filters.SimpleFilter;
import com.liferay.ant.bnd.resource.bundle.SortedParameters;
import java.util.Set;

public class AggregateResourceBundleLoaderAnalyzerPlugin
implements AnalyzerPlugin {
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        SortedParameters parameters = new SortedParameters(analyzer.getProperty("-liferay-aggregate-resource-bundles"));
        if (parameters.isEmpty()) {
            return false;
        }
        Set aggregateResourceBundles = parameters.keySet();
        this.addProvideCapabilities(analyzer, aggregateResourceBundles);
        this.addRequireCapabilities(analyzer, aggregateResourceBundles);
        return true;
    }

    protected void addProvideCapabilities(Analyzer analyzer, Set<String> aggregateResourceBundles) {
        SortedParameters provideCapabilityHeaders = new SortedParameters(analyzer.getProperty("Provide-Capability"));
        Attrs attrs = new Attrs();
        attrs.put("aggregate", "true");
        attrs.put("bundle.symbolic.name", analyzer.getBsn());
        StringBuilder resourceBundleAggregate = new StringBuilder();
        AndFilter andFilter = new AndFilter();
        andFilter.addChild((Filter)new SimpleFilter("bundle.symbolic.name", analyzer.getBsn()));
        andFilter.addChild((Filter)new NotFilter((Filter)new LiteralFilter("(aggregate=true)")));
        andFilter.append(resourceBundleAggregate);
        for (String aggregateResourceBundle : aggregateResourceBundles) {
            resourceBundleAggregate.append(',');
            SimpleFilter filter = new SimpleFilter("bundle.symbolic.name", aggregateResourceBundle);
            filter.append(resourceBundleAggregate);
        }
        attrs.put("resource.bundle.aggregate:String", resourceBundleAggregate.toString());
        attrs.put("resource.bundle.base.name", "content.Language");
        String servletContextName = analyzer.getProperty("Web-ContextPath");
        servletContextName = servletContextName != null ? servletContextName.substring(1) : analyzer.getBsn();
        attrs.put("servlet.context.name", servletContextName);
        attrs.put("service.ranking", "1");
        Parameters parameters = new Parameters();
        parameters.add("liferay.resource.bundle", attrs);
        provideCapabilityHeaders.mergeWith(parameters, false);
        analyzer.setProperty("Provide-Capability", provideCapabilityHeaders.toString());
    }

    protected void addRequireCapabilities(Analyzer analyzer, Set<String> aggregateResourceBundles) {
        SortedParameters requireCapabilityHeaders = new SortedParameters(analyzer.getProperty("Require-Capability"));
        Parameters parameters = new Parameters();
        for (String aggregateResourceBundle : aggregateResourceBundles) {
            Attrs attrs = new Attrs();
            SimpleFilter filter = new SimpleFilter("bundle.symbolic.name", aggregateResourceBundle);
            attrs.put("filter:", filter.toString());
            parameters.add("liferay.resource.bundle", attrs);
        }
        requireCapabilityHeaders.mergeWith(parameters, false);
        analyzer.setProperty("Require-Capability", requireCapabilityHeaders.toString());
    }
}

