/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd.enterprise;

import aQute.bnd.component.DSAnnotationReader;
import aQute.bnd.component.HeaderReader;
import aQute.bnd.component.TagResource;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class EnterpriseAnalyzerPlugin
implements AnalyzerPlugin {
    private static final String _BASE_CLASS_BINARY_NAME = "com/liferay/portal/profile/BaseEnterpriseDSModulePortalProfile";
    private static final String _INTERFACE_NAME = "com.liferay.portal.profile.PortalProfile";
    private static final String _METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getObjectType((String)"org/osgi/service/component/ComponentContext")});

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        String liferayEnterpriseApp = analyzer.getProperty("Liferay-Enterprise-App");
        if (liferayEnterpriseApp == null) {
            return false;
        }
        String serviceComponent = analyzer.getProperty("Service-Component");
        if (serviceComponent == null || serviceComponent.isEmpty() || serviceComponent.contains("ModulePortalProfile.xml")) {
            return false;
        }
        this._processServiceComponent(analyzer, serviceComponent);
        this._processProvideCapability(analyzer);
        return true;
    }

    private Resource _generateClass(String classBinaryName) {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(50, 33, classBinaryName, null, _BASE_CLASS_BINARY_NAME, new String[0]);
        MethodVisitor constructorMethodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        constructorMethodVisitor.visitCode();
        constructorMethodVisitor.visitVarInsn(25, 0);
        constructorMethodVisitor.visitMethodInsn(183, _BASE_CLASS_BINARY_NAME, "<init>", "()V", false);
        constructorMethodVisitor.visitInsn(177);
        constructorMethodVisitor.visitMaxs(0, 0);
        constructorMethodVisitor.visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(4, "activate", _METHOD_DESCRIPTOR, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, classBinaryName, "init", _METHOD_DESCRIPTOR, false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return new EmbeddedResource(classWriter.toByteArray(), 0L);
    }

    private Resource _generateComponentDefinition(Analyzer analyzer, String modulePortalProfileClassName) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("activate:", "activate");
        properties.put("enabled:", "true");
        properties.put("immediate:", "true");
        properties.put("provide:", _INTERFACE_NAME);
        properties.put("version:", String.valueOf(DSAnnotationReader.V1_3));
        HeaderReader headerReader = new HeaderReader(analyzer);
        return new TagResource(headerReader.createComponentTag(modulePortalProfileClassName, modulePortalProfileClassName, properties));
    }

    private void _processProvideCapability(Analyzer analyzer) {
        Attrs attrs = new Attrs();
        attrs.put("objectClass:List<String>", _INTERFACE_NAME);
        attrs.put("uses:", "com.liferay.portal.profile");
        Parameters provideCapabilityHeaders = new Parameters(analyzer.getProperty("Provide-Capability"));
        provideCapabilityHeaders.add("osgi.service", attrs);
        analyzer.setProperty("Provide-Capability", provideCapabilityHeaders.toString());
    }

    private void _processServiceComponent(Analyzer analyzer, String serviceComponent) throws Exception {
        String bundleSymbolicName = analyzer.getBsn();
        String className = bundleSymbolicName.concat(".internal.portal.profile.ModulePortalProfile");
        String classBinaryName = className.replace('.', '/');
        Resource classResource = this._generateClass(classBinaryName);
        String classFile = classBinaryName.concat(".class");
        Jar jar = analyzer.getJar();
        jar.putResource(classFile, classResource);
        Map classes = analyzer.getClassspace();
        classes.put(analyzer.getTypeRefFromFQN(className), new Clazz(analyzer, classFile, classResource));
        String componentDefinitionFileName = "OSGI-INF/" + className + ".xml";
        jar.putResource(componentDefinitionFileName, this._generateComponentDefinition(analyzer, className));
        analyzer.setProperty("Service-Component", serviceComponent + "," + componentDefinitionFileName);
    }
}

