/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.storage;

import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Fields
implements Iterable<Field>,
Serializable {
    private final Map<String, Field> _fieldsMap = new HashMap<String, Field>();

    public boolean contains(String name) {
        return this._fieldsMap.containsKey(name);
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    public boolean equals(Object obj, boolean includePrivateFields) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fields)) {
            return false;
        }
        Fields fields = (Fields)obj;
        if (includePrivateFields) {
            return Validator.equals(this._fieldsMap, fields._fieldsMap);
        }
        List<Field> fieldList1 = this.getFieldsList(includePrivateFields);
        List<Field> fieldList2 = fields.getFieldsList(includePrivateFields);
        if (fieldList1.size() != fieldList2.size()) {
            return false;
        }
        return fieldList1.containsAll(fieldList2);
    }

    public Field get(String name) {
        return this._fieldsMap.get(name);
    }

    public Set<Locale> getAvailableLocales() {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (Field field : this._fieldsMap.values()) {
            if (field.isPrivate()) continue;
            for (Locale availableLocale : field.getAvailableLocales()) {
                availableLocales.add(availableLocale);
            }
        }
        return availableLocales;
    }

    public long getDDMStructureId() {
        long ddmStructureId = 0L;
        Iterator<Field> itr = this.iterator();
        if (itr.hasNext()) {
            Field field = itr.next();
            ddmStructureId = field.getDDMStructureId();
        }
        return ddmStructureId;
    }

    public Locale getDefaultLocale() {
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        Iterator<Field> itr = this.iterator();
        if (itr.hasNext()) {
            Field field = itr.next();
            defaultLocale = field.getDefaultLocale();
        }
        return defaultLocale;
    }

    public Set<String> getNames() {
        return this._fieldsMap.keySet();
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, this._fieldsMap);
        return HashUtil.hash((int)hash, this.getFieldsList(true));
    }

    @Override
    public Iterator<Field> iterator() {
        return this.iterator(false);
    }

    public Iterator<Field> iterator(boolean includePrivateFields) {
        return this.iterator(null, includePrivateFields);
    }

    public Iterator<Field> iterator(Comparator<Field> comparator, boolean includePrivateFields) {
        List<Field> fieldsList = this.getFieldsList(includePrivateFields);
        if (comparator != null) {
            Collections.sort(fieldsList, comparator);
        }
        return fieldsList.iterator();
    }

    public void put(Field field) {
        this._fieldsMap.put(field.getName(), field);
    }

    public Field remove(String name) {
        return this._fieldsMap.remove(name);
    }

    protected List<Field> getFieldsList(boolean includePrivateFields) {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Field field : this._fieldsMap.values()) {
            if (!includePrivateFields && field.isPrivate()) continue;
            fieldsList.add(field);
        }
        return fieldsList;
    }
}

