/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import aQute.bnd.annotation.ProviderType;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.util.DDMDisplay;
import com.liferay.dynamic.data.mapping.util.DDMNavigationHelper;
import com.liferay.dynamic.data.mapping.util.DDMNavigationHelperImpl;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@ProviderType
public abstract class BaseDDMDisplay
implements DDMDisplay {
    private static final Set<String> _templateLanguageTypes = SetUtil.fromArray((Object[])new String[]{"ftl", "vm"});
    private static final Set<String> _viewTemplateExcludedColumnNames = SetUtil.fromArray((Object[])new String[]{"structure"});

    @Override
    public String getAvailableFields() {
        return "Liferay.FormBuilder.AVAILABLE_FIELDS.DDM_STRUCTURE";
    }

    @Override
    public String getConfirmSelectStructureMessage(Locale locale) {
        return "";
    }

    @Override
    public String getConfirmSelectTemplateMessage(Locale locale) {
        return "";
    }

    @Override
    public DDMNavigationHelper getDDMNavigationHelper() {
        return new DDMNavigationHelperImpl();
    }

    @Override
    public String getDefaultTemplateLanguage() {
        return "ftl";
    }

    @Override
    public String getEditStructureDefaultValuesURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, DDMStructure structure, String redirectURL) throws Exception {
        return null;
    }

    @Override
    public String getEditTemplateBackURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classNameId, long classPK, long resourceClassNameId, String portletResource) throws Exception {
        return this.getViewTemplatesURL(liferayPortletRequest, liferayPortletResponse, classNameId, classPK, resourceClassNameId);
    }

    @Override
    public String getEditTemplateTitle(DDMStructure structure, DDMTemplate template, Locale locale) {
        if (structure != null && template != null) {
            return StringUtil.appendParentheticalSuffix((String)template.getName(locale), (String)structure.getName(locale));
        }
        if (structure != null) {
            ResourceBundle resourceBundle = this.getResourceBundle(locale);
            return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"new-template-for-structure-x", (Object)structure.getName(locale), (boolean)false);
        }
        if (template != null) {
            return template.getName(locale);
        }
        return this.getDefaultEditTemplateTitle(locale);
    }

    @Override
    public String getEditTemplateTitle(long classNameId, Locale locale) {
        TemplateHandler templateHandler;
        if (classNameId > 0L && (templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((long)classNameId)) != null) {
            return LanguageUtil.get((Locale)locale, (String)"new") + " " + templateHandler.getName(locale);
        }
        return this.getDefaultEditTemplateTitle(locale);
    }

    @Override
    public String getStorageType() {
        return "";
    }

    @Override
    public String getStructureName(Locale locale) {
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"structure");
    }

    @Override
    public String getStructureType() {
        return "";
    }

    @Override
    public long[] getTemplateClassNameIds(long classNameId) {
        if (classNameId > 0L) {
            return new long[]{classNameId};
        }
        return TemplateHandlerRegistryUtil.getClassNameIds();
    }

    @Override
    public long[] getTemplateClassPKs(long companyId, long classNameId, long classPK) throws Exception {
        if (classPK > 0L) {
            return new long[]{classPK};
        }
        ArrayList<Long> classPKs = new ArrayList<Long>();
        classPKs.add(0L);
        List<DDMStructure> structures = DDMStructureLocalServiceUtil.getClassStructures(companyId, PortalUtil.getClassNameId((String)this.getStructureType()));
        for (DDMStructure structure : structures) {
            classPKs.add(structure.getPrimaryKey());
        }
        return ArrayUtil.toLongArray(classPKs);
    }

    @Override
    public long[] getTemplateGroupIds(ThemeDisplay themeDisplay, boolean includeAncestorTemplates) throws Exception {
        if (includeAncestorTemplates) {
            return PortalUtil.getCurrentAndAncestorSiteGroupIds((long)themeDisplay.getScopeGroupId());
        }
        return new long[]{themeDisplay.getScopeGroupId()};
    }

    @Override
    public long getTemplateHandlerClassNameId(DDMTemplate template, long classNameId) {
        if (template != null) {
            return template.getClassNameId();
        }
        return classNameId;
    }

    @Override
    public Set<String> getTemplateLanguageTypes() {
        return _templateLanguageTypes;
    }

    @Override
    public String getTemplateMode() {
        return "";
    }

    @Override
    public String getTemplateType() {
        return "";
    }

    @Override
    public String getTemplateType(DDMTemplate template, Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)template.getType());
    }

    @Override
    public String getTitle(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"structures");
    }

    @Override
    public String getViewStructuresBackURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        return ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"backURL");
    }

    @Override
    public String getViewTemplatesBackURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classPK) throws Exception {
        DDMNavigationHelper ddmNavigationHelper = this.getDDMNavigationHelper();
        if (ddmNavigationHelper.isNavigationStartsOnSelectStructure(liferayPortletRequest)) {
            return ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"redirect");
        }
        String portletId = PortletProviderUtil.getPortletId((String)DDMStructure.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (String)portletId, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/view.jsp");
        return portletURL.toString();
    }

    @Override
    public Set<String> getViewTemplatesExcludedColumnNames() {
        return _viewTemplateExcludedColumnNames;
    }

    @Override
    public String getViewTemplatesTitle(DDMStructure structure, boolean controlPanel, boolean search, Locale locale) {
        if (structure != null) {
            ResourceBundle resourceBundle = this.getResourceBundle(locale);
            return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"templates-for-structure-x", (Object)structure.getName(locale), (boolean)false);
        }
        return this.getDefaultViewTemplateTitle(locale);
    }

    @Override
    @Deprecated
    public String getViewTemplatesTitle(DDMStructure structure, boolean controlPanel, Locale locale) {
        return this.getViewTemplatesTitle(structure, controlPanel, false, locale);
    }

    @Override
    public String getViewTemplatesTitle(DDMStructure structure, Locale locale) {
        return this.getViewTemplatesTitle(structure, false, false, locale);
    }

    @Override
    public boolean isShowAddStructureButton() {
        String ddmStructurePortletId;
        String portletId = this.getPortletId();
        return !portletId.equals(ddmStructurePortletId = PortletProviderUtil.getPortletId((String)DDMStructure.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW));
    }

    @Override
    public boolean isShowBackURLInTitleBar() {
        return false;
    }

    @Override
    public boolean isShowConfirmSelectStructure() {
        return false;
    }

    @Override
    public boolean isShowConfirmSelectTemplate() {
        return false;
    }

    @Override
    public boolean isShowStructureSelector() {
        return false;
    }

    @Override
    public boolean isVersioningEnabled() {
        return false;
    }

    protected ResourceBundle getBaseDDMDisplayResourceBundle(String languageId) {
        Class<BaseDDMDisplay> baseDDMDisplayClazz = BaseDDMDisplay.class;
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)LocaleUtil.fromLanguageId((String)languageId), (ClassLoader)baseDDMDisplayClazz.getClassLoader());
    }

    protected ResourceBundle getDDMDisplayResourceBundle(String languageId) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)bundle.getSymbolicName());
        if (resourceBundleLoader == null) {
            return null;
        }
        return resourceBundleLoader.loadResourceBundle(languageId);
    }

    protected String getDefaultEditTemplateTitle(Locale locale) {
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"new-template");
    }

    protected String getDefaultViewTemplateTitle(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"templates");
    }

    protected ResourceBundle getPortalResourceBundle(String languageId) {
        ResourceBundleLoader portalResourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        return portalResourceBundleLoader.loadResourceBundle(languageId);
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        ResourceBundle ddmDisplayResourceBundle = this.getDDMDisplayResourceBundle(languageId);
        if (ddmDisplayResourceBundle == null) {
            return new AggregateResourceBundle(new ResourceBundle[]{this.getBaseDDMDisplayResourceBundle(languageId), this.getPortalResourceBundle(languageId)});
        }
        return new AggregateResourceBundle(new ResourceBundle[]{ddmDisplayResourceBundle, this.getBaseDDMDisplayResourceBundle(languageId), this.getPortalResourceBundle(languageId)});
    }

    protected String getViewTemplatesURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classNameId, long classPK, long resourceClassNameId) throws Exception {
        String portletId = PortletProviderUtil.getPortletId((String)DDMStructure.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (String)portletId, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/view_template.jsp");
        portletURL.setParameter("classNameId", String.valueOf(classNameId));
        portletURL.setParameter("classPK", String.valueOf(classPK));
        portletURL.setParameter("resourceClassNameId", String.valueOf(resourceClassNameId));
        return portletURL.toString();
    }
}

