/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldRule;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DDMFormField
implements Serializable {
    private DDMForm _ddmForm;
    private List<DDMFormFieldRule> _ddmFormFieldRules = new ArrayList<DDMFormFieldRule>();
    private List<DDMFormField> _nestedDDMFormFields = new ArrayList<DDMFormField>();
    private final Map<String, Object> _properties;

    public DDMFormField() {
        this._properties = new LinkedHashMap<String, Object>();
    }

    public DDMFormField(DDMFormField ddmFormField) {
        this._properties = new LinkedHashMap<String, Object>(ddmFormField._properties);
        this.setDDMFormFieldOptions(new DDMFormFieldOptions(ddmFormField.getDDMFormFieldOptions()));
        for (DDMFormFieldRule ddmFormFieldRule : ddmFormField._ddmFormFieldRules) {
            this.addDDMFormFieldRule(new DDMFormFieldRule(ddmFormFieldRule));
        }
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        if (ddmFormFieldValidation != null) {
            this.setDDMFormFieldValidation(new DDMFormFieldValidation(ddmFormFieldValidation));
        }
        this.setLabel(new LocalizedValue(ddmFormField.getLabel()));
        this.setPredefinedValue(new LocalizedValue(ddmFormField.getPredefinedValue()));
        this.setStyle(new LocalizedValue(ddmFormField.getStyle()));
        this.setTip(new LocalizedValue(ddmFormField.getTip()));
        for (DDMFormField nestedDDMFormField : ddmFormField._nestedDDMFormFields) {
            this.addNestedDDMFormField(new DDMFormField(nestedDDMFormField));
        }
    }

    public DDMFormField(String name, String type) {
        this._properties = new LinkedHashMap<String, Object>();
        this.setName(name);
        this.setType(type);
        this.setDDMFormFieldOptions(new DDMFormFieldOptions());
        this.setLabel(new LocalizedValue());
        this.setPredefinedValue(new LocalizedValue());
        this.setStyle(new LocalizedValue());
        this.setTip(new LocalizedValue());
    }

    @Deprecated
    public void addDDMFormFieldRule(DDMFormFieldRule ddmFormFieldRule) {
        this._ddmFormFieldRules.add(ddmFormFieldRule);
    }

    public void addNestedDDMFormField(DDMFormField nestedDDMFormField) {
        nestedDDMFormField.setDDMForm(this._ddmForm);
        this._nestedDDMFormFields.add(nestedDDMFormField);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DDMFormField)) {
            return false;
        }
        DDMFormField ddmFormField = (DDMFormField)obj;
        return Objects.equals(this._properties, ddmFormField._properties) && Objects.equals(this._nestedDDMFormFields, ddmFormField._nestedDDMFormFields);
    }

    public String getDataType() {
        return MapUtil.getString(this._properties, (String)"dataType");
    }

    public DDMForm getDDMForm() {
        return this._ddmForm;
    }

    public DDMFormFieldOptions getDDMFormFieldOptions() {
        return (DDMFormFieldOptions)this._properties.get("options");
    }

    @Deprecated
    public List<DDMFormFieldRule> getDDMFormFieldRules() {
        return this._ddmFormFieldRules;
    }

    public DDMFormFieldValidation getDDMFormFieldValidation() {
        Object value = this._properties.get("validation");
        if (value instanceof DDMFormFieldValidation) {
            return (DDMFormFieldValidation)value;
        }
        return null;
    }

    public String getFieldNamespace() {
        return MapUtil.getString(this._properties, (String)"fieldNamespace");
    }

    public String getIndexType() {
        return MapUtil.getString(this._properties, (String)"indexType");
    }

    public LocalizedValue getLabel() {
        return (LocalizedValue)this._properties.get("label");
    }

    public String getName() {
        return MapUtil.getString(this._properties, (String)"name");
    }

    public List<DDMFormField> getNestedDDMFormFields() {
        return this._nestedDDMFormFields;
    }

    public Map<String, DDMFormField> getNestedDDMFormFieldsMap() {
        LinkedHashMap<String, DDMFormField> nestedDDMFormFieldsMap = new LinkedHashMap<String, DDMFormField>();
        for (DDMFormField nestedDDMFormField : this._nestedDDMFormFields) {
            nestedDDMFormFieldsMap.put(nestedDDMFormField.getName(), nestedDDMFormField);
            nestedDDMFormFieldsMap.putAll(nestedDDMFormField.getNestedDDMFormFieldsMap());
        }
        return nestedDDMFormFieldsMap;
    }

    public Map<String, DDMFormField> getNontransientNestedDDMFormFieldsMap() {
        LinkedHashMap<String, DDMFormField> nestedDDMFormFieldsMap = new LinkedHashMap<String, DDMFormField>();
        for (DDMFormField nestedDDMFormField : this._nestedDDMFormFields) {
            if (!nestedDDMFormField.isTransient()) {
                nestedDDMFormFieldsMap.put(nestedDDMFormField.getName(), nestedDDMFormField);
            }
            nestedDDMFormFieldsMap.putAll(nestedDDMFormField.getNontransientNestedDDMFormFieldsMap());
        }
        return nestedDDMFormFieldsMap;
    }

    public LocalizedValue getPredefinedValue() {
        return (LocalizedValue)this._properties.get("predefinedValue");
    }

    public Map<String, Object> getProperties() {
        return this._properties;
    }

    public Object getProperty(String name) {
        return this._properties.get(name);
    }

    public LocalizedValue getStyle() {
        return (LocalizedValue)this._properties.get("style");
    }

    public LocalizedValue getTip() {
        return (LocalizedValue)this._properties.get("tip");
    }

    public String getType() {
        return MapUtil.getString(this._properties, (String)"type");
    }

    public String getVisibilityExpression() {
        return MapUtil.getString(this._properties, (String)"visibilityExpression");
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, this._properties);
        return HashUtil.hash((int)hash, this._nestedDDMFormFields);
    }

    public boolean isLocalizable() {
        return MapUtil.getBoolean(this._properties, (String)"localizable");
    }

    public boolean isMultiple() {
        return MapUtil.getBoolean(this._properties, (String)"multiple");
    }

    public boolean isReadOnly() {
        return MapUtil.getBoolean(this._properties, (String)"readOnly");
    }

    public boolean isRepeatable() {
        return MapUtil.getBoolean(this._properties, (String)"repeatable");
    }

    public boolean isRequired() {
        return MapUtil.getBoolean(this._properties, (String)"required");
    }

    public boolean isShowLabel() {
        return MapUtil.getBoolean(this._properties, (String)"showLabel", (boolean)true);
    }

    public boolean isTransient() {
        return Validator.isNull((String)this.getDataType());
    }

    public void setDataType(String dataType) {
        this._properties.put("dataType", dataType);
    }

    public void setDDMForm(DDMForm ddmForm) {
        for (DDMFormField nestedDDMFormField : this._nestedDDMFormFields) {
            nestedDDMFormField.setDDMForm(ddmForm);
        }
        this._ddmForm = ddmForm;
    }

    public void setDDMFormFieldOptions(DDMFormFieldOptions ddmFormFieldOptions) {
        this._properties.put("options", ddmFormFieldOptions);
    }

    @Deprecated
    public void setDDMFormFieldRules(List<DDMFormFieldRule> ddmFormFieldRules) {
        this._ddmFormFieldRules = ddmFormFieldRules;
    }

    public void setDDMFormFieldValidation(DDMFormFieldValidation ddmFormFieldValidation) {
        this._properties.put("validation", ddmFormFieldValidation);
    }

    public void setFieldNamespace(String fieldNamespace) {
        this._properties.put("fieldNamespace", fieldNamespace);
    }

    public void setIndexType(String indexType) {
        this._properties.put("indexType", indexType);
    }

    public void setLabel(LocalizedValue label) {
        this._properties.put("label", label);
    }

    public void setLocalizable(boolean localizable) {
        this._properties.put("localizable", localizable);
    }

    public void setMultiple(boolean multiple) {
        this._properties.put("multiple", multiple);
    }

    public void setName(String name) {
        this._properties.put("name", name);
    }

    public void setNestedDDMFormFields(List<DDMFormField> nestedDDMFormFields) {
        this._nestedDDMFormFields = nestedDDMFormFields;
    }

    public void setPredefinedValue(LocalizedValue predefinedValue) {
        this._properties.put("predefinedValue", predefinedValue);
    }

    public void setProperty(String name, Object value) {
        this._properties.put(name, value);
    }

    public void setReadOnly(boolean readOnly) {
        this._properties.put("readOnly", readOnly);
    }

    public void setRepeatable(boolean repeatable) {
        this._properties.put("repeatable", repeatable);
    }

    public void setRequired(boolean required) {
        this._properties.put("required", required);
    }

    public void setShowLabel(boolean showLabel) {
        this._properties.put("showLabel", showLabel);
    }

    public void setStyle(LocalizedValue style) {
        this._properties.put("style", style);
    }

    public void setTip(LocalizedValue tip) {
        this._properties.put("tip", tip);
    }

    public void setType(String type) {
        this._properties.put("type", type);
    }

    public void setVisibilityExpression(String visibilityExpression) {
        this._properties.put("visibilityExpression", visibilityExpression);
    }
}

