/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.poshi.runner;

import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerExtension;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class PoshiRunnerPlugin
implements Plugin<Project> {
    public static final String EVALUATE_POSHI_CONSOLE_TASK_NAME = "evaluatePoshiConsole";
    public static final String EXPAND_POSHI_RUNNER_TASK_NAME = "expandPoshiRunner";
    public static final String POSHI_RUNNER_CONFIGURATION_NAME = "poshiRunner";
    public static final String RUN_POSHI_TASK_NAME = "runPoshi";
    public static final String SIKULI_CONFIGURATION_NAME = "sikuli";
    public static final String VALIDATE_POSHI_TASK_NAME = "validatePoshi";
    public static final String WRITE_POSHI_PROPERTIES_TASK_NAME = "writePoshiProperties";
    private static final String _START_TESTABLE_TOMCAT_TASK_NAME = "startTestableTomcat";
    private static final String _STOP_TESTABLE_TOMCAT_TASK_NAME = "stopTestableTomcat";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        final PoshiRunnerExtension poshiRunnerExtension = (PoshiRunnerExtension)GradleUtil.addExtension((ExtensionAware)project, (String)POSHI_RUNNER_CONFIGURATION_NAME, PoshiRunnerExtension.class);
        this.addConfigurationPoshiRunner(project, poshiRunnerExtension);
        this.addConfigurationSikuli(project, poshiRunnerExtension);
        final JavaExec evaluatePoshiConsoleTask = this.addTaskEvaluatePoshiConsole(project);
        this.addTaskExpandPoshiRunner(project);
        final Test runPoshiTask = this.addTaskRunPoshi(project);
        final JavaExec validatePoshiTask = this.addTaskValidatePoshi(project);
        final JavaExec writePoshiPropertiesTask = this.addTaskWritePoshiProperties(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Properties poshiProperties = null;
                File poshiPropertiesFile = poshiRunnerExtension.getPoshiPropertiesFile();
                if (poshiPropertiesFile != null && poshiPropertiesFile.exists()) {
                    poshiProperties = GUtil.loadProperties((File)poshiPropertiesFile);
                }
                PoshiRunnerPlugin.this.configureTaskEvaluatePoshiConsole(evaluatePoshiConsoleTask, poshiProperties, poshiRunnerExtension);
                PoshiRunnerPlugin.this.configureTaskRunPoshi(runPoshiTask, poshiProperties, poshiRunnerExtension);
                PoshiRunnerPlugin.this.configureTaskValidatePoshi(validatePoshiTask, poshiProperties, poshiRunnerExtension);
                PoshiRunnerPlugin.this.configureTaskWritePoshiProperties(writePoshiPropertiesTask, poshiProperties, poshiRunnerExtension);
            }
        });
    }

    protected Configuration addConfigurationPoshiRunner(final Project project, final PoshiRunnerExtension poshiRunnerExtension) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)POSHI_RUNNER_CONFIGURATION_NAME);
        configuration.setDescription("Configures Poshi Runner for this project.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                PoshiRunnerPlugin.this.addDependenciesPoshiRunner(project, poshiRunnerExtension);
            }
        });
        return configuration;
    }

    protected Configuration addConfigurationSikuli(final Project project, final PoshiRunnerExtension poshiRunnerExtension) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)SIKULI_CONFIGURATION_NAME);
        configuration.setDescription("Configures Sikuli for this project.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                PoshiRunnerPlugin.this.addDependenciesSikuli(project, poshiRunnerExtension);
            }
        });
        return configuration;
    }

    protected void addDependenciesPoshiRunner(Project project, PoshiRunnerExtension poshiRunnerExtension) {
        GradleUtil.addDependency((Project)project, (String)POSHI_RUNNER_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.poshi.runner", (String)poshiRunnerExtension.getVersion());
    }

    protected void addDependenciesSikuli(Project project, PoshiRunnerExtension poshiRunnerExtension) {
        String bitMode = OSDetector.getBitmode();
        bitMode = bitMode.equals("32") ? "x86" : "x86_64";
        String os = "linux";
        if (OSDetector.isApple()) {
            os = "macosx";
        } else if (OSDetector.isWindows()) {
            os = "windows";
        }
        String classifier = os + "-" + bitMode;
        GradleUtil.addDependency((Project)project, (String)SIKULI_CONFIGURATION_NAME, (String)"org.bytedeco.javacpp-presets", (String)"opencv", (String)poshiRunnerExtension.getOpenCVVersion(), (String)classifier, (boolean)true);
    }

    protected JavaExec addTaskEvaluatePoshiConsole(Project project) {
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)EVALUATE_POSHI_CONSOLE_TASK_NAME, JavaExec.class);
        javaExec.setClasspath(this.getPoshiRunnerClasspath(project));
        javaExec.setDescription("Evaluate the console output errors.");
        javaExec.setGroup("verification");
        javaExec.setMain("com.liferay.poshi.runner.PoshiRunnerConsoleEvaluator");
        return javaExec;
    }

    protected Copy addTaskExpandPoshiRunner(final Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)EXPAND_POSHI_RUNNER_TASK_NAME, Copy.class);
        Closure<Void> closure = new Closure<Void>((Object)project){

            public FileTree doCall() {
                Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)PoshiRunnerPlugin.POSHI_RUNNER_CONFIGURATION_NAME);
                for (File file : configuration) {
                    String fileName = file.getName();
                    if (!fileName.startsWith("com.liferay.poshi.runner-")) continue;
                    return project.zipTree((Object)file);
                }
                return null;
            }
        };
        copy.from(new Object[]{closure});
        copy.into((Object)this.getExpandedPoshiRunnerDir(project));
        return copy;
    }

    protected Test addTaskRunPoshi(Project project) {
        final Test test = (Test)GradleUtil.addTask((Project)project, (String)RUN_POSHI_TASK_NAME, Test.class);
        test.dependsOn(new Object[]{"clean" + StringUtil.capitalize((String)RUN_POSHI_TASK_NAME), EXPAND_POSHI_RUNNER_TASK_NAME});
        test.include(new String[]{"com/liferay/poshi/runner/PoshiRunner.class"});
        test.setClasspath(this.getPoshiRunnerClasspath(project));
        test.setDefaultCharacterEncoding(StandardCharsets.UTF_8.toString());
        test.setDescription("Execute tests using Poshi Runner.");
        test.setGroup("verification");
        test.setScanForTestClasses(false);
        test.setTestClassesDir(this.getExpandedPoshiRunnerDir(project));
        TestLoggingContainer testLoggingContainer = test.getTestLogging();
        testLoggingContainer.setShowStandardStreams(true);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withId("com.liferay.test.integration", (Action)new Action<Plugin>(){

            public void execute(Plugin plugin) {
                test.dependsOn(new Object[]{PoshiRunnerPlugin._START_TESTABLE_TOMCAT_TASK_NAME});
                Task task = GradleUtil.getTask((Project)test.getProject(), (String)PoshiRunnerPlugin._STOP_TESTABLE_TOMCAT_TASK_NAME);
                task.mustRunAfter(new Object[]{test});
            }
        });
        return test;
    }

    protected JavaExec addTaskValidatePoshi(Project project) {
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)VALIDATE_POSHI_TASK_NAME, JavaExec.class);
        javaExec.setClasspath(this.getPoshiRunnerClasspath(project));
        javaExec.setDescription("Validates the Poshi files syntax.");
        javaExec.setGroup("verification");
        javaExec.setMain("com.liferay.poshi.runner.PoshiRunnerValidation");
        return javaExec;
    }

    protected JavaExec addTaskWritePoshiProperties(Project project) {
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)WRITE_POSHI_PROPERTIES_TASK_NAME, JavaExec.class);
        javaExec.setClasspath(this.getPoshiRunnerClasspath(project));
        javaExec.setDescription("Write the Poshi properties files.");
        javaExec.setGroup("verification");
        javaExec.setMain("com.liferay.poshi.runner.PoshiRunnerContext");
        return javaExec;
    }

    protected void configureTaskEvaluatePoshiConsole(JavaExec javaExec, Properties poshiProperties, PoshiRunnerExtension poshiRunnerExtension) {
        this.populateSystemProperties(javaExec.getSystemProperties(), poshiProperties, poshiRunnerExtension);
    }

    protected void configureTaskRunPoshi(Test test, Properties poshiProperties, PoshiRunnerExtension poshiRunnerExtension) {
        this.configureTaskRunPoshiBinResultsDir(test);
        this.configureTaskRunPoshiReports(test);
        this.populateSystemProperties(test.getSystemProperties(), poshiProperties, poshiRunnerExtension);
    }

    protected void configureTaskRunPoshiBinResultsDir(Test test) {
        if (test.getBinResultsDir() != null) {
            return;
        }
        Project project = test.getProject();
        test.setBinResultsDir(project.file((Object)"test-results/binary/runPoshi"));
    }

    protected void configureTaskRunPoshiReports(Test test) {
        Project project = test.getProject();
        TestTaskReports testTaskReports = test.getReports();
        DirectoryReport directoryReport = testTaskReports.getHtml();
        if (directoryReport.getDestination() == null) {
            directoryReport.setDestination((Object)project.file((Object)"tests"));
        }
        if ((directoryReport = testTaskReports.getJunitXml()).getDestination() == null) {
            directoryReport.setDestination((Object)project.file((Object)"test-results"));
        }
    }

    protected void configureTaskValidatePoshi(JavaExec javaExec, Properties poshiProperties, PoshiRunnerExtension poshiRunnerExtension) {
        this.populateSystemProperties(javaExec.getSystemProperties(), poshiProperties, poshiRunnerExtension);
    }

    protected void configureTaskWritePoshiProperties(JavaExec javaExec, Properties poshiProperties, PoshiRunnerExtension poshiRunnerExtension) {
        this.populateSystemProperties(javaExec.getSystemProperties(), poshiProperties, poshiRunnerExtension);
    }

    protected File getExpandedPoshiRunnerDir(Project project) {
        return new File(project.getBuildDir(), "poshi-runner");
    }

    protected FileCollection getPoshiRunnerClasspath(Project project) {
        Configuration poshiRunnerConfiguration = GradleUtil.getConfiguration((Project)project, (String)POSHI_RUNNER_CONFIGURATION_NAME);
        Configuration sikuliConfiguration = GradleUtil.getConfiguration((Project)project, (String)SIKULI_CONFIGURATION_NAME);
        return project.files(new Object[]{poshiRunnerConfiguration, sikuliConfiguration});
    }

    protected void populateSystemProperties(Map<String, Object> systemProperties, Properties poshiProperties, PoshiRunnerExtension poshiRunnerExtension) {
        String testName;
        List<String> testNames;
        if (poshiProperties != null) {
            Enumeration<?> enumeration = poshiProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = poshiProperties.getProperty(key);
                systemProperties.put(key, value);
            }
        }
        systemProperties.putAll(poshiRunnerExtension.getPoshiProperties());
        File baseDir = poshiRunnerExtension.getBaseDir();
        if (baseDir != null && baseDir.exists()) {
            systemProperties.put("test.base.dir.name", poshiRunnerExtension.project.relativePath((Object)baseDir));
        }
        if (!(testNames = poshiRunnerExtension.getTestNames()).isEmpty()) {
            systemProperties.put("test.name", CollectionUtils.join((String)",", testNames));
        }
        if (Validator.isNotNull((String)(testName = GradleUtil.getProperty((ExtensionAware)poshiRunnerExtension.project, (String)"poshiTestName", (String)null)))) {
            systemProperties.put("test.name", testName);
        }
    }
}

