/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.lang.builder.BuildLangTask;
import com.liferay.gradle.plugins.lang.builder.LangBuilderPlugin;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.PackageRunBuildTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class LiferayThemePlugin
implements Plugin<Project> {
    public static final String CREATE_LIFERAY_THEME_JSON_TASK_NAME = "createLiferayThemeJson";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        GradleUtil.applyPlugin((Project)project, LangBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        ExtensionContainer extensionContainer = project.getExtensions();
        LiferayExtension liferayExtension = (LiferayExtension)extensionContainer.getByType(LiferayExtension.class);
        Convention convention = project.getConvention();
        BasePluginConvention basePluginConvention = (BasePluginConvention)convention.getPlugin(BasePluginConvention.class);
        Map<String, Object> packageJsonMap = this._getPackageJsonMap(project);
        this._configureConventionBasePlugin(basePluginConvention, packageJsonMap);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration archivesConfiguration = configurationContainer.getByName("archives");
        Configuration defaultConfiguration = configurationContainer.getByName("default");
        this._configureConfigurationDefault(archivesConfiguration, defaultConfiguration);
        TaskProvider cleanTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"clean", Delete.class);
        final TaskProvider createLiferayThemeJsonTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)CREATE_LIFERAY_THEME_JSON_TASK_NAME, Task.class);
        TaskProvider buildLangTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"buildLang", BuildLangTask.class);
        TaskProvider deployTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"deploy", Copy.class);
        this._configureTaskBuildLangProvider((TaskProvider<BuildLangTask>)buildLangTaskProvider);
        this._configureTaskCleanProvider((TaskProvider<Delete>)cleanTaskProvider);
        this._configureTaskCreateLiferayThemeJsonProvider(project, liferayExtension, (TaskProvider<Task>)createLiferayThemeJsonTaskProvider);
        this._configureTaskDeployProvider(project, (TaskProvider<Copy>)deployTaskProvider);
        final TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PackageRunBuildTask.class, (Action)new Action<PackageRunBuildTask>(){

            public void execute(PackageRunBuildTask packageRunBuildTask) {
                LiferayThemePlugin.this._configureTaskPackageRunBuild((TaskProvider<Task>)createLiferayThemeJsonTaskProvider, packageRunBuildTask);
            }
        });
        this._configureProject(project, packageJsonMap);
        ArtifactHandler artifacts = project.getArtifacts();
        artifacts.add("archives", (Object)this._getWarFile(project), (Closure)new Closure<Void>((Object)project){

            public void doCall(ConfigurablePublishArtifact configurablePublishArtifact) {
                Task packageRunBuildTask = (Task)taskContainer.findByName("packageRunBuild");
                if (packageRunBuildTask != null) {
                    configurablePublishArtifact.builtBy(new Object[]{packageRunBuildTask});
                }
            }
        });
    }

    private void _configureConfigurationDefault(Configuration archivesConfiguration, Configuration defaultConfiguration) {
        defaultConfiguration.extendsFrom(new Configuration[]{archivesConfiguration});
    }

    private void _configureConventionBasePlugin(BasePluginConvention basePluginConvention, Map<String, Object> packageJsonMap) {
        String name = null;
        Map liferayThemeMap = (Map)packageJsonMap.get("liferayTheme");
        if (liferayThemeMap != null) {
            name = (String)liferayThemeMap.get("distName");
        }
        if (Validator.isNull(name)) {
            name = (String)packageJsonMap.get("name");
        }
        if (Validator.isNull((String)name)) {
            return;
        }
        basePluginConvention.setArchivesBaseName(name);
    }

    private void _configureProject(Project project, Map<String, Object> packageJsonMap) {
        project.setBuildDir((Object)"build_gradle");
        String version = (String)packageJsonMap.get("version");
        if (Validator.isNotNull((String)version)) {
            project.setVersion((Object)version);
        }
    }

    private void _configureTaskBuildLangProvider(TaskProvider<BuildLangTask> buildLangTaskProvider) {
        buildLangTaskProvider.configure((Action)new Action<BuildLangTask>(){

            public void execute(BuildLangTask buildLangTask) {
                buildLangTask.setLangDir((Object)"src/WEB-INF/src/content");
            }
        });
    }

    private void _configureTaskCleanProvider(TaskProvider<Delete> cleanTaskProvider) {
        cleanTaskProvider.configure((Action)new Action<Delete>(){

            public void execute(Delete cleanDelete) {
                cleanDelete.delete(new Object[]{"build", "dist"});
            }
        });
    }

    private void _configureTaskCreateLiferayThemeJsonProvider(final Project project, final LiferayExtension liferayExtension, TaskProvider<Task> createLiferayThemeJsonTaskProvider) {
        createLiferayThemeJsonTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task createLiferayThemeJsonTask) {
                final File liferayThemeJsonFile = project.file((Object)"liferay-theme.json");
                createLiferayThemeJsonTask.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Project project = task.getProject();
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("appServerPath", FileUtil.getAbsolutePath((File)liferayExtension.getAppServerDir()));
                        File appServerThemeDir = new File(liferayExtension.getAppServerDeployDir(), project.getName());
                        map.put("appServerPathTheme", FileUtil.getAbsolutePath((File)appServerThemeDir));
                        map.put("deployed", false);
                        map.put("deployPath", FileUtil.getAbsolutePath((File)liferayExtension.getDeployDir()));
                        map.put("themeName", project.getName());
                        String json = JsonOutput.toJson(Collections.singletonMap("LiferayTheme", map));
                        try {
                            Files.write(liferayThemeJsonFile.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        }
                        catch (IOException ioException) {
                            throw new UncheckedIOException((Throwable)ioException);
                        }
                    }
                });
                createLiferayThemeJsonTask.setDescription("Generates the " + liferayThemeJsonFile.getName() + " file for this project.");
            }
        });
    }

    private void _configureTaskDeployProvider(final Project project, TaskProvider<Copy> deployTaskProvider) {
        deployTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy deployCopy) {
                deployCopy.dependsOn(new Object[]{"assemble"});
                deployCopy.from(new Object[]{LiferayThemePlugin.this._getWarFile(project)});
            }
        });
    }

    private void _configureTaskPackageRunBuild(TaskProvider<Task> createLiferayThemeJsonTaskProvider, PackageRunBuildTask packageRunBuildTask) {
        packageRunBuildTask.dependsOn(new Object[]{createLiferayThemeJsonTaskProvider});
    }

    private Map<String, Object> _getPackageJsonMap(Project project) {
        File file = project.file((Object)"package.json");
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        return (Map)jsonSlurper.parse(file);
    }

    private File _getWarFile(Project project) {
        return project.file((Object)("dist/" + GradleUtil.getArchivesBaseName(project) + ".war"));
    }
}

