/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.source.formatter.FormatSourceTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class SourceFormatterDefaultsPlugin
extends BaseDefaultsPlugin<SourceFormatterPlugin> {
    public static final Plugin<Project> INSTANCE = new SourceFormatterDefaultsPlugin();
    private static final String _PORTAL_TOOL_NAME = "com.liferay.source.formatter";

    @Override
    protected void applyPluginDefaults(final Project project, SourceFormatterPlugin sourceFormatterPlugin) {
        PortalTools.addPortalToolDependencies(project, "sourceFormatter", "com.liferay", _PORTAL_TOOL_NAME);
        final TaskProvider checkSourceFormattingTaskProvider = GradleUtil.fetchTaskProvider((Project)project, (String)"checkSourceFormatting", FormatSourceTask.class);
        final TaskProvider formatSourceTaskProvider = GradleUtil.fetchTaskProvider((Project)project, (String)"formatSource", FormatSourceTask.class);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FormatSourceTask.class, (Action)new Action<FormatSourceTask>(){

            public void execute(FormatSourceTask formatSourceTask) {
                SourceFormatterDefaultsPlugin.this._configureTaskFormatSource(formatSourceTask);
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(NodePlugin.class, (Action)new Action<NodePlugin>(){

            public void execute(NodePlugin nodePlugin) {
                SourceFormatterDefaultsPlugin.this._configurePluginNode(project, (TaskProvider<FormatSourceTask>)checkSourceFormattingTaskProvider, (TaskProvider<FormatSourceTask>)formatSourceTaskProvider);
            }
        });
    }

    @Override
    protected Class<SourceFormatterPlugin> getPluginClass() {
        return SourceFormatterPlugin.class;
    }

    private void _configurePluginNode(Project project, TaskProvider<FormatSourceTask> checkSourceFormattingTaskProvider, TaskProvider<FormatSourceTask> formatSourceTaskProvider) {
        String skipNodeTask;
        TaskProvider packageRunFormatTaskProvider;
        String skipNodeTask2;
        final TaskProvider packageRunCheckFormatTaskProvider = GradleUtil.fetchTaskProvider((Project)project, (String)"packageRunCheckFormat");
        if (packageRunCheckFormatTaskProvider != null && !Boolean.parseBoolean(skipNodeTask2 = GradleUtil.getTaskPrefixedProperty((String)project.getPath(), (String)checkSourceFormattingTaskProvider.getName(), (String)"skip.node.task"))) {
            checkSourceFormattingTaskProvider.configure((Action)new Action<FormatSourceTask>(){

                public void execute(FormatSourceTask checkSourceFormattingFormatSourceTask) {
                    checkSourceFormattingFormatSourceTask.finalizedBy(new Object[]{packageRunCheckFormatTaskProvider});
                }
            });
        }
        if ((packageRunFormatTaskProvider = GradleUtil.fetchTaskProvider((Project)project, (String)"packageRunFormat")) != null && !Boolean.parseBoolean(skipNodeTask = GradleUtil.getTaskPrefixedProperty((String)project.getPath(), (String)formatSourceTaskProvider.getName(), (String)"skip.node.task"))) {
            formatSourceTaskProvider.configure((Action)new Action<FormatSourceTask>(){

                public void execute(FormatSourceTask formatSourceTask) {
                    formatSourceTask.finalizedBy(new Object[]{packageRunFormatTaskProvider});
                }
            });
        }
    }

    private void _configureTaskFormatSource(FormatSourceTask formatSourceTask) {
        String showStatusUpdates;
        String showDocumentation;
        String showDebugInformation;
        String processorThreadCount;
        String maxLineLength;
        String includeSubrepositories;
        Project project = formatSourceTask.getProject();
        String gitWorkingBranchName = GradleUtil.getProperty((ExtensionAware)project, (String)"git.working.branch.name", (String)null);
        if (Validator.isNotNull((String)gitWorkingBranchName)) {
            formatSourceTask.setGitWorkingBranchName(gitWorkingBranchName);
        }
        if (Validator.isNotNull((String)(includeSubrepositories = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.include.subrepositories", (String)null)))) {
            formatSourceTask.setIncludeSubrepositories(Boolean.parseBoolean(includeSubrepositories));
        }
        if (Validator.isNotNull((String)(maxLineLength = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.max.line.length", (String)null)))) {
            formatSourceTask.setMaxLineLength(Integer.parseInt(maxLineLength));
        }
        if (Validator.isNotNull((String)(processorThreadCount = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.processor.thread.count", (String)null)))) {
            formatSourceTask.setProcessorThreadCount(Integer.parseInt(processorThreadCount));
        }
        if (Validator.isNotNull((String)(showDebugInformation = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.show.debug.information", (String)null)))) {
            formatSourceTask.setShowDebugInformation(Boolean.parseBoolean(showDebugInformation));
        }
        if (Validator.isNotNull((String)(showDocumentation = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.show.documentation", (String)null)))) {
            formatSourceTask.setShowDocumentation(Boolean.parseBoolean(showDocumentation));
        }
        if (Validator.isNotNull((String)(showStatusUpdates = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.show.status.updates", (String)null)))) {
            formatSourceTask.setShowStatusUpdates(Boolean.parseBoolean(showStatusUpdates));
        }
    }
}

