/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.tasks.BasePortalToolsTask;
import com.liferay.gradle.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.CacheableTask;

@CacheableTask
public class DirectDeployTask
extends BasePortalToolsTask {
    private Object _appServerDeployDir;
    private Object _appServerDir;
    private Object _appServerLibGlobalDir;
    private Object _appServerPortalDir;
    private Object _appServerType;
    private boolean _customPortletXml;
    private boolean _unpackWar = true;
    private Object _webAppFile;
    private Object _webAppType;

    public File getAppServerDeployDir() {
        return GradleUtil.toFile((Project)this.project, (Object)this._appServerDeployDir);
    }

    public File getAppServerDir() {
        return GradleUtil.toFile((Project)this.project, (Object)this._appServerDir);
    }

    public File getAppServerLibGlobalDir() {
        return GradleUtil.toFile((Project)this.project, (Object)this._appServerLibGlobalDir);
    }

    public File getAppServerPortalDir() {
        return GradleUtil.toFile((Project)this.project, (Object)this._appServerPortalDir);
    }

    public String getAppServerType() {
        return GradleUtil.toString((Object)this._appServerType);
    }

    @Override
    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>(3);
        File appServerLibPortalDir = this._getAppServerLibPortalDir();
        String path = appServerLibPortalDir.getAbsolutePath();
        args.add(path + "/util-bridges.jar");
        args.add(path + "/util-java.jar");
        args.add(path + "/util-taglib.jar");
        return args;
    }

    public List<String> getJvmArgs() {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        File webAppFile = this.getWebAppFile();
        jvmArgs.add("-Ddeployer.app.server.type=" + this.getAppServerType());
        jvmArgs.add("-Ddeployer.base.dir=" + FileUtil.getAbsolutePath((File)webAppFile.getParentFile()));
        jvmArgs.add("-Ddeployer.dest.dir=" + FileUtil.getAbsolutePath((File)this.getAppServerDeployDir()));
        jvmArgs.add("-Ddeployer.file.pattern=" + webAppFile.getName());
        jvmArgs.add("-Ddeployer.unpack.war=" + this.isUnpackWar());
        jvmArgs.add("-Dexternal-properties=com/liferay/portal/tools/dependencies/portal-tools.properties");
        jvmArgs.add("-Dliferay.lib.portal.dir=" + FileUtil.getAbsolutePath((File)this._getAppServerLibPortalDir()));
        String webAppType = this.getWebAppType();
        if (!webAppType.equals("layouttpl")) {
            jvmArgs.add("-Ddeployer.tomcat.lib.dir=" + FileUtil.getAbsolutePath((File)this.getAppServerLibGlobalDir()));
        }
        String tldPath = FileUtil.getAbsolutePath((File)new File(this.getAppServerPortalDir(), "WEB-INF/tld"));
        if (webAppType.equals("portlet") || webAppType.equals("theme")) {
            jvmArgs.add("-Ddeployer.theme.taglib.dtd=" + tldPath + "/liferay-theme.tld");
            jvmArgs.add("-Ddeployer.ui.taglib.dtd=" + tldPath + "/liferay-ui.tld");
        }
        if (webAppType.equals("portlet")) {
            jvmArgs.add("-Ddeployer.aui.taglib.dtd=" + tldPath + "/liferay-aui.tld");
            jvmArgs.add("-Ddeployer.custom.portlet.xml=" + this.isCustomPortletXml());
            jvmArgs.add("-Ddeployer.portlet-ext.taglib.dtd=" + tldPath + "/liferay-portlet-ext.tld");
            jvmArgs.add("-Ddeployer.portlet.taglib.dtd=" + tldPath + "/liferay-portlet.tld");
            jvmArgs.add("-Ddeployer.security.taglib.dtd=" + tldPath + "/liferay-security.tld");
            jvmArgs.add("-Ddeployer.staging.taglib.dtd=util-taglib/classes/META-INF/liferay-staging.tld");
            jvmArgs.add("-Ddeployer.util.taglib.dtd=" + tldPath + "/liferay-util.tld");
        }
        return jvmArgs;
    }

    @Override
    public String getMain() {
        String webAppType = this.getWebAppType();
        if (webAppType.equals("layouttpl")) {
            webAppType = "layout";
        }
        return "com.liferay.portal.tools.deploy." + StringUtil.capitalize((String)webAppType) + "Deployer";
    }

    public File getWebAppFile() {
        return GradleUtil.toFile((Project)this.project, (Object)this._webAppFile);
    }

    public String getWebAppType() {
        return GradleUtil.toString((Object)this._webAppType);
    }

    public boolean isCustomPortletXml() {
        return this._customPortletXml;
    }

    public boolean isUnpackWar() {
        return this._unpackWar;
    }

    public void setAppServerDeployDir(Object appServerDeployDir) {
        this._appServerDeployDir = appServerDeployDir;
    }

    public void setAppServerDir(Object appServerDir) {
        this._appServerDir = appServerDir;
    }

    public void setAppServerLibGlobalDir(Object appServerLibGlobalDir) {
        this._appServerLibGlobalDir = appServerLibGlobalDir;
    }

    public void setAppServerPortalDir(Object appServerPortalDir) {
        this._appServerPortalDir = appServerPortalDir;
    }

    public void setAppServerType(Object appServerType) {
        this._appServerType = appServerType;
    }

    public void setCustomPortletXml(boolean customPortletXml) {
        this._customPortletXml = customPortletXml;
    }

    public void setUnpackWar(boolean unpackWar) {
        this._unpackWar = unpackWar;
    }

    public void setWebAppFile(Object webAppFile) {
        this._webAppFile = webAppFile;
    }

    public void setWebAppType(Object webAppType) {
        this._webAppType = webAppType;
    }

    @Override
    protected void addDependencies() {
        Configuration configuration = GradleUtil.getConfiguration((Project)this.project, (String)this.getConfigurationName());
        Configuration portalConfiguration = GradleUtil.getConfiguration((Project)this.project, (String)"portal");
        configuration.extendsFrom(new Configuration[]{portalConfiguration});
    }

    @Override
    protected String getToolName() {
        return "Deployer";
    }

    private File _getAppServerLibPortalDir() {
        return new File(this.getAppServerPortalDir(), "WEB-INF/lib");
    }
}

