/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util.copy;

import java.util.Arrays;
import org.gradle.api.Action;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RelativePath;

public class StripPathSegmentsAction
implements Action<FileCopyDetails> {
    private final int _from;
    private final int _to;

    public StripPathSegmentsAction(int from) {
        this(from, Integer.MAX_VALUE);
    }

    public StripPathSegmentsAction(int from, int to) {
        this._from = from;
        this._to = to;
    }

    public void execute(FileCopyDetails fileCopyDetails) {
        RelativePath relativePath = fileCopyDetails.getRelativePath();
        String[] segments = relativePath.getSegments();
        segments = Arrays.copyOfRange(segments, this._from, Math.min(this._to, segments.length));
        fileCopyDetails.setRelativePath(new RelativePath(true, segments));
    }
}

