Liferay.Loader.define("journal-web@4.0.77/js/JournalPortlet.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-web/liferay/PortletBase.es', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.JournalPortlet = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _PortletBase2 = _interopRequireDefault(require("frontend-js-web/liferay/PortletBase.es"));

    var _metalDom = require("frontend-js-metal-web$metal-dom");

    var _metalEvents = require("frontend-js-metal-web$metal-events");

    var _metalState = require("frontend-js-metal-web$metal-state");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var ACTION_INPUT_NAME = 'javax-portlet-action';
    var BUTTON_ROW_CLASS = '.journal-article-button-row';
    var SIDEBAR_VISIBLE_CLASS = 'contextual-sidebar-visible';
    /**
     * JournalPortlet
     *
     * @abstract
     * @extends {PortletBase}
     */

    var JournalPortlet = /*#__PURE__*/function (_PortletBase) {
      _inherits(JournalPortlet, _PortletBase);

      function JournalPortlet() {
        _classCallCheck(this, JournalPortlet);

        return _possibleConstructorReturn(this, _getPrototypeOf(JournalPortlet).apply(this, arguments));
      }

      _createClass(JournalPortlet, [{
        key: "attached",

        /**
         * @inheritDoc
         */
        value: function attached() {
          var buttonRow = this.one(BUTTON_ROW_CLASS);

          this._eventHandler.add((0, _metalDom.delegate)(buttonRow, 'click', 'button', this._updateAction.bind(this)));

          var form = this._getInputByName(this.ns('fm1'));

          this._eventHandler.add((0, _metalDom.on)(form, 'submit', this._onFormSubmit.bind(this)));

          var resetValuesButton = this._getInputByName(this.ns('resetValuesButton'));

          if (resetValuesButton) {
            this._eventHandler.add((0, _metalDom.on)(resetValuesButton, 'click', this._resetValuesDDMStructure.bind(this)));
          }

          this._defaultLocaleChangedHandler = Liferay.after('inputLocalized:defaultLocaleChanged', this._onDefaultLocaleChange.bind(this));
          this._localeChangedHandler = Liferay.after('inputLocalized:localeChanged', this._onLocaleChange.bind(this));
          this._selectedLanguageId = this.defaultLanguageId;

          this._setupSidebar();
        }
        /**
         * @inheritDoc
         */

      }, {
        key: "created",
        value: function created() {
          this._eventHandler = new _metalEvents.EventHandler();
        }
        /**
         * @inheritDoc
         */

      }, {
        key: "detached",
        value: function detached() {
          this._eventHandler.removeAllListeners();

          this._defaultLocaleChangedHandler.detach();

          this._localeChangedHandler.detach();
        }
        /**
         * Clean the input if the language is not considered translated when
         * submitting the form
         * @param {string} name of the input
         */

      }, {
        key: "_cleanInputIfNeeded",
        value: function _cleanInputIfNeeded(name) {
          var inputComponent = Liferay.component(this.ns(name));
          var translatedLanguages = inputComponent.get('translatedLanguages');

          if (!translatedLanguages.has(this._selectedLanguageId) && this._selectedLanguageId !== this.defaultLanguageId) {
            inputComponent.updateInput('');
            var form = Liferay.Form.get(this.ns('fm1'));
            form.removeRule(this.ns(name), 'required');
          }
        }
        /**
         * Query an input by its name
         * @param {string} name
         * @private
         */

      }, {
        key: "_getInputByName",
        value: function _getInputByName(name) {
          return document.getElementById(this.ns(name));
        }
        /**
         * @private
         */

      }, {
        key: "_onFormSubmit",
        value: function _onFormSubmit(event) {
          event.preventDefault();

          var actionInput = this._getInputByName(ACTION_INPUT_NAME);

          var actionName = actionInput.value;

          this._saveArticle(actionName);
        }
        /**
         * Updates defaultLocale
         * @param {Event} event
         */

      }, {
        key: "_onDefaultLocaleChange",
        value: function _onDefaultLocaleChange(event) {
          if (event.item) {
            this.defaultLanguageId = event.item.getAttribute('data-value');
          }
        }
        /**
         * Updates description and title values on locale changed
         * @param {Event} event
         */

      }, {
        key: "_onLocaleChange",
        value: function _onLocaleChange(event) {
          var selectedLanguageId = event.item.getAttribute('data-value');
          this._selectedLanguageId = selectedLanguageId;

          if (selectedLanguageId) {
            this._updateLocalizableInput('descriptionMapAsXML', this.defaultLanguageId, selectedLanguageId);

            this._updateLocalizableInput('titleMapAsXML', this.defaultLanguageId, selectedLanguageId);

            this._updateLanguageIdInput(selectedLanguageId);
          }
        }
        /**
         * @private
         */

      }, {
        key: "_resetValuesDDMStructure",
        value: function _resetValuesDDMStructure(event) {
          if (confirm(Liferay.Language.get('are-you-sure-you-want-to-reset-the-default-values'))) {
            var button = event.currentTarget;
            submitForm(document.hrefFm, button.dataset.url);
          }
        }
        /**
         * Prepare action and articleId inputs to submit form
         * @param {string} actionName
         */

      }, {
        key: "_saveArticle",
        value: function _saveArticle(actionName) {
          var articleId = this._getInputByName('articleId').value;

          if (actionName === 'publish') {
            var workflowActionInput = this._getInputByName('workflowAction');

            workflowActionInput.value = Liferay.Workflow.ACTION_PUBLISH;
            actionName = null;
          }

          if (!actionName) {
            var classNameId = this._getInputByName('classNameId').value;

            if (classNameId > 0) {
              actionName = articleId ? '/journal/update_ddm_structure_default_values' : '/journal/add_ddm_structure_default_values';
            } else {
              actionName = articleId ? '/journal/update_article' : '/journal/add_article';
            }
          }

          this._setActionName(actionName);

          if (!articleId) {
            var articleIdInput = this._getInputByName('articleId');

            var newArticleIdInput = this._getInputByName('newArticleId');

            articleIdInput.value = newArticleIdInput.value;
          }

          var form = this._getInputByName(this.ns('fm1'));

          this._cleanInputIfNeeded('titleMapAsXML');

          this._cleanInputIfNeeded('descriptionMapAsXML');

          submitForm(form);
        }
        /**
         * Set the action name in the corresponding input
         * @param {string} actionName
         */

      }, {
        key: "_setActionName",
        value: function _setActionName(actionName) {
          var actionInput = this._getInputByName(ACTION_INPUT_NAME);

          actionInput.value = actionName;
        }
        /**
         * @private
         */

      }, {
        key: "_setupSidebar",
        value: function _setupSidebar() {
          var contextualSidebarButton = document.getElementById(this.ns('contextualSidebarButton'));
          var contextualSidebarContainer = document.getElementById(this.ns('contextualSidebarContainer'));

          if (contextualSidebarContainer && window.innerWidth > Liferay.BREAKPOINTS.PHONE) {
            contextualSidebarContainer.classList.add(SIDEBAR_VISIBLE_CLASS);
          }

          if (contextualSidebarButton) {
            this._eventHandler.add((0, _metalDom.on)(contextualSidebarButton, 'click', function () {
              contextualSidebarContainer.classList.toggle(SIDEBAR_VISIBLE_CLASS);
            }));
          }
        }
        /**
         * Change the portlet action based on the button clicked
         * @param {Event} event
         * @private
         */

      }, {
        key: "_updateAction",
        value: function _updateAction(event) {
          var button = event.delegateTarget;
          var actionName = button.dataset.actionname;

          if (actionName) {
            this._setActionName(actionName);
          }
        }
        /**
         * @private
         */

      }, {
        key: "_updateLanguageIdInput",
        value: function _updateLanguageIdInput(selectedLanguageId) {
          var languageIdInput = document.getElementById(this.ns('languageId'));
          languageIdInput.value = selectedLanguageId;
        }
        /**
         * Updates the localized input with the default language's translation
         * when there is not translation for the selected language
         * @param {string} name
         * @param {string} defaultLanguageId
         * @param {string} selectedLanguageId
         * @private
         */

      }, {
        key: "_updateLocalizableInput",
        value: function _updateLocalizableInput(name, defaultLanguageId, selectedLanguageId) {
          var inputComponent = Liferay.component(this.ns(name));

          if (inputComponent) {
            var inputSelectedValue = inputComponent.getValue(selectedLanguageId);

            if (inputSelectedValue === '') {
              var inputDefaultValue = inputComponent.getValue(defaultLanguageId); // LPS-92493

              var eventHandler = _frontendJsWeb.AOP.before(function () {
                return _frontendJsWeb.AOP.prevent();
              }, inputComponent, 'updateInputLanguage');

              inputComponent.selectFlag(selectedLanguageId);
              inputComponent.updateInput(inputDefaultValue); // setInterval declared in ckeditor.jsp is triggering
              // the updateInputLanguage function, so with this
              // we guarantee that this function is not called

              setTimeout(function () {
                eventHandler.detach();
              }, 400);
            }
          }
        }
      }]);

      return JournalPortlet;
    }(_PortletBase2.default);

    exports.JournalPortlet = JournalPortlet;
    JournalPortlet.STATE = {
      _selectedLanguageId: _metalState.Config.internal().string(),
      defaultLanguageId: _metalState.Config.string()
    };
    var _default = JournalPortlet;
    exports.default = _default;
    //# sourceMappingURL=JournalPortlet.es.js.map
  }
});
//# sourceMappingURL=JournalPortlet.es.js.map