Liferay.Loader.define("journal-web@4.0.77/js/ManagementToolbarDefaultEventHandler.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _metalState = require("frontend-js-metal-web$metal-state");

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var ManagementToolbarDefaultEventHandler = /*#__PURE__*/function (_DefaultEventHandler) {
      _inherits(ManagementToolbarDefaultEventHandler, _DefaultEventHandler);

      function ManagementToolbarDefaultEventHandler() {
        _classCallCheck(this, ManagementToolbarDefaultEventHandler);

        return _possibleConstructorReturn(this, _getPrototypeOf(ManagementToolbarDefaultEventHandler).apply(this, arguments));
      }

      _createClass(ManagementToolbarDefaultEventHandler, [{
        key: "deleteEntries",
        value: function deleteEntries() {
          var searchContainer = Liferay.SearchContainer.get(this.ns('articles'));
          var selectedNodesCount = searchContainer.select.getAllSelectedElements().size();
          var message = Liferay.Language.get('are-you-sure-you-want-to-delete-the-selected-entry');

          if (this.trashEnabled && selectedNodesCount > 1) {
            message = Liferay.Language.get('are-you-sure-you-want-to-move-the-selected-entries-to-the-recycle-bin');
          } else if (this.trashEnabled && selectedNodesCount === 1) {
            message = Liferay.Language.get('are-you-sure-you-want-to-move-the-selected-entry-to-the-recycle-bin');
          } else if (!this.trashEnabled && selectedNodesCount > 1) {
            message = Liferay.Language.get('are-you-sure-you-want-to-delete-the-selected-entries');
          }

          if (confirm(message)) {
            Liferay.fire(this.ns('editEntry'), {
              action: this.trashEnabled ? '/journal/move_articles_and_folders_to_trash' : '/journal/delete_articles_and_folders'
            });
          }
        }
      }, {
        key: "expireEntries",
        value: function expireEntries() {
          Liferay.fire(this.ns('editEntry'), {
            action: '/journal/expire_articles_and_folders'
          });
        }
      }, {
        key: "handleCreationMenuMoreButtonClicked",
        value: function handleCreationMenuMoreButtonClicked(event) {
          var _this = this;

          event.preventDefault();
          (0, _frontendJsWeb.openSelectionModal)({
            onSelect: function onSelect(selectedItem) {
              (0, _frontendJsWeb.navigate)((0, _frontendJsWeb.addParams)(_this.namespace + 'ddmStructureKey=' + selectedItem.ddmStructureKey, _this.addArticleURL));
            },
            selectEventName: this.ns('selectAddMenuItem'),
            title: Liferay.Language.get('more'),
            url: this.openViewMoreStructuresURL
          });
        }
      }, {
        key: "moveEntries",
        value: function moveEntries() {
          var moveArticlesAndFoldersURL = this.moveArticlesAndFoldersURL;
          var entrySelectorNodes = document.querySelectorAll('.entry-selector');

          if (entrySelectorNodes.length === 0) {
            entrySelectorNodes = document.querySelectorAll('.entry-card input[type="checkbox"]');
          }

          entrySelectorNodes.forEach(function (node) {
            if (node.checked) {
              moveArticlesAndFoldersURL = (0, _frontendJsWeb.addParams)("".concat(node.name, "=").concat(node.value), moveArticlesAndFoldersURL);
            }
          });
          Liferay.Util.navigate(moveArticlesAndFoldersURL);
        }
      }, {
        key: "openDDMStructuresSelector",
        value: function openDDMStructuresSelector() {
          var _this2 = this;

          (0, _frontendJsWeb.openSelectionModal)({
            onSelect: function onSelect(selectedItem) {
              Liferay.Util.navigate((0, _frontendJsWeb.addParams)(_this2.namespace + 'ddmStructureKey=' + selectedItem.ddmstructurekey, _this2.viewDDMStructureArticlesURL));
            },
            selectEventName: this.ns('selectDDMStructure'),
            title: Liferay.Language.get('structures'),
            url: this.selectEntityURL
          });
        }
      }]);

      return ManagementToolbarDefaultEventHandler;
    }(_frontendJsWeb.DefaultEventHandler);

    ManagementToolbarDefaultEventHandler.STATE = {
      addArticleURL: _metalState.Config.string(),
      folderId: _metalState.Config.string(),
      moveArticlesAndFoldersURL: _metalState.Config.string(),
      namespace: _metalState.Config.string(),
      openViewMoreStructuresURL: _metalState.Config.string(),
      selectEntityURL: _metalState.Config.string(),
      trashEnabled: _metalState.Config.bool(),
      viewDDMStructureArticlesURL: _metalState.Config.string()
    };
    var _default = ManagementToolbarDefaultEventHandler;
    exports.default = _default;
    //# sourceMappingURL=ManagementToolbarDefaultEventHandler.es.js.map
  }
});
//# sourceMappingURL=ManagementToolbarDefaultEventHandler.es.js.map