Liferay.Loader.define("journal-web@4.0.77/js/export_translation/ExportTranslationModal.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './ExportTranslationContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _modal = _interopRequireDefault(require("@frontend-taglib-clay$clayui/modal"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ExportTranslationContext = _interopRequireDefault(require("./ExportTranslationContext.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var noop = function noop() {};

    var ExportTranslationModal = function ExportTranslationModal(_ref) {
      var articleIds = _ref.articleIds,
          availableExportFileFormats = _ref.availableExportFileFormats,
          availableSourceLocales = _ref.availableSourceLocales,
          availableTargetLocales = _ref.availableTargetLocales,
          defaultSourceLanguageId = _ref.defaultSourceLanguageId,
          exportTranslationURL = _ref.exportTranslationURL,
          observer = _ref.observer,
          _ref$onModalClose = _ref.onModalClose,
          onModalClose = _ref$onModalClose === void 0 ? noop : _ref$onModalClose;

      var _useContext = (0, _react.useContext)(_ExportTranslationContext.default),
          namespace = _useContext.namespace;

      var _useState = (0, _react.useState)(availableExportFileFormats[0].mimeType),
          _useState2 = _slicedToArray(_useState, 2),
          exportMimeType = _useState2[0],
          setExportMimeType = _useState2[1];

      var _useState3 = (0, _react.useState)(defaultSourceLanguageId),
          _useState4 = _slicedToArray(_useState3, 2),
          sourceLanguageId = _useState4[0],
          setSourceLanguageId = _useState4[1];

      var _useState5 = (0, _react.useState)([]),
          _useState6 = _slicedToArray(_useState5, 2),
          selectedTargetLanguageIds = _useState6[0],
          setSelectedTargetLanguageIds = _useState6[1];

      var exportTranslationPortletURL = Liferay.Util.PortletURL.createPortletURL(exportTranslationURL, {
        articleId: articleIds[0],
        exportMimeType: exportMimeType,
        sourceLanguageId: sourceLanguageId,
        targetLanguageIds: selectedTargetLanguageIds.join(',')
      });

      var onChangeTarget = function onChangeTarget(checked, selectedLanguageId) {
        if (checked) {
          setSelectedTargetLanguageIds(selectedTargetLanguageIds.concat(selectedLanguageId));
        } else {
          setSelectedTargetLanguageIds(selectedTargetLanguageIds.filter(function (languageId) {
            return languageId != selectedLanguageId;
          }));
        }
      };

      var TargetLocale = function TargetLocale(_ref2) {
        var locale = _ref2.locale;
        var languageId = locale.languageId;
        var checked = selectedTargetLanguageIds.indexOf(languageId) != -1;
        return (/*#__PURE__*/_react.default.createElement(_form.ClayCheckbox, {
            checked: checked,
            disabled: languageId === sourceLanguageId,
            label: locale.displayName,
            onChange: function onChange() {
              onChangeTarget(!checked, languageId);
            }
          })
        );
      };

      return (/*#__PURE__*/_react.default.createElement(_modal.default, {
          observer: observer,
          size: "md"
        }, /*#__PURE__*/_react.default.createElement(_modal.default.Header, null, Liferay.Language.get('export-for-translation')), /*#__PURE__*/_react.default.createElement(_form.default, {
          className: "export-modal-content",
          onSubmit: function onSubmit(e) {
            e.preventDefault();
            onModalClose();
            location.href = Liferay.Util.addParams('download=true', exportTranslationPortletURL.toString());
          }
        }, /*#__PURE__*/_react.default.createElement(_modal.default.Body, {
          scrollable: true
        }, /*#__PURE__*/_react.default.createElement("h5", null, Liferay.Language.get('export-file-format')), /*#__PURE__*/_react.default.createElement(_form.default.Group, {
          className: "w-50"
        }, /*#__PURE__*/_react.default.createElement(function ExportFileFormats() {
          if (availableExportFileFormats.length == 1) {
            return (/*#__PURE__*/_react.default.createElement(_form.ClayInput, {
                readOnly: true,
                value: availableExportFileFormats[0].displayName
              })
            );
          } else {
            return (/*#__PURE__*/_react.default.createElement(_form.ClaySelect, {
                name: "_".concat(namespace, "_exportMimeType"),
                onChange: function onChange(e) {
                  setExportMimeType(e.currentTarget.value);
                },
                value: exportMimeType
              }, availableExportFileFormats.map(function (exportFileFormat) {
                return (/*#__PURE__*/_react.default.createElement(_form.ClaySelect.Option, {
                    key: exportFileFormat.mimeType,
                    label: exportFileFormat.displayName,
                    value: exportFileFormat.mimeType
                  })
                );
              }))
            );
          }
        }, null)), /*#__PURE__*/_react.default.createElement("h5", null, Liferay.Language.get('original-language')), /*#__PURE__*/_react.default.createElement(_form.default.Group, null, /*#__PURE__*/_react.default.createElement(function SourceLocales() {
          if (availableSourceLocales.length == 1) {
            return (/*#__PURE__*/_react.default.createElement(_form.ClayInput, {
                readOnly: true,
                value: availableSourceLocales[0].displayName
              })
            );
          } else {
            return (/*#__PURE__*/_react.default.createElement(_form.ClaySelect, {
                name: "_".concat(namespace, "_sourceLanguageId"),
                onChange: function onChange(e) {
                  setSourceLanguageId(e.currentTarget.value);
                },
                value: sourceLanguageId
              }, availableSourceLocales.map(function (locale) {
                return (/*#__PURE__*/_react.default.createElement(_form.ClaySelect.Option, {
                    key: locale.languageId,
                    label: locale.displayName,
                    value: locale.languageId
                  })
                );
              }))
            );
          }
        }, null)), /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement("p", null, Liferay.Language.get('languages-to-translate-to'))), /*#__PURE__*/_react.default.createElement(_form.default.Group, null, availableTargetLocales.map(function (locale) {
          return (/*#__PURE__*/_react.default.createElement(TargetLocale, {
              key: locale.languageId,
              locale: locale
            })
          );
        })), /*#__PURE__*/_react.default.createElement(_form.ClayInput, {
          name: "_".concat(namespace, "_articleIdsIds"),
          type: "hidden",
          value: articleIds
        })), /*#__PURE__*/_react.default.createElement(_modal.default.Footer, {
          last: /*#__PURE__*/_react.default.createElement(_button.default.Group, {
            spaced: true
          }, /*#__PURE__*/_react.default.createElement(_button.default, {
            displayType: "secondary",
            onClick: onModalClose
          }, Liferay.Language.get('cancel')), /*#__PURE__*/_react.default.createElement(_button.default, {
            disabled: selectedTargetLanguageIds.length === 0,
            displayType: "primary",
            type: "submit"
          }, Liferay.Language.get('export')))
        })))
      );
    };

    var _default = ExportTranslationModal;
    exports.default = _default;
    //# sourceMappingURL=ExportTranslationModal.es.js.map
  }
});
//# sourceMappingURL=ExportTranslationModal.es.js.map