Liferay.Loader.define("journal-web@4.0.77/js/translate/TranslateLanguagesSelector", ['module', 'exports', 'require', 'frontend-js-react-web$react', './LanguageSelector'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _LanguageSelector = _interopRequireDefault(require("./LanguageSelector"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var TranslateLanguagesSelector = function TranslateLanguagesSelector(_ref) {
      var currentUrl = _ref.currentUrl,
          portletNamespace = _ref.portletNamespace,
          sourceAvailableLanguages = _ref.sourceAvailableLanguages,
          sourceLanguageId = _ref.sourceLanguageId,
          targetAvailableLanguages = _ref.targetAvailableLanguages,
          targetLanguageId = _ref.targetLanguageId;
      var namespace = "".concat(portletNamespace);

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          formHaschanges = _useState2[0],
          setFormHasChanges = _useState2[1];

      var bridgeComponentId = "".concat(namespace, "TranslateLanguagesSelector");

      if (!Liferay.component(bridgeComponentId)) {
        Liferay.component(bridgeComponentId, {
          onFormChange: function onFormChange() {
            if (!formHaschanges) {
              setFormHasChanges(true);
            }
          }
        }, {
          destroyOnNavigate: true
        });
      }

      var refreshPage = function refreshPage(sourceId, targetId) {
        var url = new URL(currentUrl);
        var search_params = url.searchParams;
        search_params.set(namespace + 'sourceLanguageId', sourceId);
        search_params.set(namespace + 'targetLanguageId', targetId);
        url.search = search_params.toString();
        location.href = url.toString();
      };

      var changePage = function changePage(sourceId, targetId) {
        if (!formHaschanges) {
          refreshPage(sourceId, targetId);
        } else if (confirm(Liferay.Language.get('are-you-sure-you-want-to-leave-the-page-you-may-lose-your-changes'))) {
          refreshPage(sourceId, targetId);
        }
      };

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "autofit-row autofit-row-center languages-selector"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "autofit-col"
        }, Liferay.Language.get('translate-from')), /*#__PURE__*/_react.default.createElement("span", {
          className: "autofit-col"
        }, /*#__PURE__*/_react.default.createElement(_LanguageSelector.default, {
          languageIds: sourceAvailableLanguages,
          onChange: function onChange(value) {
            changePage(value, targetLanguageId);
          },
          selectedLanguageId: sourceLanguageId
        })), /*#__PURE__*/_react.default.createElement("span", {
          className: "autofit-col"
        }, Liferay.Language.get('to').toLowerCase()), /*#__PURE__*/_react.default.createElement("span", {
          className: "autofit-col"
        }, /*#__PURE__*/_react.default.createElement(_LanguageSelector.default, {
          languageIds: targetAvailableLanguages,
          onChange: function onChange(value) {
            changePage(sourceLanguageId, value);
          },
          selectedLanguageId: targetLanguageId
        })))
      );
    };

    var _default = TranslateLanguagesSelector;
    exports.default = _default;
    //# sourceMappingURL=TranslateLanguagesSelector.js.map
  }
});
//# sourceMappingURL=TranslateLanguagesSelector.js.map