"use strict";

Liferay.Loader.define("journal-web$dom-helpers@5.2.0/cjs/addEventListener", ['module', 'exports', 'require', '@journal-web$babel/runtime/helpers/interopRequireDefault', './canUseDOM'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var _interopRequireDefault = require("@journal-web$babel/runtime/helpers/interopRequireDefault");

    exports.__esModule = true;
    exports.default = exports.onceSupported = exports.optionsSupported = void 0;

    var _canUseDOM = _interopRequireDefault(require("./canUseDOM"));

    /* eslint-disable no-return-assign */
    var optionsSupported = false;
    exports.optionsSupported = optionsSupported;
    var onceSupported = false;
    exports.onceSupported = onceSupported;

    try {
      var options = {
        get passive() {
          return exports.optionsSupported = optionsSupported = true;
        },

        get once() {
          // eslint-disable-next-line no-multi-assign
          return exports.onceSupported = onceSupported = exports.optionsSupported = optionsSupported = true;
        }

      };

      if (_canUseDOM.default) {
        window.addEventListener('test', options, options);
        window.removeEventListener('test', options, true);
      }
    } catch (e) {}
    /* */


    /**
     * An `addEventListener` ponyfill, supports the `once` option
     */
    function addEventListener(node, eventName, handler, options) {
      if (options && typeof options !== 'boolean' && !onceSupported) {
        var once = options.once,
            capture = options.capture;
        var wrappedHandler = handler;

        if (!onceSupported && once) {
          wrappedHandler = handler.__once || function onceHandler(event) {
            this.removeEventListener(eventName, onceHandler, capture);
            handler.call(this, event);
          };

          handler.__once = wrappedHandler;
        }

        node.addEventListener(eventName, wrappedHandler, optionsSupported ? options : capture);
      }

      node.addEventListener(eventName, handler, options);
    }

    var _default = addEventListener;
    exports.default = _default;
  }
});
//# sourceMappingURL=addEventListener.js.map