Liferay.Loader.define('journal-web$lodash-es@4.17.15/_createCaseFirst', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import castSlice from './_castSlice.js';
    import hasUnicode from './_hasUnicode.js';
    import stringToArray from './_stringToArray.js';
    import toString from './toString.js';

    /**
     * Creates a function like `_.lowerFirst`.
     *
     * @private
     * @param {string} methodName The name of the `String` case method to use.
     * @returns {Function} Returns the new case function.
     */
    function createCaseFirst(methodName) {
      return function (string) {
        string = toString(string);

        var strSymbols = hasUnicode(string) ? stringToArray(string) : undefined;

        var chr = strSymbols ? strSymbols[0] : string.charAt(0);

        var trailing = strSymbols ? castSlice(strSymbols, 1).join('') : string.slice(1);

        return chr[methodName]() + trailing;
      };
    }

    export default createCaseFirst;
  }
});
//# sourceMappingURL=_createCaseFirst.js.map