Liferay.Loader.define('journal-web$lodash-es@4.17.15/delay', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import baseDelay from './_baseDelay.js';
    import baseRest from './_baseRest.js';
    import toNumber from './toNumber.js';

    /**
     * Invokes `func` after `wait` milliseconds. Any additional arguments are
     * provided to `func` when it's invoked.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to delay.
     * @param {number} wait The number of milliseconds to delay invocation.
     * @param {...*} [args] The arguments to invoke `func` with.
     * @returns {number} Returns the timer id.
     * @example
     *
     * _.delay(function(text) {
     *   console.log(text);
     * }, 1000, 'later');
     * // => Logs 'later' after one second.
     */
    var delay = baseRest(function (func, wait, args) {
      return baseDelay(func, toNumber(wait) || 0, args);
    });

    export default delay;
  }
});
//# sourceMappingURL=delay.js.map