/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.util;

import com.liferay.osgi.util.bundle.BundleStartLevelUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import com.liferay.portal.osgi.web.wab.generator.WabGenerator;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.util.tracker.ServiceTracker;

public class BundleUtil {
    public static URL getResourceInBundleOrFragments(Bundle bundle, String name) {
        String dirName = "/";
        String fileName = name;
        int index = name.lastIndexOf(47);
        if (index > 0) {
            dirName = name.substring(0, index);
            fileName = name.substring(index + 1);
        } else if (index == 0) {
            fileName = name.substring(1);
        }
        if (fileName.length() == 0) {
            if (!dirName.equals("/")) {
                dirName = dirName + "/";
            }
            return bundle.getEntry(dirName);
        }
        Enumeration enumeration = bundle.findEntries(dirName, fileName, false);
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        ArrayList list = Collections.list(enumeration);
        return (URL)list.get(list.size() - 1);
    }

    public static void installBundle(BundleContext bundleContext, LPKGDeployer lpkgDeployer, String location, int startLevel) throws Exception {
        Bundle bundle = null;
        Map<String, String[]> parameters = BundleUtil._getParameterMap(location);
        Object[] lpkgPaths = parameters.get("lpkgPath");
        Object[] protocols = parameters.get("protocol");
        Object[] webContextPaths = parameters.get("Web-ContextPath");
        if (parameters.isEmpty() && location.endsWith(".lpkg")) {
            URI uri = new URI(location);
            uri = uri.normalize();
            bundle = bundleContext.installBundle(location, lpkgDeployer.toBundle(new File(uri.getPath())));
        } else {
            if (ArrayUtil.isNotEmpty((Object[])lpkgPaths)) {
                bundle = bundleContext.getBundle((String)lpkgPaths[0]);
                BundleUtil.refreshBundles(bundleContext, Collections.singletonList(bundle));
                return;
            }
            if (ArrayUtil.isNotEmpty((Object[])protocols) && ((String)protocols[0]).equals("lpkg") && ArrayUtil.isNotEmpty((Object[])webContextPaths)) {
                String contextName = ((String)webContextPaths[0]).substring(1);
                for (Bundle installedBundle : bundleContext.getBundles()) {
                    Dictionary headers = installedBundle.getHeaders("");
                    if (!contextName.equals(headers.get("Liferay-WAB-Context-Name"))) continue;
                    BundleUtil.refreshBundles(bundleContext, Collections.singletonList(installedBundle));
                }
                return;
            }
            if (location.startsWith("webbundle:")) {
                WebBundleInstaller webBundleInstaller = new WebBundleInstaller(bundleContext, location, startLevel);
                webBundleInstaller.open();
                return;
            }
            bundle = bundleContext.installBundle(location);
        }
        BundleStartLevelUtil.setStartLevelAndStart(bundle, startLevel, bundleContext);
    }

    public static void refreshBundles(BundleContext bundleContext, List<Bundle> refreshBundles) {
        Bundle systemBundle = bundleContext.getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        frameworkWiring.refreshBundles(refreshBundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                defaultNoticeableFuture.set((Object)frameworkEvent);
            }
        }});
        try {
            FrameworkEvent frameworkEvent = (FrameworkEvent)defaultNoticeableFuture.get();
            if (frameworkEvent.getType() != 4) {
                throw frameworkEvent.getThrowable();
            }
        }
        catch (Throwable throwable) {
            ReflectionUtil.throwException((Throwable)throwable);
        }
    }

    private static Map<String, String[]> _getParameterMap(String location) {
        int index = location.indexOf(63);
        if (index == -1) {
            return Collections.emptyMap();
        }
        String queryString = location.substring(index + 1);
        if (Validator.isNull((String)queryString)) {
            return Collections.emptyMap();
        }
        String[] parameters = StringUtil.split((String)queryString, (char)'&');
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        for (String parameter : parameters) {
            Object[] values;
            String[] kvp;
            if (parameter.length() <= 0 || (kvp = StringUtil.split((String)parameter, (char)'=')).length == 0) continue;
            String key = kvp[0];
            String value = "";
            if (kvp.length > 1) {
                value = kvp[1];
            }
            if ((values = (String[])parameterMap.get(key)) == null) {
                parameterMap.put(key, new String[]{value});
                continue;
            }
            parameterMap.put(key, (String[])ArrayUtil.append((Object[])values, (Object)value));
        }
        return parameterMap;
    }

    private static class WebBundleInstaller
    extends ServiceTracker<WabGenerator, Void> {
        private final String _location;
        private final int _startLevel;

        public WebBundleInstaller(BundleContext bundleContext, String location, int startLevel) throws InvalidSyntaxException {
            super(bundleContext, WabGenerator.class, null);
            this._location = location;
            this._startLevel = startLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void addingService(ServiceReference<WabGenerator> serviceReference) {
            WabGenerator wabGenerator = (WabGenerator)this.context.getService(serviceReference);
            if (wabGenerator == null) {
                throw new IllegalStateException("Missing WAB generator");
            }
            try {
                Bundle bundle = this.context.installBundle(this._location);
                BundleStartLevelUtil.setStartLevelAndStart(bundle, this._startLevel, this.context);
            }
            catch (Exception exception) {
                ReflectionUtil.throwException((Throwable)exception);
            }
            finally {
                this.context.ungetService(serviceReference);
            }
            this.close();
            return null;
        }
    }
}

