/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.string;

import com.liferay.petra.lang.CentralizedThreadLocal;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

public class StringBundler
implements Serializable {
    private static final int _DEFAULT_ARRAY_CAPACITY = 16;
    private static final int _THREAD_LOCAL_BUFFER_LIMIT;
    private static final ThreadLocal<Reference<UnsafeStringBuilder>> _unsafeStringBuilderThreadLocal;
    private static final long serialVersionUID = 1L;
    private String[] _array;
    private int _arrayIndex;

    public static String concat(String ... strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] != null) continue;
            strings[i] = "null";
        }
        return StringBundler._toString(strings, strings.length);
    }

    public StringBundler() {
        this._array = new String[16];
    }

    public StringBundler(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 16;
        }
        this._array = new String[initialCapacity];
    }

    public StringBundler(String s) {
        this._array = new String[16];
        this._array[0] = s;
        this._arrayIndex = 1;
    }

    public StringBundler(String[] stringArray) {
        this(stringArray, 0);
    }

    public StringBundler(String[] stringArray, int extraSpace) {
        this._array = new String[stringArray.length + extraSpace];
        for (String s : stringArray) {
            if (s == null || s.length() <= 0) continue;
            this._array[this._arrayIndex++] = s;
        }
    }

    public StringBundler append(boolean b) {
        if (b) {
            return this.append("true");
        }
        return this.append("false");
    }

    public StringBundler append(char c) {
        return this.append(String.valueOf(c));
    }

    public StringBundler append(char[] chars) {
        if (chars == null) {
            return this.append("null");
        }
        return this.append(new String(chars));
    }

    public StringBundler append(double d) {
        return this.append(Double.toString(d));
    }

    public StringBundler append(float f) {
        return this.append(Float.toString(f));
    }

    public StringBundler append(int i) {
        return this.append(Integer.toString(i));
    }

    public StringBundler append(long l) {
        return this.append(Long.toString(l));
    }

    public StringBundler append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public StringBundler append(String s) {
        if (s == null) {
            s = "null";
        }
        if (s.length() == 0) {
            return this;
        }
        if (this._arrayIndex >= this._array.length) {
            this.expandCapacity(this._array.length * 2);
        }
        this._array[this._arrayIndex++] = s;
        return this;
    }

    public StringBundler append(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this;
        }
        if (this._array.length - this._arrayIndex < stringArray.length) {
            this.expandCapacity((this._array.length + stringArray.length) * 2);
        }
        for (String s : stringArray) {
            if (s == null || s.length() <= 0) continue;
            this._array[this._arrayIndex++] = s;
        }
        return this;
    }

    public StringBundler append(StringBundler sb) {
        if (sb == null || sb._arrayIndex == 0) {
            return this;
        }
        if (this._array.length - this._arrayIndex < sb._arrayIndex) {
            this.expandCapacity((this._array.length + sb._arrayIndex) * 2);
        }
        System.arraycopy(sb._array, 0, this._array, this._arrayIndex, sb._arrayIndex);
        this._arrayIndex += sb._arrayIndex;
        return this;
    }

    public int capacity() {
        return this._array.length;
    }

    public String[] getStrings() {
        return this._array;
    }

    public int index() {
        return this._arrayIndex;
    }

    public int length() {
        int length = 0;
        for (int i = 0; i < this._arrayIndex; ++i) {
            length += this._array[i].length();
        }
        return length;
    }

    public void setIndex(int newIndex) {
        if (newIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(newIndex);
        }
        if (newIndex > this._array.length) {
            String[] newArray = new String[newIndex];
            System.arraycopy(this._array, 0, newArray, 0, this._arrayIndex);
            this._array = newArray;
        }
        if (this._arrayIndex < newIndex) {
            for (int i = this._arrayIndex; i < newIndex; ++i) {
                this._array[i] = "";
            }
        }
        if (this._arrayIndex > newIndex) {
            for (int i = newIndex; i < this._arrayIndex; ++i) {
                this._array[i] = null;
            }
        }
        this._arrayIndex = newIndex;
    }

    public void setStringAt(String s, int index) {
        if (index < 0 || index >= this._arrayIndex) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this._array[index] = s;
    }

    public String stringAt(int index) {
        if (index < 0 || index >= this._arrayIndex) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this._array[index];
    }

    public String toString() {
        return StringBundler._toString(this._array, this._arrayIndex);
    }

    public void writeTo(Writer writer) throws IOException {
        for (int i = 0; i < this._arrayIndex; ++i) {
            writer.write(this._array[i]);
        }
    }

    protected void expandCapacity(int newCapacity) {
        String[] newArray = new String[newCapacity];
        System.arraycopy(this._array, 0, newArray, 0, this._arrayIndex);
        this._array = newArray;
    }

    private static String _toString(String[] array, int arrayIndex) {
        if (arrayIndex == 0) {
            return "";
        }
        if (arrayIndex == 1) {
            return array[0];
        }
        if (arrayIndex == 2) {
            return array[0].concat(array[1]);
        }
        if (arrayIndex == 3) {
            return array[0].concat(array[1]).concat(array[2]);
        }
        int length = 0;
        for (int i = 0; i < arrayIndex; ++i) {
            length += array[i].length();
        }
        UnsafeStringBuilder usb = null;
        if (length > _THREAD_LOCAL_BUFFER_LIMIT) {
            Reference<UnsafeStringBuilder> reference = _unsafeStringBuilderThreadLocal.get();
            if (reference != null) {
                usb = reference.get();
            }
            if (usb == null) {
                usb = new UnsafeStringBuilder(length);
                _unsafeStringBuilderThreadLocal.set(new SoftReference<UnsafeStringBuilder>(usb));
            } else {
                usb.resetAndEnsureCapacity(length);
            }
        } else {
            usb = new UnsafeStringBuilder(length);
        }
        for (int i = 0; i < arrayIndex; ++i) {
            usb.append(array[i]);
        }
        return usb.toString();
    }

    static {
        int threadLocalBufferLimit = Integer.getInteger(StringBundler.class.getName() + ".threadlocal.buffer.limit", Integer.MAX_VALUE);
        if (threadLocalBufferLimit > 0 && threadLocalBufferLimit < Integer.MAX_VALUE) {
            _THREAD_LOCAL_BUFFER_LIMIT = threadLocalBufferLimit;
            _unsafeStringBuilderThreadLocal = new CentralizedThreadLocal(false);
        } else {
            _THREAD_LOCAL_BUFFER_LIMIT = Integer.MAX_VALUE;
            _unsafeStringBuilderThreadLocal = null;
        }
    }

    private static class UnsafeStringBuilder {
        private int _count;
        private char[] _value;

        public void append(String s) {
            int length = s.length();
            s.getChars(0, length, this._value, this._count);
            this._count += length;
        }

        public void resetAndEnsureCapacity(int newLength) {
            if (this._value.length < newLength) {
                int length = this._value.length * 2 + 2;
                if (length < newLength) {
                    length = newLength;
                }
                this._value = new char[length];
            }
            this._count = 0;
        }

        public String toString() {
            return new String(this._value, 0, this._count);
        }

        private UnsafeStringBuilder(int length) {
            this._value = new char[length];
        }
    }
}

