/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.settings.internal.ConfigurationBeanManagedService;
import com.liferay.portal.configuration.settings.internal.scoped.configuration.ScopedConfigurationManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.resource.manager.ClassLoaderResourceManager;
import com.liferay.portal.kernel.resource.manager.ResourceManager;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.settings.ConfigurationBeanSettings;
import com.liferay.portal.kernel.settings.LocationVariableResolver;
import com.liferay.portal.kernel.settings.PortletPreferencesSettings;
import com.liferay.portal.kernel.settings.PropertiesSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.settings.definition.ConfigurationBeanDeclaration;
import com.liferay.portal.kernel.settings.definition.ConfigurationPidMapping;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.portlet.PortletPreferences;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.tracker.ServiceTracker;

@Component(immediate=true, service={SettingsLocatorHelper.class})
public class SettingsLocatorHelperImpl
implements SettingsLocatorHelper {
    private final ConcurrentMap<String, Class<?>> _configurationBeanClasses = new ConcurrentHashMap();
    private ServiceTracker<ConfigurationBeanDeclaration, ConfigurationBeanManagedService> _configurationBeanDeclarationServiceTracker;
    private ServiceTracker<ConfigurationBeanDeclaration, ScopedConfigurationManager> _configurationBeanDeclarationServiceTrackerFactory;
    private final Map<Class<?>, Settings> _configurationBeanSettings = new ConcurrentHashMap();
    private GroupLocalService _groupLocalService;
    private LayoutLocalService _layoutLocalService;
    private Settings _portalPropertiesSettings;
    private PortletPreferencesFactory _portletPreferencesFactory;
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    private final Map<String, ScopedConfigurationManager> _scopedConfigurationManagers = new ConcurrentHashMap<String, ScopedConfigurationManager>();

    public Settings getCompanyConfigurationBeanSettings(long companyId, String configurationPid, Settings parentSettings) {
        return this._getScopedConfigurationBeanSettings(ExtendedObjectClassDefinition.Scope.COMPANY, Long.valueOf(companyId), configurationPid, parentSettings);
    }

    public PortletPreferences getCompanyPortletPreferences(long companyId, String settingsId) {
        return this._portletPreferencesLocalService.getStrictPreferences(companyId, companyId, 1, 0L, settingsId);
    }

    public Settings getCompanyPortletPreferencesSettings(long companyId, String settingsId, Settings parentSettings) {
        return new PortletPreferencesSettings(this.getCompanyPortletPreferences(companyId, settingsId), parentSettings);
    }

    public Settings getConfigurationBeanSettings(String configurationPid) {
        Class configurationBeanClass = (Class)this._configurationBeanClasses.get(configurationPid);
        if (configurationBeanClass == null) {
            return this._portalPropertiesSettings;
        }
        Settings configurationBeanSettings = this._configurationBeanSettings.get(configurationBeanClass);
        if (configurationBeanSettings == null) {
            return this._portalPropertiesSettings;
        }
        return configurationBeanSettings;
    }

    @Deprecated
    public Settings getConfigurationBeanSettings(String configurationPid, Settings parentSettings) {
        return this.getConfigurationBeanSettings(configurationPid);
    }

    public Settings getGroupConfigurationBeanSettings(long groupId, String configurationPid, Settings parentSettings) {
        return this._getScopedConfigurationBeanSettings(ExtendedObjectClassDefinition.Scope.GROUP, Long.valueOf(groupId), configurationPid, parentSettings);
    }

    public PortletPreferences getGroupPortletPreferences(long groupId, String settingsId) {
        try {
            Group group = this._groupLocalService.getGroup(groupId);
            return this._portletPreferencesLocalService.getStrictPreferences(group.getCompanyId(), groupId, 2, 0L, settingsId);
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    public Settings getGroupPortletPreferencesSettings(long groupId, String settingsId, Settings parentSettings) {
        return new PortletPreferencesSettings(this.getGroupPortletPreferences(groupId, settingsId), parentSettings);
    }

    public Settings getPortalPreferencesSettings(long companyId, Settings parentSettings) {
        return new PortletPreferencesSettings(PrefsPropsUtil.getPreferences((long)companyId), parentSettings);
    }

    @Deprecated
    public Settings getPortalPropertiesSettings() {
        return this._portalPropertiesSettings;
    }

    public Settings getPortletInstanceConfigurationBeanSettings(String portletId, String configurationPid, Settings parentSettings) {
        return this._getScopedConfigurationBeanSettings(ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE, (Serializable)((Object)portletId), configurationPid, parentSettings);
    }

    public PortletPreferences getPortletInstancePortletPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        Layout layout;
        if (plid != 0L && (layout = this._layoutLocalService.fetchLayout(plid)) != null) {
            return this._portletPreferencesFactory.getStrictPortletSetup(layout, portletId);
        }
        if (PortletIdCodec.hasUserId((String)portletId)) {
            ownerId = PortletIdCodec.decodeUserId((String)portletId);
            ownerType = 4;
        }
        return this._portletPreferencesLocalService.getStrictPreferences(companyId, ownerId, ownerType, plid, portletId);
    }

    public PortletPreferences getPortletInstancePortletPreferences(long companyId, long plid, String portletId) {
        return this.getPortletInstancePortletPreferences(companyId, 0L, 3, plid, portletId);
    }

    public Settings getPortletInstancePortletPreferencesSettings(long companyId, long ownerId, int ownerType, long plid, String portletId, Settings parentSettings) {
        return new PortletPreferencesSettings(this.getPortletInstancePortletPreferences(companyId, ownerId, ownerType, plid, portletId), parentSettings);
    }

    public Settings getPortletInstancePortletPreferencesSettings(long companyId, long plid, String portletId, Settings parentSettings) {
        return new PortletPreferencesSettings(this.getPortletInstancePortletPreferences(companyId, plid, portletId), parentSettings);
    }

    public Settings getServerSettings(String settingsId) {
        return this.getConfigurationBeanSettings(settingsId);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._configurationBeanDeclarationServiceTracker = new ConfigurationBeanDeclarationServiceTracker(bundleContext);
        this._configurationBeanDeclarationServiceTracker.open();
        this._configurationBeanDeclarationServiceTrackerFactory = new ConfigurationBeanDeclarationServiceTrackerFactory(bundleContext);
        this._configurationBeanDeclarationServiceTrackerFactory.open();
    }

    @Deactivate
    protected void deactivate() {
        this._configurationBeanDeclarationServiceTracker.close();
        this._configurationBeanDeclarationServiceTrackerFactory.close();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigurationPidMapping(ConfigurationPidMapping configurationPidMapping) {
        this._configurationBeanClasses.put(configurationPidMapping.getConfigurationPid(), configurationPidMapping.getConfigurationBeanClass());
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
    }

    @Reference(unbind="-")
    protected void setPortletPreferencesFactory(PortletPreferencesFactory portletPreferencesFactory) {
        this._portletPreferencesFactory = portletPreferencesFactory;
    }

    @Reference(unbind="-")
    protected void setPortletPreferencesLocalService(PortletPreferencesLocalService portletPreferencesLocalService) {
        this._portletPreferencesLocalService = portletPreferencesLocalService;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._portalPropertiesSettings = new PropertiesSettings(new LocationVariableResolver((ResourceManager)new ClassLoaderResourceManager(PortalClassLoaderUtil.getClassLoader()), (SettingsLocatorHelper)this), props.getProperties());
    }

    protected void unsetConfigurationPidMapping(ConfigurationPidMapping configurationPidMapping) {
        this._configurationBeanClasses.remove(configurationPidMapping.getConfigurationPid());
    }

    private Settings _getScopedConfigurationBeanSettings(ExtendedObjectClassDefinition.Scope scope, Serializable scopePK, String configurationPid, Settings parentSettings) {
        ScopedConfigurationManager scopedConfigurationManager = this._scopedConfigurationManagers.get(configurationPid);
        if (scopedConfigurationManager == null) {
            return parentSettings;
        }
        Object configurationBean = scopedConfigurationManager.getConfiguration(scope, scopePK);
        if (configurationBean == null) {
            return parentSettings;
        }
        return new ConfigurationBeanSettings(scopedConfigurationManager.getLocationVariableResolver(), configurationBean, parentSettings);
    }

    private class ConfigurationBeanDeclarationServiceTrackerFactory
    extends ServiceTracker<ConfigurationBeanDeclaration, ScopedConfigurationManager> {
        public ScopedConfigurationManager addingService(ServiceReference<ConfigurationBeanDeclaration> reference) {
            ConfigurationBeanDeclaration configurationBeanDeclaration = (ConfigurationBeanDeclaration)this.context.getService(reference);
            Class configurationBeanClass = configurationBeanDeclaration.getConfigurationBeanClass();
            LocationVariableResolver locationVariableResolver = new LocationVariableResolver((ResourceManager)new ClassLoaderResourceManager(configurationBeanClass.getClassLoader()), (SettingsLocatorHelper)SettingsLocatorHelperImpl.this);
            ScopedConfigurationManager scopedConfigurationManager = new ScopedConfigurationManager(this.context, configurationBeanClass, locationVariableResolver);
            scopedConfigurationManager.register();
            SettingsLocatorHelperImpl.this._scopedConfigurationManagers.put(scopedConfigurationManager.getName(), scopedConfigurationManager);
            return scopedConfigurationManager;
        }

        public void removedService(ServiceReference<ConfigurationBeanDeclaration> reference, ScopedConfigurationManager scopedConfigurationManager) {
            this.context.ungetService(reference);
            SettingsLocatorHelperImpl.this._scopedConfigurationManagers.remove(scopedConfigurationManager.getName());
            scopedConfigurationManager.unregister();
        }

        private ConfigurationBeanDeclarationServiceTrackerFactory(BundleContext bundleContext) {
            super(bundleContext, ConfigurationBeanDeclaration.class, null);
        }
    }

    private class ConfigurationBeanDeclarationServiceTracker
    extends ServiceTracker<ConfigurationBeanDeclaration, ConfigurationBeanManagedService> {
        public ConfigurationBeanManagedService addingService(ServiceReference<ConfigurationBeanDeclaration> serviceReference) {
            ConfigurationBeanDeclaration configurationBeanDeclaration = (ConfigurationBeanDeclaration)this.context.getService(serviceReference);
            Class configurationBeanClass = configurationBeanDeclaration.getConfigurationBeanClass();
            ConfigurationBeanManagedService configurationBeanManagedService = new ConfigurationBeanManagedService(this.context, configurationBeanClass, configurationBean -> {
                LocationVariableResolver locationVariableResolver = new LocationVariableResolver((ResourceManager)new ClassLoaderResourceManager(configurationBeanClass.getClassLoader()), (SettingsLocatorHelper)SettingsLocatorHelperImpl.this);
                SettingsLocatorHelperImpl.this._configurationBeanSettings.put(configurationBeanClass, new ConfigurationBeanSettings(locationVariableResolver, configurationBean, SettingsLocatorHelperImpl.this._portalPropertiesSettings));
            });
            SettingsLocatorHelperImpl.this._configurationBeanClasses.put(configurationBeanManagedService.getConfigurationPid(), configurationBeanClass);
            configurationBeanManagedService.register();
            return configurationBeanManagedService;
        }

        public void removedService(ServiceReference<ConfigurationBeanDeclaration> serviceReference, ConfigurationBeanManagedService configurationBeanManagedService) {
            this.context.ungetService(serviceReference);
            configurationBeanManagedService.unregister();
            Class configurationBeanClass = (Class)SettingsLocatorHelperImpl.this._configurationBeanClasses.remove(configurationBeanManagedService.getConfigurationPid());
            SettingsLocatorHelperImpl.this._configurationBeanSettings.remove(configurationBeanClass);
        }

        private ConfigurationBeanDeclarationServiceTracker(BundleContext context) {
            super(context, ConfigurationBeanDeclaration.class, null);
        }
    }
}

