/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.file.install.internal.FileInstallImplBundleActivator;
import com.liferay.portal.file.install.internal.properties.TypedProperties;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class ConfigInstaller
implements ConfigurationListener,
FileInstaller {
    private static final Log _log = LogFactoryUtil.getLog(ConfigInstaller.class);
    private final BundleContext _bundleContext;
    private final ConfigurationAdmin _configurationAdmin;
    private final String _encoding;
    private final FileInstallImplBundleActivator _fileInstall;
    private final Map<String, String> _pidToFile = new HashMap<String, String>();
    private ServiceRegistration<?> _serviceRegistration;

    public ConfigInstaller(BundleContext bundleContext, ConfigurationAdmin configurationAdmin, FileInstallImplBundleActivator fileInstall) {
        this._bundleContext = bundleContext;
        this._configurationAdmin = configurationAdmin;
        this._fileInstall = fileInstall;
        String encoding = this._bundleContext.getProperty("file.install.configEncoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this._encoding = encoding;
    }

    public boolean canTransformURL(File file) {
        String name = file.getName();
        return name.endsWith(".cfg") || name.endsWith(".config");
    }

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        block63: {
            if (!this._shouldSaveConfig()) {
                return;
            }
            int type = configurationEvent.getType();
            if (type == 1) {
                try {
                    Configuration configuration = this._configurationAdmin.getConfiguration(configurationEvent.getPid(), "?");
                    Dictionary dictionary = configuration.getProperties();
                    String fileName = null;
                    if (dictionary != null) {
                        fileName = (String)dictionary.get("felix.fileinstall.filename");
                    }
                    File file = null;
                    if (fileName != null) {
                        file = this._fromConfigKey(fileName);
                    }
                    if (file == null || !file.isFile()) break block63;
                    this._pidToFile.put(configuration.getPid(), fileName);
                    TypedProperties typedProperties = new TypedProperties();
                    FileInputStream inputStream = new FileInputStream(file);
                    Object object = null;
                    try {
                        Throwable throwable = null;
                        try (InputStreamReader reader = new InputStreamReader((InputStream)inputStream, this._encoding);){
                            typedProperties.load(reader);
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable reader) {
                        object = reader;
                        throw reader;
                    }
                    finally {
                        if (inputStream != null) {
                            if (object != null) {
                                try {
                                    ((InputStream)inputStream).close();
                                }
                                catch (Throwable reader) {
                                    ((Throwable)object).addSuppressed(reader);
                                }
                            } else {
                                ((InputStream)inputStream).close();
                            }
                        }
                    }
                    ArrayList<Object> propertiesToRemove = new ArrayList<Object>();
                    for (Object key : typedProperties.keySet()) {
                        if (dictionary.get(key) != null || Objects.equals("service.pid", key) || Objects.equals("service.factoryPid", key) || Objects.equals("felix.fileinstall.filename", key)) continue;
                        propertiesToRemove.add(key);
                    }
                    Enumeration enumeration = dictionary.keys();
                    while (enumeration.hasMoreElements()) {
                        Object key;
                        key = (String)enumeration.nextElement();
                        if (Objects.equals("service.pid", key) || Objects.equals("service.factoryPid", key) || Objects.equals("felix.fileinstall.filename", key)) continue;
                        Object v = dictionary.get(key);
                        typedProperties.put((String)key, v);
                    }
                    for (String string : propertiesToRemove) {
                        typedProperties.remove(string);
                    }
                    Throwable throwable = null;
                    try (FileOutputStream outputStream = new FileOutputStream(file);
                         OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, this._encoding);){
                        typedProperties.save(writer);
                    }
                    catch (Throwable throwable4) {
                        Throwable throwable5 = throwable4;
                        throw throwable4;
                    }
                    this._fileInstall.updateChecksum(file);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"Unable to save configuration", (Throwable)exception);
                    }
                    break block63;
                }
            }
            if (type == 2) {
                try {
                    String fileName = this._pidToFile.remove(configurationEvent.getPid());
                    File file = null;
                    if (fileName != null) {
                        file = this._fromConfigKey(fileName);
                    }
                    if (file != null && file.isFile() && !file.delete()) {
                        throw new IOException("Unable to delete file: " + file);
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block63;
                    _log.warn((Object)"Unable to delete configuration file", (Throwable)exception);
                }
            }
        }
    }

    public void destroy() {
        this._serviceRegistration.unregister();
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this._configurationAdmin;
    }

    public void init() {
        block5: {
            this._serviceRegistration = this._bundleContext.registerService(new String[]{ConfigurationListener.class.getName(), FileInstaller.class.getName()}, (Object)this, null);
            try {
                Configuration[] configurations = this._configurationAdmin.listConfigurations(null);
                if (configurations != null) {
                    for (Configuration configuration : configurations) {
                        Dictionary dictionary = configuration.getProperties();
                        String fileName = null;
                        if (dictionary != null) {
                            fileName = (String)dictionary.get("felix.fileinstall.filename");
                        }
                        if (fileName == null) continue;
                        this._pidToFile.put(configuration.getPid(), fileName);
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to initialize configurations list", (Throwable)exception);
            }
        }
    }

    public URL transformURL(File file) throws Exception {
        this._setConfig(file);
        return null;
    }

    public void uninstall(File file) throws Exception {
        String[] pid = this._parsePid(file.getName());
        String logString = "";
        if (pid[1] != null) {
            logString = "-" + pid[1];
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Deleting configuration from ", pid[0], logString, ".cfg"}));
        }
        Configuration configuration = this._getConfiguration(this._toConfigKey(file), pid[0], pid[1]);
        configuration.delete();
    }

    private static boolean _equals(Dictionary<String, Object> newDictionary, Dictionary<String, Object> oldDictionary) {
        if (oldDictionary == null) {
            return false;
        }
        Enumeration<String> enumeration = newDictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object oldValue;
            String key = enumeration.nextElement();
            Object newValue = newDictionary.get(key);
            if (Objects.equals(newValue, oldValue = oldDictionary.remove(key)) || Objects.deepEquals(newValue, oldValue)) continue;
            return false;
        }
        return oldDictionary.isEmpty();
    }

    private String _escapeFilterValue(String string) {
        string = StringUtil.replace((String)string, (String)"[(]", (String)"\\\\(");
        string = StringUtil.replace((String)string, (String)"[)]", (String)"\\\\)");
        string = StringUtil.replace((String)string, (String)"[=]", (String)"\\\\=");
        return StringUtil.replace((String)string, (String)"[\\*]", (String)"\\\\*");
    }

    private Configuration _findExistingConfiguration(String fileName) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("(");
        sb.append("felix.fileinstall.filename");
        sb.append("=");
        sb.append(this._escapeFilterValue(fileName));
        sb.append(")");
        Configuration[] configurations = this._configurationAdmin.listConfigurations(sb.toString());
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    private File _fromConfigKey(String key) {
        return new File(URI.create(key));
    }

    private Configuration _getConfiguration(String fileName, String pid, String factoryPid) throws Exception {
        Configuration configuration = this._findExistingConfiguration(fileName);
        if (configuration != null) {
            return configuration;
        }
        if (factoryPid != null) {
            return this._configurationAdmin.createFactoryConfiguration(pid, "?");
        }
        return this._configurationAdmin.getConfiguration(pid, "?");
    }

    private String[] _parsePid(String path) {
        String pid = path.substring(0, path.lastIndexOf(46));
        int index = pid.indexOf(45);
        if (index > 0) {
            String factoryPid = pid.substring(index + 1);
            pid = pid.substring(0, index);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    private boolean _setConfig(File file) throws Exception {
        HashMapDictionary dictionary = new HashMapDictionary();
        try (FileInputStream inputStream = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)inputStream, this._encoding);){
            TypedProperties typedProperties = new TypedProperties();
            typedProperties.load(reader);
            for (String key : typedProperties.keySet()) {
                dictionary.put(key, typedProperties.get(key));
            }
        }
        String[] pid = this._parsePid(file.getName());
        Configuration configuration = this._getConfiguration(this._toConfigKey(file), pid[0], pid[1]);
        Dictionary properties = configuration.getProperties();
        HashMapDictionary old = null;
        if (properties != null) {
            old = new HashMapDictionary();
            Enumeration enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                old.put(key, properties.get(key));
            }
        }
        if (old != null) {
            old.remove("felix.fileinstall.filename");
            old.remove("service.pid");
            old.remove("service.factoryPid");
        }
        if (!ConfigInstaller._equals((Dictionary<String, Object>)dictionary, (Dictionary<String, Object>)old)) {
            dictionary.put("felix.fileinstall.filename", this._toConfigKey(file));
            String logString = "";
            if (pid[1] != null) {
                logString = "-" + pid[1];
            }
            if (old == null) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Creating configuration from ", pid[0], logString, ".cfg"}));
                }
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Updating configuration from ", pid[0], logString, ".cfg"}));
            }
            configuration.update((Dictionary)dictionary);
            return true;
        }
        return false;
    }

    private boolean _shouldSaveConfig() {
        String string = this._bundleContext.getProperty("file.install.enableConfigSave");
        if (string == null) {
            string = this._bundleContext.getProperty("file.install.disableConfigSave");
        }
        if (string != null) {
            return Boolean.valueOf(string);
        }
        return true;
    }

    private String _toConfigKey(File file) {
        file = file.getAbsoluteFile();
        URI uri = file.toURI();
        return uri.toString();
    }
}

