/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal;

import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.file.install.internal.ConfigInstaller;
import com.liferay.portal.file.install.internal.DefaultJarInstaller;
import com.liferay.portal.file.install.internal.DirectoryWatcher;
import com.liferay.portal.file.install.internal.Scanner;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FileInstallImplBundleActivator
implements BundleActivator {
    private BundleContext _bundleContext;
    private final Set<DirectoryWatcher> _directoryWatchers = new HashSet<DirectoryWatcher>();
    private ServiceRegistration<FileInstaller> _jarFileInstallerServiceRegistration;
    private ServiceTracker<ConfigurationAdmin, ConfigInstaller> _serviceTracker;

    public void start(final BundleContext bundleContext) throws Exception {
        this._bundleContext = bundleContext;
        this._jarFileInstallerServiceRegistration = this._bundleContext.registerService(FileInstaller.class, (Object)new DefaultJarInstaller(), null);
        this._serviceTracker = new ServiceTracker(bundleContext, ConfigurationAdmin.class.getName(), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ConfigurationAdmin, ConfigInstaller>(){

            public ConfigInstaller addingService(ServiceReference<ConfigurationAdmin> serviceReference) {
                ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
                ConfigInstaller configInstaller = new ConfigInstaller(bundleContext, configurationAdmin, FileInstallImplBundleActivator.this);
                configInstaller.init();
                return configInstaller;
            }

            public void modifiedService(ServiceReference<ConfigurationAdmin> serviceReference, ConfigInstaller configInstaller) {
            }

            public void removedService(ServiceReference<ConfigurationAdmin> serviceReference, ConfigInstaller configInstaller) {
                configInstaller.destroy();
                bundleContext.ungetService(serviceReference);
            }
        });
        this._serviceTracker.open();
        HashMap<String, String> map = new HashMap<String, String>();
        this._set(map, "file.install.poll");
        this._set(map, "file.install.dir");
        this._set(map, "file.install.filter");
        this._set(map, "file.install.tmpdir");
        this._set(map, "file.install.bundles.new.start");
        this._set(map, "file.install.bundles.startTransient");
        this._set(map, "file.install.bundles.startActivationPolicy");
        this._set(map, "file.install.noInitialDelay");
        this._set(map, "file.install.disableConfigSave");
        this._set(map, "file.install.enableConfigSave");
        this._set(map, "file.install.configEncoding");
        this._set(map, "file.install.start.level");
        this._set(map, "file.install.active.level");
        this._set(map, "file.install.bundles.updateWithListeners");
        this._set(map, "file.install.optionalImportRefreshScope");
        this._set(map, "file.install.fragmentRefreshScope");
        this._set(map, "file.install.subdir.mode");
        this._set(map, "file.install.web.start.level");
        HashSet<String> dirs = new HashSet<String>(Arrays.asList(StringUtil.split((String)((String)map.get("file.install.dir")))));
        for (String dir : dirs) {
            map.put("file.install.dir", dir);
            this._directoryWatchers.add(new DirectoryWatcher(map, this._bundleContext));
        }
        for (DirectoryWatcher directoryWatcher : this._directoryWatchers) {
            directoryWatcher.start();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        for (DirectoryWatcher directoryWatcher : this._directoryWatchers) {
            try {
                directoryWatcher.close();
            }
            catch (Exception exception) {}
        }
        this._serviceTracker.close();
        this._directoryWatchers.clear();
        this._jarFileInstallerServiceRegistration.unregister();
    }

    public void updateChecksum(File file) {
        for (DirectoryWatcher directoryWatcher : this._directoryWatchers) {
            Scanner scanner = directoryWatcher.getScanner();
            scanner.updateChecksum(file);
        }
    }

    private void _set(Map<String, String> map, String key) {
        String property = this._bundleContext.getProperty(key);
        if (property == null) {
            return;
        }
        map.put(key, property);
    }
}

