/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class Scanner
implements Closeable {
    public static final String SUBDIR_MODE_JAR = "jar";
    public static final String SUBDIR_MODE_RECURSE = "recurse";
    public static final String SUBDIR_MODE_SKIP = "skip";
    protected final boolean jarSubdir;
    protected final Map<File, Long> lastChecksums = new HashMap<File, Long>();
    protected final boolean skipSubdir;
    protected final Map<File, Long> storedChecksums = new HashMap<File, Long>();
    protected final File watchedDirectory;
    private final FilenameFilter _filenameFilter;
    private final boolean _recurseSubdir;

    public Scanner(File directory) {
        this(directory, null, null);
    }

    public Scanner(File directory, final String filterString, String subdirMode) {
        this.watchedDirectory = Scanner._canon(directory);
        this._filenameFilter = filterString != null && filterString.length() > 0 ? new FilenameFilter(){
            private final Pattern _pattern;
            {
                this._pattern = Pattern.compile(filterString);
            }

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = this._pattern.matcher(name);
                return matcher.matches();
            }
        } : null;
        this.jarSubdir = subdirMode == null || SUBDIR_MODE_JAR.equals(subdirMode);
        this.skipSubdir = SUBDIR_MODE_SKIP.equals(subdirMode);
        this._recurseSubdir = SUBDIR_MODE_RECURSE.equals(subdirMode);
    }

    @Override
    public void close() throws IOException {
    }

    public long getChecksum(File file) {
        Long checksum = this.storedChecksums.get(file);
        if (checksum != null) {
            return checksum;
        }
        return 0L;
    }

    public void initialize(Map<File, Long> checksums) {
        this.storedChecksums.putAll(checksums);
    }

    public Set<File> scan(boolean reportImmediately) {
        File[] list = this.watchedDirectory.listFiles(this._filenameFilter);
        Set<File> files = this._processFiles(reportImmediately, list);
        return new TreeSet<File>(files);
    }

    public void updateChecksum(File file) {
        if (file != null && this.storedChecksums.containsKey(file)) {
            long newChecksum = Scanner.checksum(file);
            this.storedChecksums.put(file, newChecksum);
        }
    }

    protected static long checksum(File file) {
        CRC32 crc32 = new CRC32();
        Scanner._checksum(file, crc32);
        return crc32.getValue();
    }

    private static File _canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ioException) {
            return file;
        }
    }

    private static void _checksum(File file, CRC32 crc32) {
        File[] children;
        String name = file.getName();
        crc32.update(name.getBytes());
        if (file.isFile()) {
            Scanner._checksum(file.lastModified(), crc32);
            Scanner._checksum(file.length(), crc32);
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                Scanner._checksum(child, crc32);
            }
        }
    }

    private static void _checksum(long l, CRC32 crc32) {
        for (int i = 0; i < 8; ++i) {
            crc32.update((int)(l & 0xFFL));
            l >>= 8;
        }
    }

    private Set<File> _processFiles(boolean reportImmediately, File[] list) {
        if (list == null) {
            return new HashSet<File>();
        }
        HashSet<File> files = new HashSet<File>();
        HashSet<File> removed = new HashSet<File>(this.storedChecksums.keySet());
        for (File file : list) {
            if (file.isDirectory()) {
                if (this.skipSubdir) continue;
                if (this._recurseSubdir) {
                    files.addAll(this._processFiles(reportImmediately, file.listFiles(this._filenameFilter)));
                    continue;
                }
            }
            long lastChecksum = 0L;
            if (this.lastChecksums.get(file) != null) {
                lastChecksum = this.lastChecksums.get(file);
            }
            long storedChecksum = 0L;
            if (this.storedChecksums.get(file) != null) {
                storedChecksum = this.storedChecksums.get(file);
            }
            long newChecksum = Scanner.checksum(file);
            this.lastChecksums.put(file, newChecksum);
            if ((newChecksum == lastChecksum || reportImmediately) && newChecksum != storedChecksum) {
                this.storedChecksums.put(file, newChecksum);
                files.add(file);
            }
            removed.remove(file);
        }
        files.addAll(removed);
        for (File file : removed) {
            this.lastChecksums.remove(file);
            this.storedChecksums.remove(file);
        }
        return files;
    }
}

