/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.manifest;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.file.install.internal.manifest.Attribute;
import com.liferay.portal.file.install.internal.manifest.Directive;

public class Clause {
    private final Attribute[] _attributes;
    private final Directive[] _directives;
    private final String _name;

    public Clause(String name, Directive[] directives, Attribute[] attributes) {
        this._name = name;
        this._directives = directives;
        this._attributes = attributes;
    }

    public String getAttribute(String name) {
        for (Attribute attribute : this._attributes) {
            if (!name.equals(attribute.getName())) continue;
            return attribute.getValue();
        }
        return null;
    }

    public Attribute[] getAttributes() {
        return this._attributes;
    }

    public String getDirective(String name) {
        for (Directive directive : this._directives) {
            if (!name.equals(directive.getName())) continue;
            return directive.getValue();
        }
        return null;
    }

    public Directive[] getDirectives() {
        return this._directives;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        String value;
        StringBundler sb = new StringBundler();
        sb.append(this._name);
        if (this._directives != null) {
            for (Directive directive : this._directives) {
                sb.append(";");
                sb.append(directive.getName());
                sb.append(":=");
                value = directive.getValue();
                if (value.contains(",")) {
                    sb.append("\"");
                    sb.append(value);
                    sb.append("\"");
                    continue;
                }
                sb.append(value);
            }
        }
        if (this._attributes != null) {
            for (Attribute attribute : this._attributes) {
                sb.append(";");
                sb.append(attribute.getName());
                sb.append("=");
                value = attribute.getValue();
                if (value.contains(",")) {
                    sb.append("\"");
                    sb.append(value);
                    sb.append("\"");
                    continue;
                }
                sb.append(value);
            }
        }
        return sb.toString();
    }
}

