/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.properties;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.file.install.internal.properties.InterpolationUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.io.BufferedReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Properties
extends AbstractMap<String, String> {
    private static final String _COMMENT_CHARS = "#!";
    private static final int _HEX_RADIX = 16;
    private static final String _LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char[] _SEPARATORS = new char[]{'=', ':'};
    private static final int _UNICODE_LEN = 4;
    private static final char[] _WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private List<String> _footers;
    private List<String> _headers;
    private final Map<String, Layout> _layoutMap = new LinkedHashMap<String, Layout>();
    private final Map<String, String> _storage = new LinkedHashMap<String, String>();
    private boolean _typed;

    @Override
    public void clear() {
        for (Layout layout : this._layoutMap.values()) {
            layout.clearValue();
        }
        this._storage.clear();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return Properties.this._storage.size();
            }
        };
    }

    public List<String> getComments(String key) {
        List<String> comments;
        Layout layout = this._layoutMap.get(key);
        if (layout != null && (comments = layout.getComments()) != null) {
            return new ArrayList<String>(comments);
        }
        return new ArrayList<String>();
    }

    public boolean isTyped() {
        return this._typed;
    }

    public void loadLayout(Reader reader) throws IOException {
        PropertiesReader propertiesReader = new PropertiesReader(reader);
        boolean hasProperty = false;
        while (propertiesReader.nextProperty()) {
            hasProperty = true;
            this._storage.put(propertiesReader.getPropertyName(), propertiesReader.getPropertyValue());
            int index = this._checkHeaderComment(propertiesReader.getComments());
            List<String> comments = propertiesReader.getComments();
            int size = comments.size();
            comments = index < comments.size() ? comments.subList(index, size) : null;
            this._layoutMap.put(propertiesReader.getPropertyName(), new Layout(comments, new ArrayList<String>(propertiesReader.getValues())));
        }
        Boolean typed = propertiesReader.isTyped();
        if (typed == null || !typed.booleanValue()) {
            this._typed = false;
            for (Map.Entry<String, String> entry : this._storage.entrySet()) {
                entry.setValue(Properties._unescapeJava(entry.getValue()));
            }
        } else {
            this._typed = true;
        }
        if (hasProperty) {
            this._footers = new ArrayList<String>(propertiesReader.getComments());
        } else {
            this._headers = new ArrayList<String>(propertiesReader.getComments());
        }
    }

    public String put(String key, List<String> comments, List<String> values) {
        comments = new ArrayList<String>(comments);
        values = new ArrayList<String>(values);
        String escapedKey = Properties._escapeKey(key);
        StringBundler sb = new StringBundler();
        if (values.isEmpty()) {
            values.add(escapedKey + "=");
            sb.append(escapedKey);
            sb.append("=");
        } else {
            String value;
            String realValue = value = values.get(0);
            if (!this._typed) {
                realValue = Properties._escapeJava(value);
            }
            if (!(value = value.trim()).startsWith(escapedKey)) {
                values.set(0, escapedKey + " = " + realValue);
                sb.append(escapedKey);
                sb.append(" = ");
                sb.append(realValue);
            } else {
                values.set(0, realValue);
                sb.append(realValue);
            }
        }
        for (int i = 1; i < values.size(); ++i) {
            String value = values.get(i);
            if (this._typed) {
                values.set(i, value);
            } else {
                values.set(i, Properties._escapeJava(value));
            }
            while (value.length() > 0 && Character.isWhitespace(value.charAt(0))) {
                value = value.substring(1);
            }
            sb.append(value);
        }
        String[] property = PropertiesReader._parseProperty(sb.toString());
        this._layoutMap.put(key, new Layout(comments, values));
        return this._storage.put(key, property[1]);
    }

    @Override
    public String put(String key, String value) {
        Layout layout;
        String old = this._storage.put(key, value);
        if (!(old != null && old.equals(value) || (layout = this._layoutMap.get(key)) == null)) {
            layout.clearValue();
        }
        return old;
    }

    @Override
    public String remove(Object key) {
        Layout layout = this._layoutMap.get(key);
        if (layout != null) {
            layout.clearValue();
        }
        return this._storage.remove(key);
    }

    public void save(Writer writer) throws IOException {
        this.saveLayout(writer, this._typed);
    }

    public void setHeader(List<String> headers) {
        this._headers = headers;
    }

    public void setTyped(boolean typed) {
        this._typed = typed;
    }

    public void substitute() {
        for (Map.Entry<String, String> entry : this._storage.entrySet()) {
            entry.setValue(InterpolationUtil.substVars(entry.getValue()));
        }
    }

    protected void saveLayout(Writer writer, boolean typed) throws IOException {
        try (PropertiesWriter propertiesWriter = new PropertiesWriter(writer, typed);){
            if (this._headers != null) {
                for (String string : this._headers) {
                    propertiesWriter.writeln(string);
                }
            }
            for (Map.Entry entry : this._storage.entrySet()) {
                List<String> values;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Layout layout = this._layoutMap.get(key);
                if (layout == null) {
                    propertiesWriter.writeProperty(key, value);
                    continue;
                }
                List<String> comments = layout.getComments();
                if (comments != null) {
                    for (String string : comments) {
                        propertiesWriter.writeln(string);
                    }
                }
                if ((values = layout.getValues()) == null) {
                    propertiesWriter.writeProperty(key, value);
                    continue;
                }
                int size = values.size();
                for (int i = 0; i < size; ++i) {
                    String string = values.get(i);
                    if (i < size - 1) {
                        propertiesWriter.writeln(string + "\\");
                        continue;
                    }
                    propertiesWriter.writeln(string);
                }
            }
            if (this._footers != null) {
                for (String string : this._footers) {
                    propertiesWriter.writeln(string);
                }
            }
        }
    }

    private static boolean _contains(char[] array, char valueToFind) {
        if (array == null) {
            return false;
        }
        for (char c : array) {
            if (valueToFind != c) continue;
            return true;
        }
        return false;
    }

    private static String _escapeJava(String string) {
        if (string == null) {
            return null;
        }
        int length = string.length();
        StringBundler sb = new StringBundler(length * 2);
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c > '\u0fff') {
                sb.append("\\u");
                sb.append(Properties._hex(c));
                continue;
            }
            if (c > '\u00ff') {
                sb.append("\\u0");
                sb.append(Properties._hex(c));
                continue;
            }
            if (c > '\u007f') {
                sb.append("\\u00");
                sb.append(Properties._hex(c));
                continue;
            }
            if (c < ' ') {
                if (c == 'b') {
                    sb.append('\\');
                    sb.append('b');
                    continue;
                }
                if (c == 'n') {
                    sb.append('\\');
                    sb.append('n');
                    continue;
                }
                if (c == 't') {
                    sb.append('\\');
                    sb.append('t');
                    continue;
                }
                if (c == 'f') {
                    sb.append('\\');
                    sb.append('f');
                    continue;
                }
                if (c == 'r') {
                    sb.append('\\');
                    sb.append('r');
                    continue;
                }
                if (c > '\u000f') {
                    sb.append("\\u00");
                    sb.append(Properties._hex(c));
                    continue;
                }
                sb.append("\\u000");
                sb.append(Properties._hex(c));
                continue;
            }
            if (c == '\"') {
                sb.append('\\');
                sb.append('\"');
                continue;
            }
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String _escapeKey(String key) {
        StringBundler sb = new StringBundler();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Properties._contains(_SEPARATORS, c) || Properties._contains(_WHITE_SPACE, c)) {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String _hex(char ch) {
        String hexString = Integer.toHexString(ch);
        return hexString.toUpperCase(LocaleUtil.ENGLISH);
    }

    private static boolean _isCommentLine(String line) {
        String string = line.trim();
        return string.length() < 1 || _COMMENT_CHARS.indexOf(string.charAt(0)) >= 0;
    }

    private static String _unescapeJava(String string) {
        if (string == null) {
            return null;
        }
        int size = string.length();
        StringBundler sb = new StringBundler(size);
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < size; ++i) {
            char c = string.charAt(i);
            if (inUnicode) {
                unicode.append(c);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    sb.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, numberFormatException);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                if (c == '\\') {
                    sb.append("\\");
                    continue;
                }
                if (c == '\'') {
                    sb.append('\'');
                    continue;
                }
                if (c == '\"') {
                    sb.append('\"');
                    continue;
                }
                if (c == 'r') {
                    sb.append('\r');
                    continue;
                }
                if (c == 'f') {
                    sb.append('\f');
                    continue;
                }
                if (c == 't') {
                    sb.append('\t');
                    continue;
                }
                if (c == 'n') {
                    sb.append('\n');
                    continue;
                }
                if (c == 'b') {
                    sb.append('\b');
                    continue;
                }
                if (c == 'u') {
                    inUnicode = true;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                hadSlash = true;
                continue;
            }
            sb.append(c);
        }
        if (hadSlash) {
            sb.append('\\');
        }
        return sb.toString();
    }

    private int _checkHeaderComment(List<String> comments) {
        if (this._headers == null && this._layoutMap.isEmpty()) {
            String commentLine;
            int index;
            for (index = comments.size() - 1; index >= 0 && (commentLine = comments.get(index)).length() > 0; --index) {
            }
            this.setHeader(new ArrayList<String>(comments.subList(0, index + 1)));
            return index + 1;
        }
        return 0;
    }

    private class KeyIterator
    implements Iterator<Map.Entry<String, String>> {
        private final Iterator<Map.Entry<String, String>> _iterator;

        public KeyIterator() {
            Set entries = Properties.this._storage.entrySet();
            this._iterator = entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Map.Entry<String, String> next() {
            final Map.Entry<String, String> entry = this._iterator.next();
            return new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public String getValue() {
                    return (String)entry.getValue();
                }

                @Override
                public String setValue(String value) {
                    Layout layout;
                    String old = entry.setValue(value);
                    if (!(old != null && old.equals(value) || (layout = (Layout)Properties.this._layoutMap.get(entry.getKey())) == null)) {
                        layout.clearValue();
                    }
                    return old;
                }
            };
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    private static class Layout {
        private final List<String> _comments;
        private List<String> _values;

        public Layout(List<String> comments, List<String> values) {
            this._comments = comments;
            this._values = values;
        }

        public void clearValue() {
            this._values = null;
        }

        public List<String> getComments() {
            return this._comments;
        }

        public List<String> getValues() {
            return this._values;
        }
    }

    public static class PropertiesWriter
    extends FilterWriter {
        private boolean _typed;

        public PropertiesWriter(Writer writer, boolean typed) {
            super(writer);
            this._typed = typed;
        }

        public void writeln(String string) throws IOException {
            if (string != null) {
                this.write(string);
            }
            this.write(_LINE_SEPARATOR);
        }

        public void writeProperty(String key, String value) throws IOException {
            this.write(Properties._escapeKey(key));
            this.write(" = ");
            if (this._typed) {
                this.write(value);
            } else {
                this.write(Properties._escapeJava(value));
            }
            this.writeln(null);
        }
    }

    public static class PropertiesReader
    extends BufferedReader {
        private final List<String> _comments = new ArrayList<String>();
        private Pattern _pattern = Pattern.compile("\\s*[TILFDXSCBilfdxscb]?(\\[[\\S\\s]*\\]|\\{[\\S\\s]*\\}|\"[\\S\\s]*\")\\s*");
        private String _propertyName;
        private String _propertyValue;
        private Boolean _typed;
        private final List<String> _values = new ArrayList<String>();

        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public List<String> getComments() {
            return this._comments;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public String getPropertyValue() {
            return this._propertyValue;
        }

        public List<String> getValues() {
            return this._values;
        }

        public Boolean isTyped() {
            return this._typed;
        }

        public boolean nextProperty() throws IOException {
            String line = this.readProperty();
            if (line == null) {
                return false;
            }
            String[] property = PropertiesReader._parseProperty(line);
            boolean typed = false;
            if (property[1].length() >= 2) {
                Matcher matcher = this._pattern.matcher(property[1]);
                typed = matcher.matches();
            }
            this._typed = this._typed == null ? Boolean.valueOf(typed) : Boolean.valueOf(this._typed & typed);
            this._propertyName = Properties._unescapeJava(property[0]);
            this._propertyValue = property[1];
            return true;
        }

        public String readProperty() throws IOException {
            this._comments.clear();
            this._values.clear();
            StringBundler sb = new StringBundler();
            while (true) {
                String line;
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (Properties._isCommentLine(line)) {
                    this._comments.add(line);
                    continue;
                }
                boolean combine = PropertiesReader._checkCombineLines(line);
                if (combine) {
                    line = line.substring(0, line.length() - 1);
                }
                this._values.add(line);
                while (line.length() > 0 && Properties._contains(_WHITE_SPACE, line.charAt(0))) {
                    line = line.substring(1);
                }
                sb.append(line);
                if (!combine) break;
            }
            return sb.toString();
        }

        private static boolean _checkCombineLines(String line) {
            int bsCount = 0;
            for (int i = line.length() - 1; i >= 0 && line.charAt(i) == '\\'; --i) {
                ++bsCount;
            }
            return bsCount % 2 != 0;
        }

        private static String[] _parseProperty(String line) {
            String[] result = new String[2];
            StringBundler keySB = new StringBundler();
            StringBundler valueSB = new StringBundler();
            int state = 0;
            for (int pos = 0; pos < line.length(); ++pos) {
                char c = line.charAt(pos);
                if (state == 0) {
                    if (c == '\\') {
                        state = 1;
                        continue;
                    }
                    if (Properties._contains(_WHITE_SPACE, c)) {
                        state = 2;
                        continue;
                    }
                    if (Properties._contains(_SEPARATORS, c)) {
                        state = 3;
                        continue;
                    }
                    keySB.append(c);
                    continue;
                }
                if (state == 1) {
                    if (Properties._contains(_SEPARATORS, c) || Properties._contains(_WHITE_SPACE, c)) {
                        keySB.append(c);
                    } else {
                        keySB.append('\\');
                        keySB.append(c);
                    }
                    state = 0;
                    continue;
                }
                if (state == 2) {
                    if (Properties._contains(_WHITE_SPACE, c)) {
                        state = 2;
                        continue;
                    }
                    if (Properties._contains(_SEPARATORS, c)) {
                        state = 3;
                        continue;
                    }
                    valueSB.append(c);
                    state = 4;
                    continue;
                }
                if (state == 3) {
                    if (Properties._contains(_WHITE_SPACE, c)) {
                        state = 3;
                        continue;
                    }
                    valueSB.append(c);
                    state = 4;
                    continue;
                }
                if (state != 4) continue;
                valueSB.append(c);
            }
            result[0] = keySB.toString();
            result[1] = valueSB.toString();
            return result;
        }
    }
}

