/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.properties;

import com.liferay.portal.file.install.internal.properties.ConfigurationHandler;
import com.liferay.portal.file.install.internal.properties.Properties;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TypedProperties
extends AbstractMap<String, Object> {
    private final Properties _storage = new Properties();

    @Override
    public void clear() {
        this._storage.clear();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return TypedProperties.this._storage.size();
            }
        };
    }

    @Override
    public Object get(Object key) {
        String value = (String)this._storage.get(key);
        if (value != null && this._storage.isTyped()) {
            return TypedProperties._convertFromString(value);
        }
        return value;
    }

    public void load(Reader reader) throws IOException {
        this._storage.loadLayout(reader);
        this._storage.substitute();
    }

    @Override
    public Object put(String key, Object value) {
        if (value instanceof String && !this._storage.isTyped()) {
            return this._storage.put(key, (String)value);
        }
        this._ensureTyped();
        String old = this._storage.put(key, TypedProperties._convertToString(value));
        if (old == null) {
            return null;
        }
        return TypedProperties._convertFromString(old);
    }

    @Override
    public Object remove(Object key) {
        return this._storage.remove(key);
    }

    public void save(Writer writer) throws IOException {
        this._storage.save(writer);
    }

    private static Object _convertFromString(String value) {
        try {
            return ConfigurationHandler.read(value);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static String _convertToString(Object value) {
        try {
            return ConfigurationHandler.write(value);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _ensureTyped() {
        if (!this._storage.isTyped()) {
            this._storage.setTyped(true);
            HashSet keys = new HashSet(this._storage.keySet());
            for (String key : keys) {
                String string = TypedProperties._convertToString(this._storage.get(key));
                this._storage.put(key, this._storage.getComments(key), Arrays.asList(string.split("\n")));
            }
        }
    }

    private class KeyIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final Iterator<String> _iterator;

        public KeyIterator() {
            Set entries = TypedProperties.this._storage.keySet();
            this._iterator = entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            final String key = this._iterator.next();
            return new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public Object getValue() {
                    return TypedProperties.this.get(key);
                }

                @Override
                public Object setValue(Object value) {
                    return TypedProperties.this.put(key, value);
                }
            };
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }
}

