/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.java.parser.JavaAnnotation;
import com.liferay.portal.tools.java.parser.JavaAnnotationFieldDefinition;
import com.liferay.portal.tools.java.parser.JavaAnnotationMemberValuePair;
import com.liferay.portal.tools.java.parser.JavaArray;
import com.liferay.portal.tools.java.parser.JavaArrayDeclarator;
import com.liferay.portal.tools.java.parser.JavaArrayElement;
import com.liferay.portal.tools.java.parser.JavaBreakStatement;
import com.liferay.portal.tools.java.parser.JavaCatchStatement;
import com.liferay.portal.tools.java.parser.JavaClassCall;
import com.liferay.portal.tools.java.parser.JavaClassDefinition;
import com.liferay.portal.tools.java.parser.JavaConstructorCall;
import com.liferay.portal.tools.java.parser.JavaConstructorDefinition;
import com.liferay.portal.tools.java.parser.JavaContinueStatement;
import com.liferay.portal.tools.java.parser.JavaDoStatement;
import com.liferay.portal.tools.java.parser.JavaElseStatement;
import com.liferay.portal.tools.java.parser.JavaEnhancedForStatement;
import com.liferay.portal.tools.java.parser.JavaEnumConstantDefinition;
import com.liferay.portal.tools.java.parser.JavaEnumConstantDefinitions;
import com.liferay.portal.tools.java.parser.JavaExpression;
import com.liferay.portal.tools.java.parser.JavaFinallyStatement;
import com.liferay.portal.tools.java.parser.JavaForStatement;
import com.liferay.portal.tools.java.parser.JavaIfStatement;
import com.liferay.portal.tools.java.parser.JavaImport;
import com.liferay.portal.tools.java.parser.JavaInstanceInitialization;
import com.liferay.portal.tools.java.parser.JavaInstanceofStatement;
import com.liferay.portal.tools.java.parser.JavaLambdaExpression;
import com.liferay.portal.tools.java.parser.JavaLambdaParameter;
import com.liferay.portal.tools.java.parser.JavaLoopStatement;
import com.liferay.portal.tools.java.parser.JavaMethodCall;
import com.liferay.portal.tools.java.parser.JavaMethodDefinition;
import com.liferay.portal.tools.java.parser.JavaMethodReference;
import com.liferay.portal.tools.java.parser.JavaNewArrayInstantiation;
import com.liferay.portal.tools.java.parser.JavaNewClassInstantiation;
import com.liferay.portal.tools.java.parser.JavaOperator;
import com.liferay.portal.tools.java.parser.JavaOperatorExpression;
import com.liferay.portal.tools.java.parser.JavaPackageDefinition;
import com.liferay.portal.tools.java.parser.JavaParameter;
import com.liferay.portal.tools.java.parser.JavaReturnStatement;
import com.liferay.portal.tools.java.parser.JavaSignature;
import com.liferay.portal.tools.java.parser.JavaSimpleValue;
import com.liferay.portal.tools.java.parser.JavaStaticInitialization;
import com.liferay.portal.tools.java.parser.JavaSwitchCaseStatement;
import com.liferay.portal.tools.java.parser.JavaSwitchStatement;
import com.liferay.portal.tools.java.parser.JavaSynchronizedStatement;
import com.liferay.portal.tools.java.parser.JavaTerm;
import com.liferay.portal.tools.java.parser.JavaTernaryOperator;
import com.liferay.portal.tools.java.parser.JavaThrowStatement;
import com.liferay.portal.tools.java.parser.JavaTryStatement;
import com.liferay.portal.tools.java.parser.JavaType;
import com.liferay.portal.tools.java.parser.JavaTypeCast;
import com.liferay.portal.tools.java.parser.JavaVariableDefinition;
import com.liferay.portal.tools.java.parser.JavaWhileStatement;
import com.liferay.portal.tools.java.parser.Position;
import com.liferay.portal.tools.java.parser.util.DetailASTUtil;
import com.liferay.portal.tools.java.parser.util.comparator.ModifierComparator;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JavaParserUtil {
    public static final int NO_MAX_LINE_LENGTH = -1;
    private static final int[] _SIMPLE_TYPES = new int[]{138, 58, 50, 51, 52, 69, 57, 134, 55, 54, 56, 135, 53, 79, 133, 78, 49, 142, 140, 137, 141, 139};

    public static String getLastLine(String s) {
        int x = s.lastIndexOf("\n");
        if (x != -1) {
            return s.substring(x + 1);
        }
        return s;
    }

    public static JavaTerm parseJavaTerm(DetailAST detailAST) {
        JavaTerm javaTerm = null;
        if (detailAST.getType() == 157 || detailAST.getType() == 14 || detailAST.getType() == 154 || detailAST.getType() == 15) {
            javaTerm = JavaParserUtil._parseJavaClassDefinition(detailAST);
        } else if (detailAST.getType() == 33) {
            javaTerm = JavaParserUtil._parseJavaSwitchCaseStatement(detailAST);
        } else if (detailAST.getType() == 161) {
            javaTerm = JavaParserUtil._parseJavaAnnotationFieldDefinition(detailAST);
        } else if (detailAST.getType() == 43 || detailAST.getType() == 42) {
            javaTerm = JavaParserUtil._parseJavaConstructorCall(detailAST);
        } else if (detailAST.getType() == 8) {
            javaTerm = JavaParserUtil._parseJavaConstructorDefinition(detailAST);
        } else if (detailAST.getType() == 175) {
            javaTerm = JavaParserUtil._parseJavaWhileStatement(detailAST);
        } else if (detailAST.getType() == 155) {
            DetailAST previousSiblingDetailAST = detailAST.getPreviousSibling();
            if (previousSiblingDetailAST.getType() == 72) {
                javaTerm = JavaParserUtil._parseJavaEnumConstantDefinitions(detailAST);
            }
        } else if (detailAST.getType() == 28) {
            javaTerm = JavaParserUtil._parseJavaExpression(detailAST);
        } else if (detailAST.getType() == 30) {
            javaTerm = JavaParserUtil._parseJavaImport(detailAST, false);
        } else if (detailAST.getType() == 11) {
            javaTerm = new JavaInstanceInitialization();
        } else if (detailAST.getType() == 22) {
            javaTerm = JavaParserUtil._parseJavaLabeledStatement(detailAST);
        } else if (detailAST.getType() == 86) {
            javaTerm = JavaParserUtil._parseJavaBreakStatement(detailAST);
        } else if (detailAST.getType() == 96) {
            javaTerm = JavaParserUtil._parseJavaCatchStatement(detailAST);
        } else if (detailAST.getType() == 87) {
            javaTerm = JavaParserUtil._parseJavaContinueStatement(detailAST);
        } else if (detailAST.getType() == 85) {
            javaTerm = new JavaDoStatement();
        } else if (detailAST.getType() == 92) {
            javaTerm = JavaParserUtil._parseJavaElseStatement(detailAST);
        } else if (detailAST.getType() == 97) {
            javaTerm = new JavaFinallyStatement();
        } else if (detailAST.getType() == 91) {
            javaTerm = JavaParserUtil._parseJavaForStatement(detailAST);
        } else if (detailAST.getType() == 83) {
            javaTerm = JavaParserUtil._parseJavaIfStatement(detailAST);
        } else if (detailAST.getType() == 88) {
            javaTerm = JavaParserUtil._parseJavaReturnStatement(detailAST);
        } else if (detailAST.getType() == 67) {
            javaTerm = JavaParserUtil._parseJavaSynchronizedStatement(detailAST);
        } else if (detailAST.getType() == 89) {
            javaTerm = JavaParserUtil._parseJavaSwitchStatement(detailAST);
        } else if (detailAST.getType() == 90) {
            javaTerm = JavaParserUtil._parseJavaThrowStatement(detailAST);
        } else if (detailAST.getType() == 95) {
            javaTerm = JavaParserUtil._parseJavaTryStatement(detailAST);
        } else if (detailAST.getType() == 84) {
            javaTerm = JavaParserUtil._parseJavaWhileStatement(detailAST);
        } else if (detailAST.getType() == 9) {
            javaTerm = JavaParserUtil._parseJavaMethodDefinition(detailAST);
        } else if (detailAST.getType() == 16) {
            javaTerm = JavaParserUtil._parseJavaPackageDefinition(detailAST);
        } else if (detailAST.getType() == 152) {
            javaTerm = JavaParserUtil._parseJavaImport(detailAST, true);
        } else if (detailAST.getType() == 12) {
            javaTerm = new JavaStaticInitialization();
        } else if (detailAST.getType() == 10) {
            javaTerm = JavaParserUtil._parseJavaVariableDefinition(detailAST);
        }
        if (javaTerm != null) {
            javaTerm.setSuffix(JavaParserUtil._getSuffix(detailAST));
        }
        return javaTerm;
    }

    private static int _getArrayDimension(DetailAST detailAST) {
        DetailAST typeArgumentsDetailAST;
        DetailAST childDetailAST = detailAST.getFirstChild();
        int arrayDimension = 0;
        while (childDetailAST.getType() == 17) {
            ++arrayDimension;
            childDetailAST = childDetailAST.getFirstChild();
        }
        if (arrayDimension > 0) {
            DetailAST parentDetailAST = detailAST.getParent();
            if (parentDetailAST.getType() == 164) {
                parentDetailAST = parentDetailAST.getParent();
            }
            if (parentDetailAST.getType() == 163 && JavaParserUtil._isMisplacedArrayDeclarator(parentDetailAST.getLastChild(), detailAST.getFirstChild())) {
                return 0;
            }
            return arrayDimension;
        }
        DetailAST typeInfoDetailAST = detailAST;
        if (childDetailAST.getType() == 59) {
            typeInfoDetailAST = childDetailAST;
        }
        if ((typeArgumentsDetailAST = typeInfoDetailAST.findFirstToken(163)) == null) {
            return arrayDimension;
        }
        List<DetailAST> arrayDeclaratorDetailASTList = DetailASTUtil.getAllChildTokens(typeInfoDetailAST, true, 17);
        for (DetailAST arrayDeclaratorDetailAST : arrayDeclaratorDetailASTList) {
            if (!JavaParserUtil._isMisplacedArrayDeclarator(typeArgumentsDetailAST.getLastChild(), arrayDeclaratorDetailAST)) continue;
            ++arrayDimension;
        }
        return arrayDimension;
    }

    private static Tuple _getChainTuple(DetailAST dotDetailAST) {
        String name = "";
        DetailAST detailAST = dotDetailAST;
        while (detailAST.getType() == 59) {
            DetailAST lastChildDetailAST = detailAST.getLastChild();
            name = Validator.isNull(name) ? lastChildDetailAST.getText() : lastChildDetailAST.getText() + "." + name;
            detailAST = detailAST.getFirstChild();
        }
        JavaExpression javaExpression = null;
        if (ArrayUtil.contains(_SIMPLE_TYPES, detailAST.getType()) && detailAST.getFirstChild() == null) {
            name = detailAST.getText() + "." + name;
        } else {
            javaExpression = JavaParserUtil._parseJavaExpression(detailAST);
        }
        return new Tuple(name, javaExpression);
    }

    private static String _getName(DetailAST detailAST) {
        DetailAST identDetailAST = detailAST.findFirstToken(58);
        if (identDetailAST != null) {
            return identDetailAST.getText();
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (ArrayUtil.contains(_SIMPLE_TYPES, firstChildDetailAST.getType())) {
            return firstChildDetailAST.getText();
        }
        DetailAST dotDetailAST = detailAST.findFirstToken(59);
        FullIdent fullIdent = FullIdent.createFullIdent(dotDetailAST);
        return fullIdent.getText();
    }

    private static String _getSuffix(DetailAST detailAST) {
        DetailAST closingDetailAST = DetailASTUtil.getClosingDetailAST(detailAST);
        if (closingDetailAST == null) {
            return "";
        }
        if (closingDetailAST.getType() == 72 || closingDetailAST.getType() == 7) {
            return " {";
        }
        return closingDetailAST.getText();
    }

    private static boolean _isMisplacedArrayDeclarator(DetailAST genericEndDetailAST, DetailAST arrayDeclaratorDetailAST) {
        Position genericEndPosition = new Position(genericEndDetailAST.getLineNo(), genericEndDetailAST.getColumnNo());
        Position arrayDeclaratorPosition = new Position(arrayDeclaratorDetailAST.getLineNo(), arrayDeclaratorDetailAST.getColumnNo());
        return arrayDeclaratorPosition.compareTo(genericEndPosition) > 0;
    }

    private static List<JavaExpression> _parseArrayValueJavaExpressions(DetailAST detailAST) {
        int bracketType = detailAST.getType();
        ArrayList<JavaExpression> arrayValueJavaExpressions = new ArrayList<JavaExpression>();
        DetailAST firstChildDetailAST = detailAST;
        while (true) {
            if (firstChildDetailAST.getType() != bracketType) {
                if (arrayValueJavaExpressions.size() > 1) {
                    Collections.reverse(arrayValueJavaExpressions);
                }
                return arrayValueJavaExpressions;
            }
            DetailAST closeBracketDetailAST = firstChildDetailAST.findFirstToken(48);
            DetailAST previousSiblingDetailAST = closeBracketDetailAST.getPreviousSibling();
            if (previousSiblingDetailAST == null || previousSiblingDetailAST.getType() == bracketType) {
                arrayValueJavaExpressions.add(new JavaSimpleValue(""));
            } else {
                arrayValueJavaExpressions.add(JavaParserUtil._parseJavaExpression(previousSiblingDetailAST));
            }
            firstChildDetailAST = firstChildDetailAST.getFirstChild();
        }
    }

    private static List<JavaType> _parseExceptionJavaTypes(DetailAST throwsDetailAST) {
        ArrayList<JavaType> exceptionJavaTypes = new ArrayList<JavaType>();
        if (throwsDetailAST == null) {
            return exceptionJavaTypes;
        }
        DetailAST childDetailAST = throwsDetailAST.getFirstChild();
        while (childDetailAST != null) {
            if (childDetailAST.getType() != 74) {
                FullIdent fullIdent = FullIdent.createFullIdent(childDetailAST);
                exceptionJavaTypes.add(new JavaType(fullIdent.getText(), 0));
            }
            childDetailAST = childDetailAST.getNextSibling();
        }
        return exceptionJavaTypes;
    }

    private static List<JavaType> _parseExtendedOrImplementedClassJavaTypes(DetailAST clauseDetailAST) {
        ArrayList<JavaType> classJavaTypes = new ArrayList<JavaType>();
        DetailAST childDetailAST = clauseDetailAST.getFirstChild();
        while (childDetailAST != null) {
            if (childDetailAST.getType() == 58) {
                JavaType javaType = new JavaType(childDetailAST.getText(), 0);
                DetailAST nextSiblingDetailAST = childDetailAST.getNextSibling();
                if (nextSiblingDetailAST != null && nextSiblingDetailAST.getType() == 163) {
                    javaType.setGenericJavaTypes(JavaParserUtil._parseGenericJavaTypes(nextSiblingDetailAST, 164));
                }
                classJavaTypes.add(javaType);
            } else if (childDetailAST.getType() == 59) {
                FullIdent fullIdent = FullIdent.createFullIdent(childDetailAST);
                JavaType javaType = new JavaType(fullIdent.getText(), 0);
                DetailAST typeArgumentsDetailAST = childDetailAST.findFirstToken(163);
                if (typeArgumentsDetailAST != null) {
                    javaType.setGenericJavaTypes(JavaParserUtil._parseGenericJavaTypes(typeArgumentsDetailAST, 164));
                }
                classJavaTypes.add(javaType);
            }
            childDetailAST = childDetailAST.getNextSibling();
        }
        return classJavaTypes;
    }

    private static JavaType _parseGenericBoundJavaType(DetailAST detailAST, int arrayDimension) {
        FullIdent fullIdent = FullIdent.createFullIdent(detailAST);
        JavaType genericBoundJavaType = new JavaType(fullIdent.getText(), arrayDimension);
        DetailAST typeArgumentsDetailAST = null;
        typeArgumentsDetailAST = detailAST.getType() != 59 ? detailAST.getNextSibling() : detailAST.getLastChild();
        if (typeArgumentsDetailAST != null && typeArgumentsDetailAST.getType() == 163) {
            genericBoundJavaType.setGenericJavaTypes(JavaParserUtil._parseGenericJavaTypes(typeArgumentsDetailAST, 164));
        }
        return genericBoundJavaType;
    }

    private static List<JavaType> _parseGenericBoundJavaTypes(DetailAST detailAST, int genericBoundType) {
        List<DetailAST> typeGenericBoundsDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, genericBoundType);
        int arrayDimension = 0;
        DetailAST typeGenericBoundsDetailAST = null;
        block0: for (DetailAST curTypeGenericBoundsDetailAST : typeGenericBoundsDetailASTList) {
            DetailAST parentDetailAST = curTypeGenericBoundsDetailAST.getParent();
            while (true) {
                if (DetailASTUtil.equals(detailAST, parentDetailAST)) {
                    typeGenericBoundsDetailAST = curTypeGenericBoundsDetailAST;
                    break block0;
                }
                if (parentDetailAST.getType() != 17) continue block0;
                ++arrayDimension;
                parentDetailAST = parentDetailAST.getParent();
            }
        }
        if (typeGenericBoundsDetailAST == null) {
            return null;
        }
        ArrayList<JavaType> genericBoundJavaTypes = new ArrayList<JavaType>();
        DetailAST childDetailAST = typeGenericBoundsDetailAST.getFirstChild();
        while (childDetailAST != null) {
            if (childDetailAST.getType() != 163 && childDetailAST.getType() != 174) {
                genericBoundJavaTypes.add(JavaParserUtil._parseGenericBoundJavaType(childDetailAST, arrayDimension));
            }
            childDetailAST = childDetailAST.getNextSibling();
        }
        return genericBoundJavaTypes;
    }

    private static List<JavaType> _parseGenericJavaTypes(DetailAST groupDetailAST, int type) {
        if (groupDetailAST == null) {
            return null;
        }
        ArrayList<JavaType> genericJavaTypes = new ArrayList<JavaType>();
        List<DetailAST> detailAstList = DetailASTUtil.getAllChildTokens(groupDetailAST, false, type);
        for (DetailAST currentDetailAST : detailAstList) {
            DetailAST childDetailAST = currentDetailAST.getFirstChild();
            if (childDetailAST.getType() == 13) {
                genericJavaTypes.add(JavaParserUtil._parseJavaType(childDetailAST));
                continue;
            }
            genericJavaTypes.add(JavaParserUtil._parseJavaType(currentDetailAST));
        }
        return genericJavaTypes;
    }

    private static JavaAnnotation _parseJavaAnnotation(DetailAST annotationDetailAST) {
        JavaAnnotation javaAnnotation = new JavaAnnotation(JavaParserUtil._getName(annotationDetailAST));
        DetailAST lparenDetailAST = annotationDetailAST.findFirstToken(76);
        if (lparenDetailAST == null) {
            return javaAnnotation;
        }
        List<JavaAnnotationMemberValuePair> javaAnnotationMemberValuePairs = JavaParserUtil._parseJavaAnnotationMemberValuePairs(annotationDetailAST);
        if (!javaAnnotationMemberValuePairs.isEmpty()) {
            Collections.sort(javaAnnotationMemberValuePairs);
            javaAnnotation.setJavaAnnotationMemberValuePairs(javaAnnotationMemberValuePairs);
        } else {
            DetailAST nextSiblingDetailAST = lparenDetailAST.getNextSibling();
            if (nextSiblingDetailAST.getType() != 77) {
                javaAnnotation.setValueJavaExpression(JavaParserUtil._parseJavaExpression(lparenDetailAST.getNextSibling()));
            }
        }
        return javaAnnotation;
    }

    private static JavaAnnotationFieldDefinition _parseJavaAnnotationFieldDefinition(DetailAST annotationFieldDefinitionDetailAST) {
        JavaAnnotationFieldDefinition javaAnnotationFieldDefinition = new JavaAnnotationFieldDefinition(JavaParserUtil._parseJavaAnnotations(annotationFieldDefinitionDetailAST.findFirstToken(5)), JavaParserUtil._parseJavaSignature(annotationFieldDefinitionDetailAST));
        DetailAST literalDefaultDetailAST = annotationFieldDefinitionDetailAST.findFirstToken(94);
        if (literalDefaultDetailAST != null) {
            javaAnnotationFieldDefinition.setDefaultJavaExpression(JavaParserUtil._parseJavaExpression(literalDefaultDetailAST.getFirstChild()));
        }
        return javaAnnotationFieldDefinition;
    }

    private static JavaAnnotationMemberValuePair _parseJavaAnnotationMemberValuePair(DetailAST annotationMemberValuePairDetailAST) {
        DetailAST identDetailAST = annotationMemberValuePairDetailAST.findFirstToken(58);
        return new JavaAnnotationMemberValuePair(identDetailAST.getText(), JavaParserUtil._parseJavaExpression(annotationMemberValuePairDetailAST.getLastChild()));
    }

    private static List<JavaAnnotationMemberValuePair> _parseJavaAnnotationMemberValuePairs(DetailAST annotationDetailAST) {
        ArrayList<JavaAnnotationMemberValuePair> javaAnnotationMemberValuePairs = new ArrayList<JavaAnnotationMemberValuePair>();
        List<DetailAST> annotationMemberValuePairDetailASTList = DetailASTUtil.getAllChildTokens(annotationDetailAST, false, 160);
        for (DetailAST annotationMemberValuePairDetailAST : annotationMemberValuePairDetailASTList) {
            javaAnnotationMemberValuePairs.add(JavaParserUtil._parseJavaAnnotationMemberValuePair(annotationMemberValuePairDetailAST));
        }
        return javaAnnotationMemberValuePairs;
    }

    private static List<JavaAnnotation> _parseJavaAnnotations(DetailAST detailAST) {
        ArrayList<JavaAnnotation> javaAnnotations = new ArrayList<JavaAnnotation>();
        List<DetailAST> annotationDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, false, 159);
        for (DetailAST annotationDetailAST : annotationDetailASTList) {
            javaAnnotations.add(JavaParserUtil._parseJavaAnnotation(annotationDetailAST));
        }
        Collections.sort(javaAnnotations);
        return javaAnnotations;
    }

    private static JavaArray _parseJavaArray(DetailAST arrayDetailAST) {
        JavaArray javaArray = new JavaArray();
        DetailAST childDetailAST = arrayDetailAST.getFirstChild();
        while (childDetailAST != null && childDetailAST.getType() != 73) {
            javaArray.addValueJavaExpression(JavaParserUtil._parseJavaExpression(childDetailAST));
            childDetailAST = childDetailAST.getNextSibling();
            childDetailAST = childDetailAST.getNextSibling();
        }
        return javaArray;
    }

    private static JavaArrayDeclarator _parseJavaArrayDeclarator(DetailAST arrayDeclaratorDetailAST) {
        ArrayList<JavaExpression> dimensionValueJavaExpressions = new ArrayList<JavaExpression>();
        dimensionValueJavaExpressions.add(new JavaSimpleValue(""));
        DetailAST childDetailAST = arrayDeclaratorDetailAST.getFirstChild();
        while (true) {
            if (childDetailAST.getType() != 17) {
                FullIdent fullIdent = FullIdent.createFullIdent(childDetailAST);
                return new JavaArrayDeclarator(fullIdent.getText(), dimensionValueJavaExpressions);
            }
            dimensionValueJavaExpressions.add(new JavaSimpleValue(""));
            childDetailAST = childDetailAST.getFirstChild();
        }
    }

    private static JavaArrayElement _parseJavaArrayElement(DetailAST indexOpDetailAST) {
        JavaExpression arrayJavaExpression = null;
        DetailAST firstChildDetailAST = indexOpDetailAST.getFirstChild();
        while (true) {
            if (firstChildDetailAST.getType() != 24) break;
            firstChildDetailAST = firstChildDetailAST.getFirstChild();
        }
        arrayJavaExpression = JavaParserUtil._parseJavaExpression(firstChildDetailAST);
        return new JavaArrayElement(arrayJavaExpression, JavaParserUtil._parseArrayValueJavaExpressions(indexOpDetailAST));
    }

    private static JavaBreakStatement _parseJavaBreakStatement(DetailAST literalBreakDetailAST) {
        JavaBreakStatement javaBreakStatement = new JavaBreakStatement();
        DetailAST firstChildDetailAST = literalBreakDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 58) {
            javaBreakStatement.setIdentifierName(firstChildDetailAST.getText());
        }
        return javaBreakStatement;
    }

    private static JavaCatchStatement _parseJavaCatchStatement(DetailAST literalCatchDetailAST) {
        FullIdent fullIdent;
        DetailAST parameterDefinitionDetailAST = literalCatchDetailAST.findFirstToken(21);
        List<JavaSimpleValue> modifiers = JavaParserUtil._parseModifiers(parameterDefinitionDetailAST.findFirstToken(5));
        DetailAST identDetailAST = parameterDefinitionDetailAST.findFirstToken(58);
        String parameterName = identDetailAST.getText();
        ArrayList<JavaType> parameterJavaTypes = new ArrayList<JavaType>();
        DetailAST typeDetailAST = parameterDefinitionDetailAST.findFirstToken(13);
        DetailAST childDetailAST = typeDetailAST.getFirstChild();
        while (true) {
            DetailAST nextSiblingDetailAST;
            if ((nextSiblingDetailAST = childDetailAST.getNextSibling()) != null) {
                fullIdent = FullIdent.createFullIdent(nextSiblingDetailAST);
                parameterJavaTypes.add(new JavaType(fullIdent.getText(), 0));
            }
            if (childDetailAST.getType() != 112) break;
            childDetailAST = childDetailAST.getFirstChild();
        }
        fullIdent = FullIdent.createFullIdent(childDetailAST);
        parameterJavaTypes.add(new JavaType(fullIdent.getText(), 0));
        if (parameterJavaTypes.size() > 1) {
            Collections.sort(parameterJavaTypes);
        }
        return new JavaCatchStatement(modifiers, parameterName, parameterJavaTypes);
    }

    private static JavaClassCall _parseJavaClassCall(DetailAST literalNewDetailAST) {
        DetailAST firstChildDetailAST;
        DetailAST typeArgumentDetailAST = literalNewDetailAST.findFirstToken(163);
        if (typeArgumentDetailAST == null && (firstChildDetailAST = literalNewDetailAST.getFirstChild()).getType() == 59) {
            typeArgumentDetailAST = firstChildDetailAST.findFirstToken(163);
        }
        JavaClassCall javaClassCall = new JavaClassCall(JavaParserUtil._getName(literalNewDetailAST), JavaParserUtil._parseGenericJavaTypes(typeArgumentDetailAST, 164), JavaParserUtil._parseParameterValueJavaExpressions(literalNewDetailAST.findFirstToken(34)));
        boolean statementCondition = DetailASTUtil.hasParentWithTokenType(literalNewDetailAST, 91, 83, 84);
        javaClassCall.setStatementCondition(statementCondition);
        DetailAST objBlockDetailAST = literalNewDetailAST.findFirstToken(6);
        if (objBlockDetailAST != null) {
            javaClassCall.setHasBody(true);
            if (objBlockDetailAST.getChildCount() == 2) {
                javaClassCall.setEmptyBody(true);
            }
        }
        return javaClassCall;
    }

    private static JavaClassDefinition _parseJavaClassDefinition(DetailAST definitionDetailAST) {
        DetailAST implementsClauseDetailAST;
        DetailAST modifiersDetailAST = definitionDetailAST.findFirstToken(5);
        String type = "";
        DetailAST nextSiblingDetailAST = modifiersDetailAST.getNextSibling();
        while (nextSiblingDetailAST.getType() != 58) {
            type = type + nextSiblingDetailAST.getText();
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        JavaType classJavaType = new JavaType(JavaParserUtil._getName(definitionDetailAST), 0);
        DetailAST typeParametersDetailAST = definitionDetailAST.findFirstToken(165);
        if (typeParametersDetailAST != null) {
            classJavaType.setGenericJavaTypes(JavaParserUtil._parseGenericJavaTypes(typeParametersDetailAST, 166));
        }
        JavaClassDefinition javaClassDefinition = new JavaClassDefinition(type, JavaParserUtil._parseJavaAnnotations(modifiersDetailAST), JavaParserUtil._parseModifiers(modifiersDetailAST), classJavaType);
        DetailAST extendsClauseDetailAST = definitionDetailAST.findFirstToken(18);
        if (extendsClauseDetailAST != null) {
            List<JavaType> extendedClassJavaTypes = JavaParserUtil._parseExtendedOrImplementedClassJavaTypes(extendsClauseDetailAST);
            if (!(extendedClassJavaTypes.size() <= 1 || definitionDetailAST.getParent() != null && AnnotationUtil.containsAnnotation((DetailAST)definitionDetailAST))) {
                Collections.sort(extendedClassJavaTypes);
            }
            javaClassDefinition.setExtendedClassJavaTypes(extendedClassJavaTypes);
        }
        if ((implementsClauseDetailAST = definitionDetailAST.findFirstToken(19)) != null) {
            List<JavaType> implementedClassJavaTypes = JavaParserUtil._parseExtendedOrImplementedClassJavaTypes(implementsClauseDetailAST);
            if (!(implementedClassJavaTypes.size() <= 1 || definitionDetailAST.getParent() != null && AnnotationUtil.containsAnnotation((DetailAST)definitionDetailAST))) {
                Collections.sort(implementedClassJavaTypes);
            }
            javaClassDefinition.setImplementedClassJavaTypes(implementedClassJavaTypes);
        }
        return javaClassDefinition;
    }

    private static JavaConstructorCall _parseJavaConstructorCall(DetailAST detailAST) {
        boolean superCall = false;
        if (detailAST.getType() == 42) {
            superCall = true;
        }
        return new JavaConstructorCall(JavaParserUtil._parseParameterValueJavaExpressions(detailAST.findFirstToken(34)), superCall);
    }

    private static JavaConstructorDefinition _parseJavaConstructorDefinition(DetailAST constructorDefinitionDetailAST) {
        return new JavaConstructorDefinition(JavaParserUtil._parseJavaAnnotations(constructorDefinitionDetailAST.findFirstToken(5)), JavaParserUtil._parseJavaSignature(constructorDefinitionDetailAST));
    }

    private static JavaContinueStatement _parseJavaContinueStatement(DetailAST literalContinueDetailAST) {
        JavaContinueStatement javaContinueStatement = new JavaContinueStatement();
        DetailAST firstChildDetailAST = literalContinueDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 58) {
            javaContinueStatement.setIdentifierName(firstChildDetailAST.getText());
        }
        return javaContinueStatement;
    }

    private static JavaElseStatement _parseJavaElseStatement(DetailAST literalElseDetailAST) {
        JavaElseStatement javaElseStatement = new JavaElseStatement();
        DetailAST firstChildDetailAST = literalElseDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 83) {
            javaElseStatement.setJavaIfStatement(JavaParserUtil._parseJavaIfStatement(firstChildDetailAST));
        }
        return javaElseStatement;
    }

    private static JavaEnhancedForStatement _parseJavaEnhancedForStatement(DetailAST forEachClauseDetailAST) {
        return new JavaEnhancedForStatement(JavaParserUtil._parseJavaExpression(forEachClauseDetailAST.findFirstToken(28)), JavaParserUtil._parseJavaVariableDefinition(forEachClauseDetailAST.findFirstToken(10)));
    }

    private static JavaEnumConstantDefinition _parseJavaEnumConstantDefinition(DetailAST enumConstantDefinitionDetailAST) {
        DetailAST objBlockDetailAST;
        JavaEnumConstantDefinition javaEnumConstantDefinition = new JavaEnumConstantDefinition(JavaParserUtil._getName(enumConstantDefinitionDetailAST), JavaParserUtil._parseJavaAnnotations(enumConstantDefinitionDetailAST.findFirstToken(158)));
        DetailAST elistDetailAST = enumConstantDefinitionDetailAST.findFirstToken(34);
        if (elistDetailAST != null) {
            javaEnumConstantDefinition.setParameterValueJavaExpressions(JavaParserUtil._parseParameterValueJavaExpressions(elistDetailAST));
        }
        if ((objBlockDetailAST = enumConstantDefinitionDetailAST.findFirstToken(6)) != null) {
            javaEnumConstantDefinition.setHasBody(true);
        }
        return javaEnumConstantDefinition;
    }

    private static JavaEnumConstantDefinitions _parseJavaEnumConstantDefinitions(DetailAST enumConstantDefinitionDetailAST) {
        JavaEnumConstantDefinitions javaEnumConstantDefinitions = new JavaEnumConstantDefinitions();
        DetailAST detailAST = enumConstantDefinitionDetailAST;
        while (detailAST != null) {
            if (detailAST.getType() == 155) {
                javaEnumConstantDefinitions.addJavaEnumConstantDefinition(JavaParserUtil._parseJavaEnumConstantDefinition(detailAST));
            } else if (detailAST.getType() != 74) {
                return javaEnumConstantDefinitions;
            }
            detailAST = detailAST.getNextSibling();
        }
        return javaEnumConstantDefinitions;
    }

    private static JavaExpression _parseJavaExpression(DetailAST detailAST) {
        return JavaParserUtil._parseJavaExpression(detailAST, false);
    }

    private static JavaExpression _parseJavaExpression(DetailAST detailAST, boolean checkSurroundingParentheses) {
        JavaExpression javaExpression;
        block19: {
            boolean hasSurroundingParentheses;
            block26: {
                block27: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block18: {
                                                if (detailAST.getType() == 28) {
                                                    detailAST = detailAST.getFirstChild();
                                                }
                                                hasSurroundingParentheses = false;
                                                while (true) {
                                                    if (detailAST.getType() == 76) {
                                                        detailAST = detailAST.getNextSibling();
                                                        hasSurroundingParentheses = true;
                                                        continue;
                                                    }
                                                    if (detailAST.getType() != 77) break;
                                                    detailAST = detailAST.getPreviousSibling();
                                                    hasSurroundingParentheses = true;
                                                }
                                                javaExpression = null;
                                                if (detailAST.getType() != 159) break block18;
                                                javaExpression = JavaParserUtil._parseJavaAnnotation(detailAST);
                                                break block19;
                                            }
                                            if (detailAST.getType() != 162 && detailAST.getType() != 29) break block20;
                                            javaExpression = JavaParserUtil._parseJavaArray(detailAST);
                                            break block19;
                                        }
                                        if (detailAST.getType() != 17) break block21;
                                        javaExpression = JavaParserUtil._parseJavaArrayDeclarator(detailAST);
                                        break block19;
                                    }
                                    if (detailAST.getType() != 59) break block22;
                                    DetailAST lastChildDetailAST = detailAST.getLastChild();
                                    if (lastChildDetailAST.getChildCount() > 0) {
                                        DetailAST firstChildDetailAST = detailAST.getFirstChild();
                                        javaExpression = new JavaSimpleValue(firstChildDetailAST.getText());
                                        javaExpression.setChainedJavaExpression(JavaParserUtil._parseJavaExpression(lastChildDetailAST));
                                    } else {
                                        Tuple chainTuple = JavaParserUtil._getChainTuple(detailAST);
                                        javaExpression = (JavaExpression)chainTuple.getObject(1);
                                        if (javaExpression != null) {
                                            javaExpression.setChainedJavaExpression(new JavaSimpleValue((String)chainTuple.getObject(0)));
                                        } else {
                                            javaExpression = new JavaSimpleValue((String)chainTuple.getObject(0));
                                        }
                                    }
                                    break block19;
                                }
                                if (detailAST.getType() != 24) break block23;
                                javaExpression = JavaParserUtil._parseJavaArrayElement(detailAST);
                                break block19;
                            }
                            if (detailAST.getType() != 181) break block24;
                            javaExpression = JavaParserUtil._parseJavaLambdaExpression(detailAST);
                            break block19;
                        }
                        if (detailAST.getType() != 121) break block25;
                        javaExpression = JavaParserUtil._parseJavaInstanceofStatement(detailAST);
                        break block19;
                    }
                    if (detailAST.getType() != 136) break block26;
                    DetailAST arrayDeclaratorDetailAST = detailAST.findFirstToken(17);
                    if (arrayDeclaratorDetailAST == null) break block27;
                    javaExpression = JavaParserUtil._parseJavaNewArrayInstantiation(detailAST);
                    break block19;
                }
                DetailAST elistDetailAST = detailAST.findFirstToken(34);
                if (elistDetailAST == null) break block19;
                javaExpression = JavaParserUtil._parseJavaNewClassInstantiation(detailAST);
                break block19;
            }
            if (detailAST.getType() == 27) {
                return JavaParserUtil._parseJavaMethodCall(detailAST);
            }
            if (detailAST.getType() == 180) {
                javaExpression = JavaParserUtil._parseJavaMethodReference(detailAST);
            } else if (detailAST.getType() == 109) {
                javaExpression = JavaParserUtil._parseJavaTernaryOperator(detailAST);
            } else if (detailAST.getType() == 23) {
                javaExpression = JavaParserUtil._parseJavaTypeCast(detailAST);
            } else if (ArrayUtil.contains(_SIMPLE_TYPES, detailAST.getType())) {
                javaExpression = new JavaSimpleValue(detailAST.getText());
            } else {
                for (JavaOperator operator : JavaOperator.values()) {
                    if (operator.getType() != detailAST.getType()) continue;
                    javaExpression = JavaParserUtil._parseJavaOperatorExpression(detailAST, operator);
                    if (!checkSurroundingParentheses) break;
                    javaExpression.setHasSurroundingParentheses(hasSurroundingParentheses);
                    break;
                }
            }
        }
        if (javaExpression != null) {
            javaExpression.setSurroundingParentheses();
        }
        return javaExpression;
    }

    private static JavaLoopStatement _parseJavaForStatement(DetailAST literalForDetailAST) {
        DetailAST firstChildDetailAST = literalForDetailAST.getFirstChild();
        DetailAST nextSiblingDetailAST = firstChildDetailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() == 156) {
            return JavaParserUtil._parseJavaEnhancedForStatement(nextSiblingDetailAST);
        }
        JavaForStatement javaForStatement = new JavaForStatement();
        ArrayList<JavaTerm> initializationJavaTerms = new ArrayList<JavaTerm>();
        DetailAST forInitDetailAST = literalForDetailAST.findFirstToken(35);
        firstChildDetailAST = forInitDetailAST.getFirstChild();
        if (firstChildDetailAST != null) {
            if (firstChildDetailAST.getType() == 34) {
                List<DetailAST> exprDetailASTList = DetailASTUtil.getAllChildTokens(firstChildDetailAST, false, 28);
                for (DetailAST exprDetailAST : exprDetailASTList) {
                    initializationJavaTerms.add(JavaParserUtil._parseJavaExpression(exprDetailAST));
                }
            } else if (firstChildDetailAST.getType() == 10) {
                initializationJavaTerms.add(JavaParserUtil._parseJavaVariableDefinition(firstChildDetailAST));
            }
        }
        javaForStatement.setInitializationJavaTerms(initializationJavaTerms);
        DetailAST forConditionDetailAST = literalForDetailAST.findFirstToken(36);
        DetailAST exprDetailAST = forConditionDetailAST.findFirstToken(28);
        if (exprDetailAST != null) {
            javaForStatement.setConditionJavaExpression(JavaParserUtil._parseJavaExpression(exprDetailAST));
        }
        DetailAST forIteratorDetailAST = literalForDetailAST.findFirstToken(37);
        ArrayList<JavaExpression> iteratorJavaExpressions = new ArrayList<JavaExpression>();
        DetailAST elistDetailAST = forIteratorDetailAST.findFirstToken(34);
        if (elistDetailAST != null) {
            List<DetailAST> exprDetailASTList = DetailASTUtil.getAllChildTokens(elistDetailAST, false, 28);
            for (DetailAST curExprDetailAST : exprDetailASTList) {
                iteratorJavaExpressions.add(JavaParserUtil._parseJavaExpression(curExprDetailAST));
            }
        }
        javaForStatement.setIteratorJavaExpression(iteratorJavaExpressions);
        return javaForStatement;
    }

    private static JavaIfStatement _parseJavaIfStatement(DetailAST literalIfDetailAST) {
        DetailAST firstChildDetailAST = literalIfDetailAST.getFirstChild();
        return new JavaIfStatement(JavaParserUtil._parseJavaExpression(firstChildDetailAST.getNextSibling()));
    }

    private static JavaImport _parseJavaImport(DetailAST importDetailAST, boolean isStatic) {
        return new JavaImport(JavaParserUtil._getName(importDetailAST), isStatic);
    }

    private static JavaInstanceofStatement _parseJavaInstanceofStatement(DetailAST literalInstanceofDetailAST) {
        DetailAST typeDetailAST = literalInstanceofDetailAST.findFirstToken(13);
        return new JavaInstanceofStatement(JavaParserUtil._parseJavaType(typeDetailAST), JavaParserUtil._parseJavaExpression(literalInstanceofDetailAST.getFirstChild()));
    }

    private static JavaLoopStatement _parseJavaLabeledStatement(DetailAST labeledStatementDetailAST) {
        JavaLoopStatement javaLoopStatement = null;
        DetailAST firstChildDetailAST = labeledStatementDetailAST.getFirstChild();
        DetailAST nextSiblingDetailAST = firstChildDetailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() == 91) {
            javaLoopStatement = JavaParserUtil._parseJavaForStatement(nextSiblingDetailAST);
        } else if (nextSiblingDetailAST.getType() == 84) {
            javaLoopStatement = JavaParserUtil._parseJavaWhileStatement(nextSiblingDetailAST);
        }
        if (javaLoopStatement != null) {
            javaLoopStatement.setLabelName(firstChildDetailAST.getText());
        }
        return javaLoopStatement;
    }

    private static JavaExpression _parseJavaLambdaExpression(DetailAST lambdaDetailAST) {
        JavaLambdaExpression javaLambdaExpression = null;
        DetailAST firstChildDetailAST = lambdaDetailAST.getFirstChild();
        javaLambdaExpression = firstChildDetailAST.getType() == 58 ? new JavaLambdaExpression(firstChildDetailAST.getText()) : new JavaLambdaExpression(JavaParserUtil._parseJavaLambdaParameters(lambdaDetailAST.findFirstToken(20)));
        DetailAST lastChildDetailAST = lambdaDetailAST.getLastChild();
        if (lastChildDetailAST.getType() != 7) {
            javaLambdaExpression.setLambdaActionJavaExpression(JavaParserUtil._parseJavaExpression(lastChildDetailAST));
        }
        return javaLambdaExpression;
    }

    private static List<JavaLambdaParameter> _parseJavaLambdaParameters(DetailAST parametersDetailAST) {
        ArrayList<JavaLambdaParameter> javaLambdaParameters = new ArrayList<JavaLambdaParameter>();
        List<DetailAST> parameterDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(parametersDetailAST, false, 21);
        for (DetailAST parameterDefinitionDetailAST : parameterDefinitionDetailASTList) {
            JavaLambdaParameter javaLambdaParameter = new JavaLambdaParameter(JavaParserUtil._getName(parameterDefinitionDetailAST));
            DetailAST typeDetailAST = parameterDefinitionDetailAST.findFirstToken(13);
            if (typeDetailAST.getFirstChild() != null) {
                javaLambdaParameter.setJavaType(JavaParserUtil._parseJavaType(typeDetailAST));
            }
            javaLambdaParameters.add(javaLambdaParameter);
        }
        return javaLambdaParameters;
    }

    private static JavaExpression _parseJavaMethodCall(DetailAST methodCallDetailAST) {
        JavaExpression javaExpression = null;
        JavaMethodCall javaMethodCall = null;
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 58) {
            javaMethodCall = new JavaMethodCall(firstChildDetailAST.getText());
            javaMethodCall.setGenericJavaTypes(JavaParserUtil._parseGenericJavaTypes(methodCallDetailAST.findFirstToken(163), 164));
        } else {
            Tuple chainTuple = JavaParserUtil._getChainTuple(firstChildDetailAST);
            String name = (String)chainTuple.getObject(0);
            javaExpression = (JavaExpression)chainTuple.getObject(1);
            if (javaExpression != null) {
                javaMethodCall = new JavaMethodCall(name);
            } else {
                int i = name.lastIndexOf(".");
                if (i == -1) {
                    javaMethodCall = new JavaMethodCall(name);
                } else {
                    javaMethodCall = new JavaMethodCall(name.substring(i + 1));
                    javaExpression = new JavaSimpleValue(name.substring(0, i));
                }
            }
            javaMethodCall.setGenericJavaTypes(JavaParserUtil._parseGenericJavaTypes(firstChildDetailAST.findFirstToken(163), 164));
        }
        javaMethodCall.setParameterValueJavaExpressions(JavaParserUtil._parseParameterValueJavaExpressions(methodCallDetailAST.findFirstToken(34)));
        boolean insideConstructorCall = DetailASTUtil.hasParentWithTokenType(methodCallDetailAST, 43, 42);
        javaMethodCall.setInsideConstructorCall(insideConstructorCall);
        if (javaExpression == null) {
            javaMethodCall.setMethodCallWithinClass(true);
            return javaMethodCall;
        }
        javaExpression.setChainedJavaExpression(javaMethodCall);
        return javaExpression;
    }

    private static JavaMethodDefinition _parseJavaMethodDefinition(DetailAST methodDefinitionDetailAST) {
        return new JavaMethodDefinition(JavaParserUtil._parseJavaAnnotations(methodDefinitionDetailAST.findFirstToken(5)), JavaParserUtil._parseJavaSignature(methodDefinitionDetailAST));
    }

    private static JavaMethodReference _parseJavaMethodReference(DetailAST methodReferenceDetailAST) {
        DetailAST lastChildDetailAST = methodReferenceDetailAST.getLastChild();
        JavaExpression referenceJavaExpression = JavaParserUtil._parseJavaExpression(methodReferenceDetailAST.getFirstChild(), true);
        if (referenceJavaExpression instanceof JavaTypeCast) {
            referenceJavaExpression.setHasSurroundingParentheses(true);
        }
        return new JavaMethodReference(lastChildDetailAST.getText(), referenceJavaExpression, JavaParserUtil._parseGenericJavaTypes(methodReferenceDetailAST.findFirstToken(163), 164));
    }

    private static JavaNewArrayInstantiation _parseJavaNewArrayInstantiation(DetailAST literalNewDetailAST) {
        JavaNewArrayInstantiation javaNewArrayInstantiation = new JavaNewArrayInstantiation();
        JavaArrayDeclarator javaArrayDeclarator = new JavaArrayDeclarator(JavaParserUtil._getName(literalNewDetailAST), JavaParserUtil._parseArrayValueJavaExpressions(literalNewDetailAST.findFirstToken(17)));
        javaArrayDeclarator.setGenericJavaTypes(JavaParserUtil._parseGenericJavaTypes(literalNewDetailAST.findFirstToken(163), 164));
        javaNewArrayInstantiation.setJavaArrayDeclarator(javaArrayDeclarator);
        DetailAST arrayInitDetailAST = literalNewDetailAST.findFirstToken(29);
        if (arrayInitDetailAST != null) {
            javaNewArrayInstantiation.setInitialJavaArray(JavaParserUtil._parseJavaArray(arrayInitDetailAST));
        }
        return javaNewArrayInstantiation;
    }

    private static JavaNewClassInstantiation _parseJavaNewClassInstantiation(DetailAST literalNewDetailAST) {
        return new JavaNewClassInstantiation(JavaParserUtil._parseJavaClassCall(literalNewDetailAST));
    }

    private static JavaOperatorExpression _parseJavaOperatorExpression(DetailAST detailAST, JavaOperator javaOperator) {
        JavaOperatorExpression javaOperatorExpression = new JavaOperatorExpression(javaOperator);
        if (javaOperator.hasLeftHandExpression()) {
            javaOperatorExpression.setLeftHandJavaExpression(JavaParserUtil._parseJavaExpression(detailAST.getFirstChild(), true));
        }
        if (javaOperator.hasRightHandExpression()) {
            javaOperatorExpression.setRightHandJavaExpression(JavaParserUtil._parseJavaExpression(detailAST.getLastChild(), true));
        }
        return javaOperatorExpression;
    }

    private static JavaPackageDefinition _parseJavaPackageDefinition(DetailAST packageDefinitionDetailAST) {
        return new JavaPackageDefinition(JavaParserUtil._getName(packageDefinitionDetailAST), JavaParserUtil._parseJavaAnnotations(packageDefinitionDetailAST.findFirstToken(158)));
    }

    private static JavaParameter _parseJavaParameter(DetailAST parameterDefinitionDetailAST) {
        DetailAST modifiersDetailAST = parameterDefinitionDetailAST.findFirstToken(5);
        DetailAST typeDetailAST = parameterDefinitionDetailAST.findFirstToken(13);
        JavaType javaType = JavaParserUtil._parseJavaType(typeDetailAST);
        DetailAST ellipsisDetailAST = parameterDefinitionDetailAST.findFirstToken(171);
        if (ellipsisDetailAST != null) {
            javaType.setVarargs(true);
        }
        return new JavaParameter(JavaParserUtil._getName(parameterDefinitionDetailAST), JavaParserUtil._parseModifiers(modifiersDetailAST), javaType);
    }

    private static List<JavaParameter> _parseJavaParameters(DetailAST detailAST) {
        ArrayList<JavaParameter> javaParameters = new ArrayList<JavaParameter>();
        if (detailAST == null) {
            return javaParameters;
        }
        List<DetailAST> parameterDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, false, 21);
        for (DetailAST parameterDefinitionDetailAST : parameterDefinitionDetailASTList) {
            javaParameters.add(JavaParserUtil._parseJavaParameter(parameterDefinitionDetailAST));
        }
        return javaParameters;
    }

    private static JavaReturnStatement _parseJavaReturnStatement(DetailAST literalReturnDetailAST) {
        JavaReturnStatement javaReturnStatement = new JavaReturnStatement();
        DetailAST firstChildDetailAST = literalReturnDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 45) {
            javaReturnStatement.setReturnJavaExpression(JavaParserUtil._parseJavaExpression(firstChildDetailAST));
        }
        return javaReturnStatement;
    }

    private static JavaSignature _parseJavaSignature(DetailAST detailAST) {
        DetailAST identDetailAST = detailAST.findFirstToken(58);
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        List<JavaType> exceptionJavaTypes = JavaParserUtil._parseExceptionJavaTypes(detailAST.findFirstToken(81));
        if (exceptionJavaTypes.size() > 1) {
            Collections.sort(exceptionJavaTypes);
        }
        return new JavaSignature(identDetailAST.getText(), JavaParserUtil._parseModifiers(modifiersDetailAST), JavaParserUtil._parseJavaType(detailAST.findFirstToken(13)), JavaParserUtil._parseGenericJavaTypes(detailAST.findFirstToken(165), 166), JavaParserUtil._parseJavaParameters(detailAST.findFirstToken(20)), exceptionJavaTypes);
    }

    private static JavaSwitchCaseStatement _parseJavaSwitchCaseStatement(DetailAST caseGroupDetailAST) {
        JavaSwitchCaseStatement javaSwitchCaseStatement = new JavaSwitchCaseStatement();
        DetailAST literalDefaultDetailAST = caseGroupDetailAST.findFirstToken(94);
        if (literalDefaultDetailAST != null) {
            javaSwitchCaseStatement.addDefault();
        }
        List<DetailAST> literalCaseDetailASTList = DetailASTUtil.getAllChildTokens(caseGroupDetailAST, false, 93);
        for (DetailAST literalCaseDetailAST : literalCaseDetailASTList) {
            javaSwitchCaseStatement.addSwitchCaseJavaExpression(JavaParserUtil._parseJavaExpression(literalCaseDetailAST.getFirstChild()));
        }
        return javaSwitchCaseStatement;
    }

    private static JavaSwitchStatement _parseJavaSwitchStatement(DetailAST literalSwitchDetailAST) {
        DetailAST lparenDetailAST = literalSwitchDetailAST.getFirstChild();
        return new JavaSwitchStatement(JavaParserUtil._parseJavaExpression(lparenDetailAST.getNextSibling()));
    }

    private static JavaSynchronizedStatement _parseJavaSynchronizedStatement(DetailAST literalSynchronizedDetailAST) {
        JavaSynchronizedStatement javaSynchronizedStatement = new JavaSynchronizedStatement();
        DetailAST firstChildDetailAST = literalSynchronizedDetailAST.getFirstChild();
        javaSynchronizedStatement.setSynchronizedJavaExpression(JavaParserUtil._parseJavaExpression(firstChildDetailAST.getNextSibling()));
        return javaSynchronizedStatement;
    }

    private static JavaTernaryOperator _parseJavaTernaryOperator(DetailAST questionDetailAST) {
        JavaExpression trueValueJavaExpression;
        JavaExpression falseValueJavaExpression;
        DetailAST colonDetailAST = questionDetailAST.findFirstToken(82);
        JavaExpression conditionJavaExpression = JavaParserUtil._parseJavaExpression(questionDetailAST.getFirstChild(), true);
        if (conditionJavaExpression instanceof JavaTernaryOperator) {
            conditionJavaExpression.setHasSurroundingParentheses(true);
        }
        if ((falseValueJavaExpression = JavaParserUtil._parseJavaExpression(colonDetailAST.getNextSibling(), true)) instanceof JavaTernaryOperator) {
            falseValueJavaExpression.setHasSurroundingParentheses(true);
        }
        if ((trueValueJavaExpression = JavaParserUtil._parseJavaExpression(colonDetailAST.getPreviousSibling(), true)) instanceof JavaTernaryOperator) {
            trueValueJavaExpression.setHasSurroundingParentheses(true);
        }
        return new JavaTernaryOperator(conditionJavaExpression, trueValueJavaExpression, falseValueJavaExpression);
    }

    private static JavaThrowStatement _parseJavaThrowStatement(DetailAST literalThrowDetailAST) {
        return new JavaThrowStatement(JavaParserUtil._parseJavaExpression(literalThrowDetailAST.getFirstChild()));
    }

    private static JavaTryStatement _parseJavaTryStatement(DetailAST literalTryDetailAST) {
        JavaTryStatement javaTryStatement = new JavaTryStatement();
        DetailAST firstChildDetailAST = literalTryDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 176) {
            return javaTryStatement;
        }
        ArrayList<JavaVariableDefinition> resourceJavaVariableDefinitions = new ArrayList<JavaVariableDefinition>();
        DetailAST resourcesDetailAST = firstChildDetailAST.findFirstToken(177);
        List<DetailAST> resourceDetailASTList = DetailASTUtil.getAllChildTokens(resourcesDetailAST, false, 178);
        for (DetailAST resourceDetailAST : resourceDetailASTList) {
            resourceJavaVariableDefinitions.add(JavaParserUtil._parseJavaVariableDefinition(resourceDetailAST));
        }
        javaTryStatement.setResourceJavaVariableDefinitions(resourceJavaVariableDefinitions);
        return javaTryStatement;
    }

    private static JavaType _parseJavaType(DetailAST detailAST) {
        DetailAST childDetailAST;
        if (detailAST == null) {
            return null;
        }
        ArrayList<JavaAnnotation> javaAnnotations = new ArrayList();
        if (detailAST.getType() == 13) {
            DetailAST parentDetailAST = detailAST.getParent();
            DetailAST previousSiblingDetailAST = detailAST.getPreviousSibling();
            if (parentDetailAST.getType() == 21 && previousSiblingDetailAST != null && previousSiblingDetailAST.getType() == 5) {
                javaAnnotations = JavaParserUtil._parseJavaAnnotations(previousSiblingDetailAST);
            }
        }
        if ((childDetailAST = detailAST.getFirstChild()).getType() == 158) {
            javaAnnotations = JavaParserUtil._parseJavaAnnotations(childDetailAST);
            childDetailAST = childDetailAST.getNextSibling();
        }
        int arrayDimension = JavaParserUtil._getArrayDimension(detailAST);
        while (childDetailAST.getType() == 17) {
            childDetailAST = childDetailAST.getFirstChild();
        }
        FullIdent typeIdent = FullIdent.createFullIdent(childDetailAST);
        JavaType javaType = new JavaType(typeIdent.getText(), javaAnnotations, arrayDimension);
        DetailAST typeInfoDetailAST = childDetailAST;
        if (childDetailAST.getType() != 59) {
            typeInfoDetailAST = childDetailAST.getParent();
        }
        javaType.setGenericJavaTypes(JavaParserUtil._parseGenericJavaTypes(typeInfoDetailAST.findFirstToken(163), 164));
        javaType.setLowerBoundJavaTypes(JavaParserUtil._parseGenericBoundJavaTypes(typeInfoDetailAST, 169));
        javaType.setUpperBoundJavaTypes(JavaParserUtil._parseGenericBoundJavaTypes(typeInfoDetailAST, 168));
        return javaType;
    }

    private static JavaTypeCast _parseJavaTypeCast(DetailAST typeCastDetailAST) {
        ArrayList<JavaType> javaTypes = new ArrayList<JavaType>();
        DetailAST childDetailAST = typeCastDetailAST.getFirstChild();
        javaTypes.add(JavaParserUtil._parseJavaType(childDetailAST));
        while ((childDetailAST = childDetailAST.getNextSibling()).getType() == 174) {
            childDetailAST = childDetailAST.getNextSibling();
            javaTypes.add(JavaParserUtil._parseJavaType(childDetailAST));
        }
        return new JavaTypeCast(javaTypes, JavaParserUtil._parseJavaExpression(typeCastDetailAST.getLastChild(), true));
    }

    private static JavaVariableDefinition _parseJavaVariableDefinition(DetailAST detailAST) {
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        JavaVariableDefinition javaVariableDefinition = new JavaVariableDefinition(JavaParserUtil._parseJavaAnnotations(modifiersDetailAST), JavaParserUtil._parseModifiers(modifiersDetailAST));
        javaVariableDefinition.setJavaType(JavaParserUtil._parseJavaType(detailAST.findFirstToken(13)));
        while (true) {
            String name = JavaParserUtil._getName(detailAST);
            DetailAST assignDetailAST = detailAST.findFirstToken(80);
            if (assignDetailAST == null) {
                javaVariableDefinition.addVariable(name);
            } else {
                javaVariableDefinition.addVariable(name, JavaParserUtil._parseJavaExpression(assignDetailAST.getFirstChild()));
            }
            detailAST = detailAST.getNextSibling();
            if (detailAST == null || detailAST.getType() != 74) {
                return javaVariableDefinition;
            }
            detailAST = detailAST.getNextSibling();
        }
    }

    private static JavaWhileStatement _parseJavaWhileStatement(DetailAST detailAST) {
        DetailAST lparenDetailAST = null;
        lparenDetailAST = detailAST.getType() == 84 ? detailAST.getFirstChild() : detailAST.getNextSibling();
        return new JavaWhileStatement(JavaParserUtil._parseJavaExpression(lparenDetailAST.getNextSibling()));
    }

    private static List<JavaSimpleValue> _parseModifiers(DetailAST modifiersDetailAST) {
        ArrayList<JavaSimpleValue> modifiers = new ArrayList<JavaSimpleValue>();
        DetailAST childDetailAST = modifiersDetailAST.getFirstChild();
        while (true) {
            if (childDetailAST == null) {
                Collections.sort(modifiers, new ModifierComparator());
                return modifiers;
            }
            if (childDetailAST.getType() != 159) {
                modifiers.add(new JavaSimpleValue(childDetailAST.getText()));
            }
            childDetailAST = childDetailAST.getNextSibling();
        }
    }

    private static List<JavaExpression> _parseParameterValueJavaExpressions(DetailAST elistDetailAST) {
        ArrayList<JavaExpression> parameterValueJavaExpressions = new ArrayList<JavaExpression>();
        DetailAST childDetailAST = elistDetailAST.getFirstChild();
        if (childDetailAST == null) {
            return parameterValueJavaExpressions;
        }
        while (true) {
            parameterValueJavaExpressions.add(JavaParserUtil._parseJavaExpression(childDetailAST));
            childDetailAST = childDetailAST.getNextSibling();
            if (childDetailAST == null) {
                return parameterValueJavaExpressions;
            }
            childDetailAST = childDetailAST.getNextSibling();
        }
    }
}

