/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.context;

import com.liferay.faces.portal.bean.Liferay;
import com.liferay.faces.portal.context.LiferayPortletHelper;
import com.liferay.faces.portal.security.AuthorizationException;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayPortletHelperImpl
implements LiferayPortletHelper,
Serializable {
    private static final long serialVersionUID = 3313208322138123167L;
    private static final Logger logger = LoggerFactory.getLogger(LiferayPortletHelperImpl.class);

    @Override
    public void checkUserPortletPermission(String actionId) throws AuthorizationException {
        try {
            if (!this.userHasPortletPermission(actionId)) {
                throw new AuthorizationException("User " + this.getUserId() + " not authorized to perform action " + actionId);
            }
        }
        catch (Exception e) {
            throw new AuthorizationException("Exception checking permissions for actionId " + actionId, e);
        }
    }

    @Override
    public boolean userHasPortletPermission(String actionId) {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        String portletId = themeDisplay.getPortletDisplay().getId();
        boolean hasPermission = false;
        try {
            hasPermission = PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)themeDisplay.getPlid(), (String)portletId, (String)actionId);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
        return hasPermission;
    }

    @Override
    public boolean userHasRole(String roleName) {
        try {
            List<Role> roles = this.getUserRoles();
            for (Role role : roles) {
                if (!role.getName().equals(roleName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
        return false;
    }

    @Override
    public long getCompanyId() {
        return this.getThemeDisplay().getCompanyId();
    }

    @Override
    public String getDocumentLibraryURL() {
        return this.getPortalURL() + "/c/document_library";
    }

    @Override
    public long getHostGroupId() {
        return this.getLayout().getGroupId();
    }

    @Override
    public String getImageGalleryURL() {
        return this.getPortalURL() + "/image_gallery";
    }

    @Override
    public Layout getLayout() {
        return this.getThemeDisplay().getLayout();
    }

    protected Liferay getLiferayManagedBean() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (Liferay)facesContext.getApplication().getELResolver().getValue(facesContext.getELContext(), null, (Object)"liferay");
    }

    @Override
    public PermissionChecker getPermissionChecker() {
        return this.getThemeDisplay().getPermissionChecker();
    }

    @Override
    public long getPlid() {
        return this.getThemeDisplay().getPlid();
    }

    @Override
    public String getPortalURL() {
        return this.getThemeDisplay().getPortalURL();
    }

    @Override
    public Portlet getPortlet() {
        Portlet portlet = (Portlet)this.getPortletRequest().getAttribute("RENDER_PORTLET");
        if (portlet == null) {
            portlet = this.getLiferayManagedBean().getPortlet();
        }
        return portlet;
    }

    @Override
    public String getPortletInstanceId() {
        return this.getPortlet().getPortletId();
    }

    protected PortletRequest getPortletRequest() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        PortletRequest portletRequest = (PortletRequest)facesContext.getExternalContext().getRequest();
        return portletRequest;
    }

    @Override
    public String getPortletRootId() {
        return this.getPortlet().getRootPortletId();
    }

    @Override
    public Group getScopeGroup() {
        return this.getThemeDisplay().getScopeGroup();
    }

    @Override
    public long getScopeGroupId() {
        return this.getThemeDisplay().getScopeGroupId();
    }

    @Override
    public User getScopeGroupUser() {
        User groupUser = null;
        Group scopeGroup = this.getScopeGroup();
        if (scopeGroup.isUser()) {
            try {
                groupUser = UserLocalServiceUtil.getUserById((long)scopeGroup.getClassPK());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), new Object[]{e});
            }
        }
        return groupUser;
    }

    @Override
    public ServiceContext getServiceContext() {
        ServiceContext serviceContext = new ServiceContext();
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        serviceContext.setCompanyId(themeDisplay.getCompanyId());
        serviceContext.setLanguageId(themeDisplay.getLanguageId());
        serviceContext.setPathMain(PortalUtil.getPathMain());
        serviceContext.setPlid(themeDisplay.getPlid());
        serviceContext.setPortalURL(PortalUtil.getPortalURL((PortletRequest)this.getPortletRequest()));
        serviceContext.setScopeGroupId(themeDisplay.getScopeGroupId());
        serviceContext.setUserId(themeDisplay.getUserId());
        try {
            serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay));
            serviceContext.setLayoutURL(PortalUtil.getLayoutURL((ThemeDisplay)themeDisplay));
            serviceContext.setUserDisplayURL(themeDisplay.getUser().getDisplayURL(themeDisplay));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
        return serviceContext;
    }

    @Override
    public Theme getTheme() {
        return this.getThemeDisplay().getTheme();
    }

    @Override
    public ThemeDisplay getThemeDisplay() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getPortletRequest().getAttribute("THEME_DISPLAY");
        return themeDisplay;
    }

    @Override
    public String getThemeImagesURL() {
        String portalURL = null;
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        String cdnHost = themeDisplay.getCDNHost();
        portalURL = cdnHost != null && cdnHost.length() > 0 ? cdnHost : themeDisplay.getPortalURL();
        String pathThemeImages = themeDisplay.getPathThemeImages();
        if (pathThemeImages.startsWith(portalURL)) {
            return pathThemeImages;
        }
        return portalURL + pathThemeImages;
    }

    @Override
    public User getUser() {
        return this.getThemeDisplay().getUser();
    }

    @Override
    public long getUserId() {
        return this.getUser().getUserId();
    }

    @Override
    public List<Role> getUserRoles() throws SystemException {
        return RoleLocalServiceUtil.getUserRoles((long)this.getUserId());
    }
}

