/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.context;

import com.liferay.faces.portal.context.PortletHelper;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.helper.ShortHelper;
import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class PortletHelperImpl
implements PortletHelper,
Serializable {
    private static final long serialVersionUID = 840141805125109913L;
    private static final String REQUEST_ATTR_PORTLET_CONFIG = "javax.portlet.config";

    public PortletURL createActionURL() {
        return this.getPortletRenderResponse().createActionURL();
    }

    public PortletURL createRenderURL() {
        return this.getPortletRenderResponse().createRenderURL();
    }

    public ActionResponse getActionResponse() {
        return (ActionResponse)this.getPortletResponse();
    }

    public boolean isWindowMaximized() {
        return this.getWindowState() == WindowState.MAXIMIZED;
    }

    public boolean isUserInRole(String roleName) {
        return this.getPortletRequest().isUserInRole(roleName);
    }

    public boolean isWindowNormal() {
        return this.getWindowState() == WindowState.NORMAL;
    }

    public PortalContext getPortalContext() {
        return this.getPortletRequest().getPortalContext();
    }

    public PortletConfig getPortletConfig() {
        return (PortletConfig)this.getPortletRequest().getAttribute(REQUEST_ATTR_PORTLET_CONFIG);
    }

    public PortletContext getPortletContext() {
        return this.getPortletSession().getPortletContext();
    }

    public String getPortletContextName() {
        return this.getPortletContext().getPortletContextName();
    }

    public void setPortletMode(PortletMode portletMode) {
        ActionResponse response = this.getActionResponse();
        try {
            response.setPortletMode(portletMode);
        }
        catch (PortletModeException e) {
            throw new UnsupportedOperationException("Invalid portlet mode", e);
        }
    }

    public String getPortletName() {
        return this.getPortletConfig().getPortletName();
    }

    public Object getPortletPreference(String preferenceName, Object defaultValue) {
        String defaultValueAsString = null;
        if (defaultValue != null) {
            defaultValueAsString = defaultValue.toString();
        }
        String value = this.getPortletPreferences().getValue(preferenceName, defaultValueAsString);
        return value;
    }

    public boolean getPortletPreferenceAsBool(String preferenceName, boolean defaultValue) {
        Object value = this.getPortletPreference(preferenceName, defaultValue);
        if (value != null) {
            return BooleanHelper.toBoolean((String)value.toString(), (boolean)defaultValue);
        }
        return defaultValue;
    }

    public int getPortletPreferenceAsInt(String preferenceName, int defaultValue) {
        Object value = this.getPortletPreference(preferenceName, defaultValue);
        if (value != null) {
            return IntegerHelper.toInteger((String)value.toString(), (int)defaultValue);
        }
        return defaultValue;
    }

    public short getPortletPreferenceAsShort(String preferenceName, short defaultValue) {
        Object value = this.getPortletPreference(preferenceName, defaultValue);
        if (value != null) {
            return ShortHelper.toShort((String)value.toString(), (short)defaultValue);
        }
        return defaultValue;
    }

    public String getPortletPreferenceAsString(String preferenceName, String defaultValue) {
        Object value = this.getPortletPreference(preferenceName, defaultValue);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public PortletPreferences getPortletPreferences() {
        return this.getPortletRequest().getPreferences();
    }

    public RenderRequest getPortletRenderRequest() {
        return (RenderRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
    }

    public RenderResponse getPortletRenderResponse() {
        return (RenderResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
    }

    public PortletRequest getPortletRequest() {
        return (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
    }

    public PortletResponse getPortletResponse() {
        return (PortletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
    }

    public PortletSession getPortletSession() {
        return this.getPortletRequest().getPortletSession();
    }

    public String getRemoteUser() {
        return this.getPortletRequest().getRemoteUser();
    }

    public Object getSessionSharedAttribute(String name) {
        Object value = null;
        PortletSession portletSession = (PortletSession)FacesContext.getCurrentInstance().getExternalContext().getSession(false);
        if (portletSession != null) {
            value = portletSession.getAttribute(name, 1);
        }
        return value;
    }

    public void setSessionSharedAttribute(String name, Object value) {
        PortletSession portletSession = (PortletSession)FacesContext.getCurrentInstance().getExternalContext().getSession(true);
        if (portletSession != null) {
            portletSession.setAttribute(name, value, 1);
        }
    }

    public boolean isPortletEnvironment() {
        boolean portletEnvironment = false;
        Object request = FacesContext.getCurrentInstance().getExternalContext().getRequest();
        if (request != null && request instanceof PortletRequest) {
            portletEnvironment = true;
        }
        return portletEnvironment;
    }

    public WindowState getWindowState() {
        return this.getPortletRequest().getWindowState();
    }

    public void setWindowState(WindowState windowState) {
        ActionResponse response = this.getActionResponse();
        try {
            response.setWindowState(windowState);
        }
        catch (WindowStateException e) {
            throw new UnsupportedOperationException("Invalid window state", e);
        }
    }

    public void setWindowStateToMaximized() {
        this.setWindowState(WindowState.MAXIMIZED);
    }

    public void setWindowStateToNormal() {
        this.setWindowState(WindowState.NORMAL);
    }
}

