/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.el;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.portal.model.User;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortraitURLMap
extends HashMap<Object, String> {
    private static final long serialVersionUID = 8436757896582374186L;
    private static final Logger logger = LoggerFactory.getLogger(PortraitURLMap.class);
    private String liferayImageURL;

    public PortraitURLMap(String liferayImageURL) {
        this.liferayImageURL = liferayImageURL;
    }

    @Override
    public String get(Object key) {
        String url = null;
        if (key != null && (url = (String)super.get(key)) == null) {
            if (key instanceof User) {
                url = this.getByUser((User)key);
            } else if (key instanceof Long) {
                url = this.getByPortraitId((Long)key);
            } else {
                logger.error("Unable to get portrait with object class type [{}]", new Object[]{key.getClass()});
            }
            this.put(key, url);
        }
        return url;
    }

    protected String getByPortraitId(Long portraitId) {
        return this.liferayImageURL + "/user_portrait?img_id=" + portraitId;
    }

    protected String getByUser(User user) {
        String url = null;
        url = this.isMale(user) ? this.liferayImageURL + "/user_male_portrait?img_id=" + user.getPortraitId() : this.liferayImageURL + "/user_female_portrait?img_id=" + user.getPortraitId();
        return url;
    }

    protected boolean isMale(User user) {
        boolean male = true;
        try {
            male = user.isMale();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
        return male;
    }
}

