/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.lifecycle;

import com.liferay.faces.portal.context.LiferayFacesContext;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.Locale;
import javax.faces.component.UIViewRoot;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

public class LiferayLocalePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 3186309855861540422L;
    private static final Logger logger = LoggerFactory.getLogger(LiferayLocalePhaseListener.class);

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId() == PhaseId.RESTORE_VIEW) {
            this.setLocale();
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.setLocale();
        }
    }

    private void setLocale() {
        try {
            Locale locale;
            ThemeDisplay themeDisplay;
            LiferayFacesContext liferayFacesContext = LiferayFacesContext.getInstance();
            if (liferayFacesContext.isPortletEnvironment() && (themeDisplay = liferayFacesContext.getThemeDisplay()) != null && (locale = themeDisplay.getLocale()) != null) {
                UIViewRoot viewRoot = liferayFacesContext.getViewRoot();
                if (viewRoot != null) {
                    viewRoot.setLocale(locale);
                } else {
                    logger.error("viewRoot is null!");
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

