/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.listener;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class StartupListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(StartupListener.class);

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            URL jspURL = this.getClass().getClassLoader().getResource("META-INF/resources/liferay-ui/jsp/input-editor.jsp");
            if (jspURL != null) {
                int bytesRead;
                String realPath = servletContextEvent.getServletContext().getRealPath("/");
                File destFolder = new File(realPath, "resources/liferay-ui/jsp");
                destFolder.mkdirs();
                File destFile = new File(destFolder, "input-editor.jsp");
                InputStream inputStream = jspURL.openStream();
                FileOutputStream outputStream = new FileOutputStream(destFile);
                byte[] bytes = new byte[1024];
                while ((bytesRead = inputStream.read(bytes)) != -1) {
                    ((OutputStream)outputStream).write(bytes, 0, bytesRead);
                }
                outputStream.flush();
                ((OutputStream)outputStream).close();
                inputStream.close();
                logger.info("Copied input-editor.jsp from LiferayFaces JAR to context path file=[{0}]", new Object[]{destFile.getAbsolutePath()});
            } else {
                logger.warn("Unable to find input-editor.jsp in LiferayFaces JAR which means liferay-ui:input-editor won't work");
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

