/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.renderkit;

import com.liferay.faces.portal.component.InputEditorInternal;
import com.liferay.faces.portal.context.LiferayFacesContext;
import com.liferay.faces.portal.servlet.NonNamespacedHttpServletRequest;
import com.liferay.faces.util.jsp.JspIncludeResponse;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.CleanupRenderer;
import com.liferay.portal.kernel.editor.EditorUtil;
import com.liferay.portal.kernel.servlet.taglib.aui.ScriptData;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.filter.PortletRequestWrapper;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InputEditorInternalRenderer
extends Renderer
implements CleanupRenderer {
    private static final Logger logger = LoggerFactory.getLogger(InputEditorInternalRenderer.class);
    private static final String EDITOR_NAME_TOKEN = "%EDITOR_NAME%";
    private static final String ONBLUR_JS;
    private static final String ONBLUR_METHOD_NAME_TOKEN = "%ONBLUR_METHOD_NAME%";
    private static final String COMMENT_CDATA_CLOSE = "// ]]>";
    private static final String CKEDITOR = "ckeditor";

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeBegin(facesContext, uiComponent);
        InputEditorInternal inputEditorInternal = (InputEditorInternal)uiComponent;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        PortletResponse portletResponse = (PortletResponse)externalContext.getResponse();
        Object httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        httpServletRequest = new NonNamespacedHttpServletRequest((HttpServletRequest)httpServletRequest);
        HttpServletResponse httpServletResponse = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
        PortletRequest liferayPortletRequest = this.getLiferayPortletRequest(portletRequest);
        boolean resourcePhase = liferayPortletRequest instanceof ResourceRequest;
        Map attributes = inputEditorInternal.getAttributes();
        String onBlurMethod = (String)attributes.get("onBlurMethod");
        String editorImpl = (String)attributes.get("editorImpl");
        if (editorImpl == null) {
            editorImpl = CKEDITOR;
        }
        String url = "/resources/liferay-ui/jsp/input-editor.jsp";
        StringBuilder queryString = new StringBuilder();
        queryString.append("?");
        queryString.append("editorImpl");
        queryString.append("=");
        queryString.append(editorImpl);
        queryString.append("&");
        queryString.append("height");
        queryString.append("=");
        queryString.append(attributes.get("height"));
        queryString.append("&");
        queryString.append("initMethod");
        queryString.append("=");
        queryString.append(attributes.get("initMethod"));
        queryString.append("&");
        queryString.append("name");
        queryString.append("=");
        String editorName = (String)attributes.get("name");
        queryString.append(editorName);
        queryString.append("&");
        queryString.append("onChangeMethod");
        queryString.append("=");
        queryString.append(attributes.get("onChangeMethod"));
        queryString.append("&");
        queryString.append("skipEditorLoading");
        queryString.append("=");
        if (resourcePhase) {
            queryString.append(Boolean.TRUE.toString());
        } else {
            queryString.append(Boolean.FALSE.toString());
        }
        queryString.append("&");
        queryString.append("toolbarSet");
        queryString.append("=");
        queryString.append(attributes.get("toolbarSet"));
        queryString.append("&");
        queryString.append("width");
        queryString.append("=");
        queryString.append(attributes.get("width"));
        url = url + queryString.toString();
        RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(url);
        JspIncludeResponse jspIncludeResponse = new JspIncludeResponse(httpServletResponse);
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)jspIncludeResponse);
        }
        catch (ServletException e) {
            logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        String bufferedResponse = jspIncludeResponse.getBufferedResponse();
        if (bufferedResponse != null) {
            bufferedResponse = bufferedResponse.trim();
            String editorType = EditorUtil.getEditorValue((HttpServletRequest)httpServletRequest, (String)editorImpl);
            if (editorType.indexOf(CKEDITOR) >= 0) {
                ParsedResponse parsedResponse;
                String namespace = portletResponse.getNamespace();
                String onBlurScript = this.getOnBlurScript(editorName, onBlurMethod, namespace);
                if (resourcePhase) {
                    StringBuilder scriptMarkup = new StringBuilder();
                    scriptMarkup.append("<");
                    scriptMarkup.append("script");
                    scriptMarkup.append(">");
                    scriptMarkup.append("<![CDATA[");
                    scriptMarkup.append(onBlurScript);
                    scriptMarkup.append(COMMENT_CDATA_CLOSE);
                    scriptMarkup.append("<");
                    scriptMarkup.append("/");
                    scriptMarkup.append("script");
                    scriptMarkup.append(">");
                    bufferedResponse = bufferedResponse.concat(scriptMarkup.toString());
                } else {
                    ScriptData scriptData = (ScriptData)externalContext.getRequestMap().get("LIFERAY_SHARED_AUI_SCRIPT_DATA");
                    scriptData.append(onBlurScript, null);
                }
                boolean scriptsRemoved = false;
                String clientId = inputEditorInternal.getClientId();
                if (resourcePhase && inputEditorInternal.isPreviouslyRendered()) {
                    logger.debug("Preventing re-initialization of CKEditor for clientId=[{0}]", new Object[]{clientId});
                    parsedResponse = new ParsedResponse(bufferedResponse);
                    bufferedResponse = parsedResponse.getNonScripts();
                    scriptsRemoved = true;
                }
                if (resourcePhase && !scriptsRemoved) {
                    logger.debug("Moving CKEditor scripts to <eval>...</eval> section of the partial-response for clientId=[{0}]", new Object[]{clientId});
                    parsedResponse = new ParsedResponse(bufferedResponse);
                    bufferedResponse = parsedResponse.getNonScripts();
                    String scripts = parsedResponse.getScripts();
                    LiferayFacesContext liferayFacesContext = LiferayFacesContext.getInstance();
                    liferayFacesContext.getJavaScriptMap().put(clientId, scripts);
                    logger.trace(scripts);
                }
            }
            logger.trace(bufferedResponse);
            responseWriter.write(bufferedResponse);
        }
    }

    public void encodeCleanup(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        PortletResponse portletResponse = (PortletResponse)facesContext.getExternalContext().getResponse();
        String namespace = portletResponse.getNamespace();
        String editorName = uiComponent.getParent().getParent().getClientId();
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append("var oldEditor = CKEDITOR.instances['");
        scriptBuilder.append(namespace);
        scriptBuilder.append(editorName);
        scriptBuilder.append("']; if (oldEditor) {");
        scriptBuilder.append("oldEditor.destroy(true);");
        scriptBuilder.append("delete window['");
        scriptBuilder.append(namespace);
        scriptBuilder.append(editorName);
        scriptBuilder.append("'];");
        scriptBuilder.append("}");
        String script = scriptBuilder.toString();
        LiferayFacesContext liferayFacesContext = LiferayFacesContext.getInstance();
        liferayFacesContext.getJavaScriptMap().put(editorName, script);
        logger.trace(script);
    }

    protected PortletRequest getLiferayPortletRequest(PortletRequest portletRequest) {
        PortletRequest liferayPortletRequest = portletRequest;
        if (liferayPortletRequest instanceof PortletRequestWrapper) {
            PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
            liferayPortletRequest = this.getLiferayPortletRequest(portletRequestWrapper.getRequest());
        }
        return liferayPortletRequest;
    }

    protected String getOnBlurScript(String editorName, String onBlurMethod, String namespace) {
        int onBlurTokenPos;
        String onBlurScript = ONBLUR_JS;
        int editorNameTokenPos = onBlurScript.indexOf(EDITOR_NAME_TOKEN);
        if (editorNameTokenPos > 0) {
            onBlurScript = onBlurScript.substring(0, editorNameTokenPos) + namespace + editorName + onBlurScript.substring(editorNameTokenPos + EDITOR_NAME_TOKEN.length());
        }
        if ((onBlurTokenPos = onBlurScript.indexOf(ONBLUR_METHOD_NAME_TOKEN)) > 0) {
            onBlurScript = onBlurScript.substring(0, onBlurTokenPos) + namespace + onBlurMethod + onBlurScript.substring(onBlurTokenPos + ONBLUR_METHOD_NAME_TOKEN.length());
        }
        return onBlurScript;
    }

    static {
        StringBuilder onBlurJS = new StringBuilder();
        onBlurJS.append("(function() {");
        onBlurJS.append("var ckEditor = CKEDITOR.instances['");
        onBlurJS.append(EDITOR_NAME_TOKEN);
        onBlurJS.append("'];");
        onBlurJS.append("ckEditor.on('blur',");
        onBlurJS.append("function () {");
        onBlurJS.append(ONBLUR_METHOD_NAME_TOKEN);
        onBlurJS.append("();");
        onBlurJS.append("});");
        onBlurJS.append("})();");
        ONBLUR_JS = onBlurJS.toString();
    }

    protected class ParsedResponse {
        private String scripts;
        private String nonScripts;

        public ParsedResponse(String response) {
            StringBuilder scriptBuilder = new StringBuilder();
            String beginScriptToken = "<script";
            String endScriptToken = "/script>";
            int endElementLength = endScriptToken.length();
            boolean done1 = false;
            while (!done1) {
                int beginPos = response.indexOf(beginScriptToken);
                int endPos = response.indexOf(endScriptToken, beginPos);
                if (beginPos >= 0 && endPos > beginPos) {
                    String script = response.substring(beginPos, endPos + endElementLength);
                    boolean done2 = false;
                    while (!done2) {
                        int cdataOpenPos = script.indexOf("<![CDATA[");
                        if (cdataOpenPos > 0) {
                            int cdataClosePos = (script = script.substring(cdataOpenPos + "<![CDATA[".length())).indexOf(InputEditorInternalRenderer.COMMENT_CDATA_CLOSE);
                            if (cdataClosePos <= 0) continue;
                            script = script.substring(0, cdataClosePos);
                            continue;
                        }
                        done2 = true;
                    }
                    scriptBuilder.append(script);
                    response = response.substring(0, beginPos) + response.substring(endPos + endElementLength);
                    continue;
                }
                done1 = true;
            }
            this.scripts = scriptBuilder.toString().trim();
            this.nonScripts = response.trim();
        }

        public String getNonScripts() {
            return this.nonScripts;
        }

        public String getScripts() {
            return this.scripts;
        }
    }
}

