/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.renderkit;

import com.liferay.faces.portal.component.PermissionsURL;
import com.liferay.faces.portal.context.LiferayFacesContext;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;

public class PermissionsURLRenderer
extends Renderer {
    private static final String PORTLET_CONFIGURATION = "86";
    private static final Logger logger = LoggerFactory.getLogger(PermissionsURLRenderer.class);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException("One or more parameters are null");
        }
        String href = this.getPermissionsURL(context, component);
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        if (writer != null) {
            writer.startElement("a", component);
            if (null == href || 0 == href.length()) {
                href = "";
            }
            writer.writeURIAttribute("href", (Object)href, "href");
            UIOutput uiOutput = (UIOutput)component;
            Object value = uiOutput.getValue();
            if (value != null) {
                writer.write(value.toString());
            }
            writer.flush();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException("One or more parameters are null");
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        if (writer != null) {
            writer.endElement("a");
        }
    }

    public String getPermissionsURL(FacesContext context, UIComponent component) {
        PermissionsURL permissionsURLComponent = (PermissionsURL)component;
        LiferayFacesContext liferayFacesContext = LiferayFacesContext.getInstance();
        String permissionsURL = "";
        try {
            ExternalContext externalContext = liferayFacesContext.getExternalContext();
            PortletResponse portletResponse = (PortletResponse)externalContext.getResponse();
            if (portletResponse instanceof MimeResponse) {
                String resourcePrimKey;
                MimeResponse mimeResponse = (MimeResponse)portletResponse;
                PortletURL portletURL = mimeResponse.createRenderURL();
                portletURL.setPortletMode(PortletMode.VIEW);
                Class<?> portletURLClass = portletURL.getClass();
                Method method = portletURLClass.getMethod("setPortletId", String.class);
                if (method != null) {
                    method.invoke((Object)portletURL, PORTLET_CONFIGURATION);
                }
                if ((method = portletURLClass.getMethod("setPlid", Long.TYPE)) != null) {
                    long plid = liferayFacesContext.getPlid();
                    method.invoke((Object)portletURL, new Long(plid));
                }
                if ((method = portletURLClass.getMethod("setLifecycle", String.class)) != null) {
                    method.invoke((Object)portletURL, "RENDER_PHASE");
                }
                portletURL.setWindowState(WindowState.MAXIMIZED);
                portletURL.setParameter("struts_action", "/portlet_configuration/edit_permissions");
                ThemeDisplay themeDisplay = liferayFacesContext.getThemeDisplay();
                String redirect = permissionsURLComponent.getRedirect();
                if (redirect != null) {
                    portletURL.setParameter("redirect", redirect);
                    if (!themeDisplay.isStateMaximized()) {
                        portletURL.setParameter("returnToFullPageURL", redirect);
                    }
                }
                PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
                portletURL.setParameter("portletResource", portletDisplay.getId());
                String modelResource = permissionsURLComponent.getModelResource();
                if (modelResource != null) {
                    portletURL.setParameter("modelResource", modelResource);
                } else {
                    logger.error("modelResource cannot be null");
                }
                String modelResourceDescription = permissionsURLComponent.getModelResourceDescription();
                if (modelResourceDescription != null) {
                    portletURL.setParameter("modelResourceDescription", modelResourceDescription);
                }
                if ((resourcePrimKey = permissionsURLComponent.getResourcePrimKey()) != null) {
                    portletURL.setParameter("resourcePrimKey", resourcePrimKey);
                }
                permissionsURL = portletURL.toString();
            } else {
                logger.error("Unable to create a portlet render URL because PortletResponse=[{0}] is not a MimeResponse", new Object[]{portletResponse});
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
            liferayFacesContext.addGlobalUnexpectedErrorMessage();
        }
        return permissionsURL;
    }
}

