/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.resource;

import com.liferay.portal.kernel.captcha.Captcha;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaptchaResource
extends Resource {
    public static final String CONTENT_TYPE = "image/png";
    public static final String RESOURCE_NAME = "captcha";
    private static final String CAPTCHA_TEXT = "CAPTCHA_TEXT";
    private String requestPath;

    public CaptchaResource() {
        this.setLibraryName("liferayfaces");
        this.setResourceName(RESOURCE_NAME);
        this.setContentType(CONTENT_TYPE);
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        return false;
    }

    public InputStream getInputStream() {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
            PortletResponse portletResponse = (PortletResponse)externalContext.getResponse();
            PortletSession portletSession = (PortletSession)externalContext.getSession(true);
            HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
            HttpServletResponse httpServletResponse = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
            CaptchaHttpServletResponse captchaHttpServletResponse = new CaptchaHttpServletResponse(httpServletResponse);
            String captchaClassName = PrefsPropsUtil.getString((String)"captcha.engine.impl");
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            Class<?> captchaClass = portalClassLoader.loadClass(captchaClassName);
            CaptchaUtil captchaUtil = new CaptchaUtil();
            Captcha captcha = (Captcha)captchaClass.newInstance();
            captchaUtil.setCaptcha(captcha);
            CaptchaUtil.serveImage((HttpServletRequest)httpServletRequest, (HttpServletResponse)captchaHttpServletResponse);
            String captchaText = (String)httpServletRequest.getSession().getAttribute(CAPTCHA_TEXT);
            portletSession.setAttribute(CAPTCHA_TEXT, (Object)captchaText);
            CaptchaServletOutputStream captchaServletOutputStream = (CaptchaServletOutputStream)captchaHttpServletResponse.getOutputStream();
            byteArrayInputStream = new ByteArrayInputStream(captchaServletOutputStream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byteArrayInputStream;
    }

    public String getRequestPath() {
        if (this.requestPath == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("/javax.faces.resource");
            buf.append("/");
            buf.append(this.getResourceName());
            buf.append("?ln=");
            buf.append(this.getLibraryName());
            this.requestPath = buf.toString();
            this.requestPath = FacesContext.getCurrentInstance().getExternalContext().encodeResourceURL(this.requestPath);
        }
        return this.requestPath;
    }

    public Map<String, String> getResponseHeaders() {
        return null;
    }

    public URL getURL() {
        return null;
    }

    protected class CaptchaHttpServletResponse
    extends HttpServletResponseWrapper {
        ServletOutputStream outputStream;

        public CaptchaHttpServletResponse(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new CaptchaServletOutputStream();
            }
            return this.outputStream;
        }
    }

    public class CaptchaServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

        public byte[] toByteArray() {
            return this.byteArrayOutputStream.toByteArray();
        }

        public void write(int b) throws IOException {
            this.byteArrayOutputStream.write(b);
        }
    }
}

