/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.resource;

import com.liferay.faces.portal.resource.CaptchaResource;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class LiferayFacesResourceHandler
extends ResourceHandlerWrapper {
    public static final String LIBRARY_NAME = "liferayfaces";
    private static final Logger logger = LoggerFactory.getLogger(LiferayFacesResourceHandler.class);
    private ResourceHandler wrappedResourceHandler;

    public LiferayFacesResourceHandler(ResourceHandler wrappedResourceHandler) {
        this.wrappedResourceHandler = wrappedResourceHandler;
    }

    public Resource createResource(String resourceName, String libraryName) {
        if (LIBRARY_NAME.equals(libraryName)) {
            if ("captcha".equals(resourceName)) {
                return new CaptchaResource();
            }
            return this.wrappedResourceHandler.createResource(resourceName, libraryName);
        }
        return this.wrappedResourceHandler.createResource(resourceName, libraryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        String libraryName = (String)externalContext.getRequestParameterMap().get("ln");
        String resourceName = (String)externalContext.getRequestParameterMap().get("javax.faces.resource");
        if (LIBRARY_NAME.equals(libraryName) && "captcha".equals(resourceName)) {
            Resource resource = this.createResource(resourceName, libraryName);
            Channel readableByteChannel = null;
            Channel writableByteChannel = null;
            InputStream inputStream = null;
            int bufferSize = 1024;
            ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
            try {
                inputStream = resource.getInputStream();
                if (inputStream == null) return;
                int responseBufferSize = byteBuffer.capacity();
                externalContext.setResponseBufferSize(responseBufferSize);
                String responseContentType = resource.getContentType();
                if (responseContentType != null) {
                    externalContext.setResponseContentType(responseContentType);
                }
                int responseContentLength = 0;
                readableByteChannel = Channels.newChannel(inputStream);
                writableByteChannel = Channels.newChannel(externalContext.getResponseOutputStream());
                int bytesRead = readableByteChannel.read(byteBuffer);
                int bytesWritten = 0;
                while (bytesRead != -1) {
                    byteBuffer.rewind();
                    byteBuffer.limit(bytesRead);
                    while ((bytesWritten += writableByteChannel.write(byteBuffer)) < responseContentLength) {
                    }
                    byteBuffer.clear();
                    responseContentLength += bytesRead;
                    bytesRead = readableByteChannel.read(byteBuffer);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Handling - MORE bytesRead=[{0}]", new Object[]{Integer.toString(bytesRead)});
                }
                externalContext.setResponseContentLength(responseContentLength);
                externalContext.setResponseStatus(200);
                logger.debug("HANDLED (SC_OK) resourceName=[{0}], libraryName[{1}], responseContentType=[{2}], responseContentLength=[{3}]", new Object[]{resourceName, libraryName, responseContentType, responseContentLength});
                return;
            }
            catch (IOException e) {
                externalContext.setResponseStatus(404);
                logger.error("NOT HANDLED (SC_NOT_FOUND) resourceName=[{0}], libraryName[{1}], errorMessage=[{2}]", new Object[]{new Object[]{resourceName, libraryName, e.getMessage()}, e});
                return;
            }
            finally {
                if (writableByteChannel != null) {
                    writableByteChannel.close();
                }
                if (readableByteChannel != null) {
                    readableByteChannel.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        } else {
            super.handleResourceRequest(facesContext);
        }
    }

    public boolean libraryExists(String libraryName) {
        if (LIBRARY_NAME.equals(libraryName)) {
            return true;
        }
        return super.libraryExists(libraryName);
    }

    public ResourceHandler getWrapped() {
        return this.wrappedResourceHandler;
    }
}

