/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.validator;

import com.liferay.faces.portal.context.LiferayFacesContext;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.portal.kernel.captcha.CaptchaMaxChallengesException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.portlet.PortletRequest;
import javax.portlet.filter.PortletRequestWrapper;

public class CaptchaValidator
implements Validator {
    private static final String WEB_KEYS_CAPTCHA_TEXT = "CAPTCHA_TEXT";
    private static final Logger logger = LoggerFactory.getLogger(CaptchaValidator.class);

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (value != null) {
            LiferayFacesContext liferayFacesContext = LiferayFacesContext.getInstance();
            try {
                PortletRequest portletRequest = liferayFacesContext.getPortletRequest();
                String userCaptchaTextValue = value.toString();
                String correctCaptchaTextValue = (String)liferayFacesContext.getSessionAttribute(WEB_KEYS_CAPTCHA_TEXT);
                CaptchaPortletRequest captchaPortletRequest = new CaptchaPortletRequest(portletRequest, userCaptchaTextValue);
                CaptchaUtil.check((PortletRequest)captchaPortletRequest);
                liferayFacesContext.setSessionAttribute(WEB_KEYS_CAPTCHA_TEXT, correctCaptchaTextValue);
            }
            catch (CaptchaTextException e) {
                String key = "text-verification-failed";
                String summary = liferayFacesContext.getMessage(key);
                FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, summary);
                throw new ValidatorException(facesMessage);
            }
            catch (CaptchaMaxChallengesException e) {
                String key = "maximum-number-of-captcha-attempts-exceeded";
                String summary = liferayFacesContext.getMessage(key);
                FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, summary);
                throw new ValidatorException(facesMessage);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                String key = "an-unexpected-error-occurred";
                String summary = liferayFacesContext.getMessage(key);
                FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, summary);
                throw new ValidatorException(facesMessage);
            }
        }
    }

    protected class CaptchaPortletRequest
    extends PortletRequestWrapper {
        private String userCaptchaTextValue;

        public CaptchaPortletRequest(PortletRequest portletRequest, String userCaptchaTextValue) {
            super(portletRequest);
            this.userCaptchaTextValue = userCaptchaTextValue;
        }

        public String getParameter(String name) {
            if ("captchaText".equals(name)) {
                return this.userCaptchaTextValue;
            }
            return super.getParameter(name);
        }
    }
}

