/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portal.validator;

import com.liferay.faces.portal.component.UIComponentHelper;
import com.liferay.faces.portal.context.LiferayFacesContext;
import com.liferay.faces.util.context.MessageContext;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.ValidatorException;

public class RichTextLengthValidator
extends LengthValidator {
    private static final Logger logger = LoggerFactory.getLogger(RichTextLengthValidator.class);
    private static final Pattern TAG_PATTERN = Pattern.compile("<.+?>");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");

    public RichTextLengthValidator() {
    }

    public RichTextLengthValidator(int maximum) {
        super(maximum);
    }

    public RichTextLengthValidator(int maximum, int minimum) {
        super(maximum, minimum);
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (facesContext == null || uiComponent == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            int length = this.getPlainTextStringLength(value);
            int minimum = this.getMinimum();
            int maximum = this.getMaximum();
            logger.debug("length=[{0}] minimum=[{1}] maximum=[{2}]", new Object[]{length, minimum, maximum});
            if (minimum > 0 && length < minimum) {
                Object label = UIComponentHelper.getLabel(facesContext, uiComponent);
                LiferayFacesContext liferayFacesContext = LiferayFacesContext.getInstance();
                Locale locale = liferayFacesContext.getLocale();
                MessageContext messageContext = MessageContext.getInstance();
                FacesMessage facesMessage = messageContext.newFacesMessage(locale, FacesMessage.SEVERITY_ERROR, "javax.faces.validator.LengthValidator.MINIMUM", new Object[]{maximum, label});
                throw new ValidatorException(facesMessage);
            }
            if (maximum > 0 && length > maximum) {
                Object label = UIComponentHelper.getLabel(facesContext, uiComponent);
                LiferayFacesContext liferayFacesContext = LiferayFacesContext.getInstance();
                Locale locale = liferayFacesContext.getLocale();
                MessageContext messageContext = MessageContext.getInstance();
                FacesMessage facesMessage = messageContext.newFacesMessage(locale, FacesMessage.SEVERITY_ERROR, "javax.faces.validator.LengthValidator.MAXIMUM", new Object[]{maximum, label});
                throw new ValidatorException(facesMessage);
            }
        }
    }

    protected int getPlainTextStringLength(Object value) {
        int cleanStringLenth = 0;
        if (value != null) {
            String cleanString = null;
            cleanString = value instanceof String ? (String)value : value.toString();
            Matcher tagMatcher = TAG_PATTERN.matcher(cleanString);
            cleanString = tagMatcher.replaceAll("");
            cleanString = cleanString.replaceAll("&nbsp;", " ");
            cleanString = WHITESPACE_PATTERN.matcher(cleanString).replaceAll(" ");
            cleanString = cleanString.trim();
            cleanStringLenth = cleanString.length();
        }
        return cleanStringLenth;
    }
}

