/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.maven.plugins.AbstractToolsLiferayMojo;
import com.liferay.maven.plugins.util.StringUtil;
import com.liferay.maven.plugins.util.Validator;
import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

public class SassToCssBuilderMojo
extends AbstractToolsLiferayMojo {
    private String sassDirNames;
    private String sassDocrootDir;
    private String sassPortalCommonDir;
    private File webappDir;
    private File webappSourceDir;

    @Override
    protected void doExecute() throws Exception {
        IOFileFilter fileFilter = FileFilterUtils.orFileFilter((IOFileFilter)DirectoryFileFilter.DIRECTORY, (IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFileFilter.FILE, (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".css")));
        FileUtils.copyDirectory((File)this.webappSourceDir, (File)this.webappDir, (FileFilter)fileFilter, (boolean)true);
        if (Validator.isNull(this.sassPortalCommonDir)) {
            File file = new File(this.appServerPortalDir, "html/css/common");
            this.sassPortalCommonDir = file.getAbsolutePath();
        }
        String[] args = null;
        String[] dirNames = StringUtil.split(this.sassDirNames);
        if (dirNames.length > 1) {
            if (this.getPortalMajorVersion() < 6.2f) {
                args = new String[dirNames.length];
            } else {
                args = new String[dirNames.length + 2];
                args[dirNames.length] = "sass.docroot.dir=" + this.sassDocrootDir;
                args[dirNames.length + 1] = "sass.portal.common.dir=" + this.sassPortalCommonDir;
            }
            for (int i = 0; i < dirNames.length; ++i) {
                if (!(this.getPortalMajorVersion() < 6.2f)) continue;
                args[i] = "sass.dir." + i + "=" + dirNames[i];
            }
        } else if (this.getPortalMajorVersion() < 6.2f) {
            if (this.sassDirNames.equals("/")) {
                this.sassDirNames = "";
            }
            args = new String[]{"sass.dir=" + this.sassDocrootDir + this.sassDirNames};
        } else {
            args = new String[]{"sass.dir=" + this.sassDirNames, "sass.docroot.dir=" + this.sassDocrootDir, "sass.portal.common.dir=" + this.sassPortalCommonDir};
        }
        this.executeTool("com.liferay.portal.tools.SassToCssBuilder", this.getProjectClassLoader(), args);
    }
}

