/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.RobotsUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class RobotsAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(RobotsAction.class);

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String host = GetterUtil.getString((String)PortalUtil.getHost((HttpServletRequest)request));
            LayoutSet layoutSet = null;
            VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((String)host);
            if (virtualHost != null && virtualHost.getLayoutSetId() > 0L) {
                layoutSet = LayoutSetLocalServiceUtil.fetchLayoutSet((String)host);
            } else {
                Company company = PortalUtil.getCompany((HttpServletRequest)request);
                if (host.equals(company.getVirtualHostname()) && Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME)) {
                    Group defaultGroup = GroupLocalServiceUtil.getGroup((long)company.getCompanyId(), (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                    layoutSet = defaultGroup.getPublicLayoutSet();
                }
            }
            String robots = RobotsUtil.getRobots(layoutSet);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])robots.getBytes("UTF-8"), (String)"text/plain; charset=UTF-8");
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            PortalUtil.sendError((int)500, (Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        return null;
    }
}

