/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.internal.dao.sql.transformer.SQLFunctionTransformer;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DB2SQLTransformerLogic
extends BaseSQLTransformerLogic {
    private static final Pattern _alterColumnTypePattern = Pattern.compile("ALTER_COLUMN_TYPE\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)", 2);
    private static final Pattern _likePattern = Pattern.compile("LIKE \\?", 2);

    public DB2SQLTransformerLogic(DB db) {
        super(db);
        Object[] functions = new Function[]{this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getConcatFunction(), this.getIntegerDivisionFunction(), this.getNullDateFunction(), this._getAlterColumnTypeFunction(), this._getLikeFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = (Function[])ArrayUtil.append((Object[])functions, this.getLowerFunction());
        }
        this.setFunctions((Function[])functions);
    }

    @Override
    protected Function<String, String> getConcatFunction() {
        SQLFunctionTransformer sqlFunctionTransformer = new SQLFunctionTransformer("CONCAT(", "", " CONCAT ", "");
        return sqlFunctionTransformer::transform;
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CAST($1 AS VARCHAR(254))");
    }

    private Function<String, String> _getAlterColumnTypeFunction() {
        return sql -> {
            Matcher matcher = _alterColumnTypePattern.matcher((CharSequence)sql);
            return matcher.replaceAll("ALTER TABLE $1 ALTER COLUMN $2 SET DATA TYPE $3");
        };
    }

    private Function<String, String> _getLikeFunction() {
        return sql -> {
            Matcher matcher = _likePattern.matcher((CharSequence)sql);
            return matcher.replaceAll("LIKE COALESCE(CAST(? AS VARCHAR(32672)),'')");
        };
    }
}

