/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import com.liferay.portal.deploy.auto.ModuleAutoDeployer;
import com.liferay.portal.deploy.auto.PluginAutoDeployListenerHelper;
import com.liferay.portal.deploy.auto.ThreadSafeAutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.BaseAutoDeployListener;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class ModuleAutoDeployListener
extends BaseAutoDeployListener {
    protected AutoDeployer buildAutoDeployer() {
        return new ThreadSafeAutoDeployer(new ModuleAutoDeployer());
    }

    protected String getPluginPathInfoMessage(File file) {
        return "Copied module for " + file.getPath();
    }

    protected String getSuccessMessage(File file) {
        return "Module for " + file.getPath() + " copied successfully";
    }

    protected boolean isDeployable(File file) throws AutoDeployException {
        return this.isModule(file);
    }

    protected boolean isModule(File file) throws AutoDeployException {
        PluginAutoDeployListenerHelper pluginAutoDeployListenerHelper = new PluginAutoDeployListenerHelper(file);
        if (!pluginAutoDeployListenerHelper.isJarFile()) {
            return false;
        }
        JarInputStream jarInputStream = null;
        Manifest manifest = null;
        try {
            jarInputStream = new JarInputStream(new FileInputStream(file));
            manifest = jarInputStream.getManifest();
        }
        catch (IOException ioe) {
            try {
                throw new AutoDeployException((Throwable)ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{jarInputStream});
                throw throwable;
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{jarInputStream});
        if (manifest == null) {
            return false;
        }
        Attributes attributes = manifest.getMainAttributes();
        String bundleSymbolicNameAttributeValue = attributes.getValue("Bundle-SymbolicName");
        Parameters bundleSymbolicNameMap = OSGiHeader.parseHeader((String)bundleSymbolicNameAttributeValue);
        Set bundleSymbolicNameSet = bundleSymbolicNameMap.keySet();
        if (bundleSymbolicNameSet.isEmpty()) {
            return false;
        }
        Iterator bundleSymbolicNameIterator = bundleSymbolicNameSet.iterator();
        String bundleSymbolicName = (String)bundleSymbolicNameIterator.next();
        return Validator.isNotNull((String)bundleSymbolicName);
    }
}

