/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.agent;

import com.liferay.portal.fabric.agent.FabricAgent;
import com.liferay.portal.fabric.agent.FabricAgentListener;
import com.liferay.portal.kernel.concurrent.BaseFutureListener;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessChannel;
import com.liferay.portal.kernel.process.ProcessException;
import java.io.Serializable;
import java.util.concurrent.Future;

public class PortalClassPathWarmupFabricAgentListener
implements FabricAgentListener {
    private static final Log _log = LogFactoryUtil.getLog(PortalClassPathWarmupFabricAgentListener.class);
    private static final ProcessCallable<Serializable> _warmupProcessCallable = new ProcessCallable<Serializable>(){
        private static final long serialVersionUID = 1L;

        public String call() {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Portal class path warmup successful");
            }
            return null;
        }
    };

    @Override
    public void registered(FabricAgent fabricAgent) {
        try {
            long startTime = System.currentTimeMillis();
            ProcessChannel fabricWorker = fabricAgent.execute(ClassPathUtil.getPortalProcessConfig(), (ProcessCallable)_warmupProcessCallable);
            NoticeableFuture noticeableFuture = fabricWorker.getProcessNoticeableFuture();
            noticeableFuture.addFutureListener((FutureListener)new FinishFutureListener(startTime));
        }
        catch (ProcessException pe) {
            _log.error((Object)"Unable to start portal class path warmup fabric worker", (Throwable)pe);
        }
    }

    @Override
    public void unregistered(FabricAgent fabricAgent) {
    }

    protected class FinishFutureListener
    extends BaseFutureListener<Serializable> {
        private final long _startTime;

        public FinishFutureListener(long startTime) {
            this._startTime = startTime;
        }

        public void completeWithCancel(Future<Serializable> future) {
            _log.error((Object)"Portal class path warmup cancelled");
        }

        public void completeWithException(Future<Serializable> future, Throwable throwable) {
            _log.error((Object)"Portal class path warmup failed", throwable);
        }

        public void completeWithResult(Future<Serializable> future, Serializable result) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Portal class path warmup finished successfully in " + (System.currentTimeMillis() - this._startTime) + "ms"));
            }
        }
    }
}

