/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.CustomizedPages;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.PortletWrapper;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.service.PluginSettingLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LayoutTypePortletFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.model.impl.LayoutTemplateImpl;
import com.liferay.portal.model.impl.LayoutTypeImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.sites.kernel.util.SitesUtil;
import com.liferay.util.JS;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletPreferences;

public class LayoutTypePortletImpl
extends LayoutTypeImpl
implements LayoutTypePortlet {
    private static final String _MODIFIED_DATE = "modifiedDate";
    private static final String _NESTED_PORTLETS_NAMESPACE = PortalUtil.getPortletNamespace((String)"com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet");
    private static final String _NULL_DATE = "00000000000000";
    private static final Log _log = LogFactoryUtil.getLog(LayoutTypePortletImpl.class);
    private static final Layout _nullLayout = new LayoutImpl();
    private String _addedCustomPortletMode;
    private boolean _customizedView;
    private final Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)PropsValues.INDEX_DATE_FORMAT_PATTERN);
    private boolean _enablePortletLayoutListener = true;
    private Group _group;
    private Layout _layoutSetPrototypeLayout;
    private PortalPreferences _portalPreferences;
    private boolean _updatePermission;

    public LayoutTypePortletImpl(Layout layout, LayoutTypeController layoutTypeController, LayoutTypeAccessPolicy layoutTypeAccessPolicy) {
        super(layout, layoutTypeController, layoutTypeAccessPolicy);
    }

    public void addModeAboutPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeAbout(StringUtil.add((String)this.getModeAbout(), (String)portletId));
    }

    public void addModeConfigPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeConfig(StringUtil.add((String)this.getModeConfig(), (String)portletId));
    }

    public void addModeCustomPortletId(String portletId, String portletMode) {
        this.removeModesPortletId(portletId);
        this.setModeCustom(StringUtil.add((String)this.getModeCustom(portletMode), (String)portletId), portletMode);
        this._addedCustomPortletMode = portletMode;
    }

    public void addModeEditDefaultsPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEditDefaults(StringUtil.add((String)this.getModeEditDefaults(), (String)portletId));
    }

    public void addModeEditGuestPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEditGuest(StringUtil.add((String)this.getModeEditGuest(), (String)portletId));
    }

    public void addModeEditPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEdit(StringUtil.add((String)this.getModeEdit(), (String)portletId));
    }

    public void addModeHelpPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeHelp(StringUtil.add((String)this.getModeHelp(), (String)portletId));
    }

    public void addModePreviewPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModePreview(StringUtil.add((String)this.getModePreview(), (String)portletId));
    }

    public void addModePrintPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModePrint(StringUtil.add((String)this.getModePrint(), (String)portletId));
    }

    public String addPortletId(long userId, String portletId) {
        return this.addPortletId(userId, portletId, true);
    }

    public String addPortletId(long userId, String portletId, boolean checkPermission) {
        return this.addPortletId(userId, portletId, null, -1, checkPermission);
    }

    public String addPortletId(long userId, String portletId, String columnId, int columnPos) {
        return this.addPortletId(userId, portletId, columnId, columnPos, true);
    }

    public String addPortletId(long userId, String portletId, String columnId, int columnPos, boolean checkPermission) {
        return this.addPortletId(userId, portletId, columnId, columnPos, checkPermission, false);
    }

    public void addPortletIds(long userId, String[] portletIds, boolean checkPermission) {
        for (String portletId : portletIds) {
            this.addPortletId(userId, portletId, checkPermission);
        }
    }

    public void addPortletIds(long userId, String[] portletIds, String columnId, boolean checkPermission) {
        for (String portletId : portletIds) {
            this.addPortletId(userId, portletId, columnId, -1, checkPermission);
        }
    }

    public void addStateMaxPortletId(String portletId) {
        this.removeStatesPortletId(portletId);
        this.setStateMax(StringUtil.add((String)"", (String)portletId));
    }

    public void addStateMinPortletId(String portletId) {
        this.removeStateMaxPortletId(portletId);
        this.setStateMin(StringUtil.add((String)this.getStateMin(), (String)portletId));
    }

    public List<Portlet> addStaticPortlets(List<Portlet> portlets, List<Portlet> startPortlets, List<Portlet> endPortlets) {
        if (startPortlets == null) {
            startPortlets = new ArrayList<Portlet>();
        }
        if (endPortlets == null) {
            endPortlets = new ArrayList<Portlet>();
        }
        if (startPortlets.isEmpty() && endPortlets.isEmpty()) {
            return portlets;
        }
        ArrayList<Portlet> list = new ArrayList<Portlet>(portlets.size() + startPortlets.size() + endPortlets.size());
        if (!startPortlets.isEmpty()) {
            list.addAll(startPortlets);
        }
        for (Portlet portlet : portlets) {
            if (startPortlets.contains(portlet) || endPortlets.contains(portlet)) continue;
            list.add(portlet);
        }
        if (!endPortlets.isEmpty()) {
            list.addAll(endPortlets);
        }
        return list;
    }

    public String getAddedCustomPortletMode() {
        return this._addedCustomPortletMode;
    }

    public List<Portlet> getAllPortlets() {
        List<Portlet> explicitlyAddedPortlets = this.getExplicitlyAddedPortlets();
        List<Portlet> staticPortlets = this.getStaticPortlets("layout.static.portlets.all");
        List<Portlet> embeddedPortlets = this.getEmbeddedPortlets();
        return this.addStaticPortlets(explicitlyAddedPortlets, staticPortlets, embeddedPortlets);
    }

    public List<Portlet> getAllPortlets(boolean includeSystem) {
        List<Portlet> portlets = this.getAllPortlets();
        if (includeSystem) {
            return portlets;
        }
        ArrayList<Portlet> filteredPortlets = new ArrayList<Portlet>();
        for (Portlet portlet : portlets) {
            if (portlet.isSystem() && !includeSystem) continue;
            filteredPortlets.add(portlet);
        }
        return filteredPortlets;
    }

    public List<Portlet> getAllPortlets(String columnId) {
        String columnValue = this.getColumnValue(columnId);
        String[] portletIds = StringUtil.split((String)columnValue);
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(portletIds.length);
        for (String portletId : portletIds) {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
            if (portlet == null) continue;
            portlets.add(portlet);
        }
        List<Portlet> startPortlets = this.getStaticPortlets("layout.static.portlets.start." + columnId);
        List<Portlet> endPortlets = this.getStaticPortlets("layout.static.portlets.end." + columnId);
        return this.addStaticPortlets(portlets, startPortlets, endPortlets);
    }

    public List<Portlet> getEmbeddedPortlets() {
        Layout layout = this.getLayout();
        return layout.getEmbeddedPortlets();
    }

    public List<Portlet> getExplicitlyAddedPortlets() {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        List<String> columns = this.getColumns();
        for (String columnId : columns) {
            portlets.addAll(this.getAllPortlets(columnId));
        }
        return portlets;
    }

    public Layout getLayoutSetPrototypeLayout() {
        if (this._layoutSetPrototypeLayout == null) {
            this._layoutSetPrototypeLayout = SitesUtil.getLayoutSetPrototypeLayout((Layout)this.getLayout());
            if (this._layoutSetPrototypeLayout == null) {
                this._layoutSetPrototypeLayout = _nullLayout;
            }
        }
        if (this._layoutSetPrototypeLayout == _nullLayout) {
            return null;
        }
        return this._layoutSetPrototypeLayout;
    }

    public String getLayoutSetPrototypeLayoutProperty(String key) {
        Layout layoutSetPrototypeLayout = this.getLayoutSetPrototypeLayout();
        if (layoutSetPrototypeLayout == null) {
            return "";
        }
        UnicodeProperties typeSettingsProperties = layoutSetPrototypeLayout.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    public LayoutTemplate getLayoutTemplate() {
        String themeId = this.getThemeId();
        LayoutTemplate layoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)this.getLayoutTemplateId(), (boolean)false, (String)themeId);
        if (layoutTemplate == null) {
            layoutTemplate = new LayoutTemplateImpl("", "");
            ArrayList<String> columns = new ArrayList<String>(10);
            for (int i = 1; i <= 10; ++i) {
                columns.add("column-" + i);
            }
            layoutTemplate.setColumns(columns);
        }
        return layoutTemplate;
    }

    public String getLayoutTemplateId() {
        return GetterUtil.getString((String)this.getTypeSettingsProperty("layout-template-id"));
    }

    public String getModeAbout() {
        return this.getTypeSettingsProperty("mode-about");
    }

    public String getModeConfig() {
        return this.getTypeSettingsProperty("mode-config");
    }

    public String getModeCustom(String portletMode) {
        return this.getTypeSettingsProperty("mode-" + portletMode);
    }

    public String getModeEdit() {
        return this.getTypeSettingsProperty("mode-edit");
    }

    public String getModeEditDefaults() {
        return this.getTypeSettingsProperty("mode-edit-defaults");
    }

    public String getModeEditGuest() {
        return this.getTypeSettingsProperty("mode-edit-guest");
    }

    public String getModeHelp() {
        return this.getTypeSettingsProperty("mode-help");
    }

    public String getModePreview() {
        return this.getTypeSettingsProperty("mode-preview");
    }

    public String getModePrint() {
        return this.getTypeSettingsProperty("mode-print");
    }

    public int getNumOfColumns() {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate();
        List columns = layoutTemplate.getColumns();
        return columns.size();
    }

    public PortalPreferences getPortalPreferences() {
        return this._portalPreferences;
    }

    public List<String> getPortletIds() {
        ArrayList<String> portletIds = new ArrayList<String>();
        for (String column : this.getColumns()) {
            Collections.addAll(portletIds, StringUtil.split((String)this.getColumnValue(column)));
        }
        return portletIds;
    }

    public List<Portlet> getPortlets() {
        List<String> portletIds = this.getPortletIds();
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(portletIds.size());
        for (String portletId : portletIds) {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
            if (portlet == null) continue;
            portlets.add(portlet);
        }
        return portlets;
    }

    public String getStateMax() {
        return this.getTypeSettingsProperty("state-max");
    }

    public String getStateMaxPortletId() {
        String[] stateMax = StringUtil.split((String)this.getStateMax());
        if (stateMax.length > 0) {
            return stateMax[0];
        }
        return "";
    }

    public String getStateMin() {
        return this.getTypeSettingsProperty("state-min");
    }

    public boolean hasDefaultScopePortletId(long groupId, String portletId) {
        long scopeGroupId;
        return this.hasPortletId(portletId) && groupId == (scopeGroupId = PortalUtil.getScopeGroupId((Layout)this.getLayout(), (String)portletId));
    }

    public boolean hasModeAboutPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeAbout(), (String)portletId);
    }

    public boolean hasModeConfigPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeConfig(), (String)portletId);
    }

    public boolean hasModeCustomPortletId(String portletId, String portletMode) {
        return StringUtil.contains((String)this.getModeCustom(portletMode), (String)portletId);
    }

    public boolean hasModeEditDefaultsPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeEditDefaults(), (String)portletId);
    }

    public boolean hasModeEditGuestPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeEditGuest(), (String)portletId);
    }

    public boolean hasModeEditPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeEdit(), (String)portletId);
    }

    public boolean hasModeHelpPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeHelp(), (String)portletId);
    }

    public boolean hasModePreviewPortletId(String portletId) {
        return StringUtil.contains((String)this.getModePreview(), (String)portletId);
    }

    public boolean hasModePrintPortletId(String portletId) {
        return StringUtil.contains((String)this.getModePrint(), (String)portletId);
    }

    public boolean hasModeViewPortletId(String portletId) {
        return !this.hasModeAboutPortletId(portletId) && !this.hasModeConfigPortletId(portletId) && !this.hasModeEditPortletId(portletId) && !this.hasModeEditDefaultsPortletId(portletId) && !this.hasModeEditGuestPortletId(portletId) && !this.hasModeHelpPortletId(portletId) && !this.hasModePreviewPortletId(portletId) && !this.hasModePrintPortletId(portletId);
    }

    public boolean hasPortletId(String portletId) {
        return this.hasPortletId(portletId, false);
    }

    public boolean hasPortletId(String portletId, boolean strict) {
        LayoutTypePortletImpl defaultLayoutTypePortletImpl;
        List<String> columns = this.getColumns();
        for (String columnId : columns) {
            if (this.hasNonstaticPortletId(columnId, portletId)) {
                return true;
            }
            if (!this.hasStaticPortletId(columnId, portletId)) continue;
            return true;
        }
        Layout layout = this.getLayout();
        if (layout.isTypeControlPanel()) {
            return false;
        }
        if (this.isCustomizable() && this.isCustomizedView() && (defaultLayoutTypePortletImpl = this.getDefaultLayoutTypePortletImpl()).hasNonstaticPortletId(portletId)) {
            return false;
        }
        return !strict && (PortletPreferencesLocalServiceUtil.getPortletPreferencesCount((int)3, (long)layout.getPlid(), (String)portletId) > 0L || PortletPreferencesLocalServiceUtil.getPortletPreferencesCount((int)4, (long)layout.getPlid(), (String)portletId) > 0L);
    }

    public boolean hasStateMax() {
        String[] stateMax = StringUtil.split((String)this.getStateMax());
        return stateMax.length > 0;
    }

    public boolean hasStateMaxPortletId(String portletId) {
        return StringUtil.contains((String)this.getStateMax(), (String)portletId);
    }

    public boolean hasStateMin() {
        String[] stateMin = StringUtil.split((String)this.getStateMin());
        return stateMin.length > 0;
    }

    public boolean hasStateMinPortletId(String portletId) {
        return StringUtil.contains((String)this.getStateMin(), (String)portletId);
    }

    public boolean hasStateNormalPortletId(String portletId) {
        return !this.hasStateMaxPortletId(portletId) && !this.hasStateMinPortletId(portletId);
    }

    public boolean hasUpdatePermission() {
        return this._updatePermission;
    }

    public boolean isCacheable() {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        for (String string : this.getColumns()) {
            List<Portlet> columnPortlets = this.getAllPortlets(string);
            for (Portlet portlet : columnPortlets) {
                Portlet rootPortlet = portlet.getRootPortlet();
                if (rootPortlet.isLayoutCacheable()) continue;
                return false;
            }
            portlets.addAll(columnPortlets);
        }
        List<Portlet> staticPortlets = this.getStaticPortlets("layout.static.portlets.all");
        for (Portlet portlet : staticPortlets) {
            Portlet rootPortlet = portlet.getRootPortlet();
            if (rootPortlet.isLayoutCacheable()) continue;
            return false;
        }
        List<Portlet> list = this.getEmbeddedPortlets();
        for (Portlet portlet : list) {
            Portlet rootPortlet = portlet.getRootPortlet();
            if (rootPortlet.isLayoutCacheable()) continue;
            return false;
        }
        return true;
    }

    public boolean isColumnCustomizable(String columnId) {
        String columnValue;
        String customizableString = this.getTypeSettingsProperty(CustomizedPages.namespaceColumnId((String)columnId));
        boolean customizable = GetterUtil.getBoolean((String)customizableString);
        if (customizable) {
            return !this.isLayoutSetPrototype();
        }
        if (this.hasUserPreferences() && !Objects.equals(columnValue = this._portalPreferences.getValue(CustomizedPages.namespacePlid((long)this.getPlid()), columnId, "null"), "null")) {
            this.setUserPreference(columnId, null);
        }
        return false;
    }

    public boolean isColumnDisabled(String columnId) {
        return this.isCustomizedView() && !this.isColumnCustomizable(columnId) || !this.isCustomizedView() && !this.hasUpdatePermission();
    }

    public boolean isCustomizable() {
        for (String columnId : this.getColumns()) {
            if (!this.isColumnCustomizable(columnId)) continue;
            return true;
        }
        return false;
    }

    public boolean isCustomizedView() {
        return this._customizedView;
    }

    public boolean isDefaultUpdated() {
        if (!this.isCustomizedView() || !this.hasUserPreferences()) {
            return false;
        }
        String preferencesModifiedDateString = this._portalPreferences.getValue(CustomizedPages.namespacePlid((long)this.getPlid()), _MODIFIED_DATE, _NULL_DATE);
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)PropsValues.INDEX_DATE_FORMAT_PATTERN);
        try {
            Date preferencesModifiedDate = dateFormat.parse(preferencesModifiedDateString);
            Layout layout = this.getLayout();
            String propertiesModifiedDateString = layout.getTypeSettingsProperty(_MODIFIED_DATE, _NULL_DATE);
            Date propertiesModifiedDate = dateFormat.parse(propertiesModifiedDateString);
            return propertiesModifiedDate.after(preferencesModifiedDate);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isPortletCustomizable(String portletId) {
        return this.isColumnCustomizable(this.getColumn(portletId));
    }

    public boolean isPortletEmbedded(String portletId) {
        Layout layout = this.getLayout();
        return layout.isPortletEmbedded(portletId, layout.getGroupId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePortletId(long userId, String portletId, String columnId, int columnPos) {
        if (!this.hasPortletId(portletId)) {
            return;
        }
        this._enablePortletLayoutListener = false;
        try {
            this.removePortletId(userId, portletId, false);
            this.addPortletId(userId, portletId, columnId, columnPos, false, true);
        }
        finally {
            this._enablePortletLayoutListener = true;
        }
        Layout layout = this.getLayout();
        try {
            PortletLayoutListener portletLayoutListener;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
            if (portlet != null && (portletLayoutListener = portlet.getPortletLayoutListenerInstance()) != null) {
                portletLayoutListener.onMoveInLayout(portletId, layout.getPlid());
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to fire portlet layout listener event", (Throwable)e);
        }
    }

    public void removeCustomization(UnicodeProperties typeSettingsProperties) {
        for (String columnId : this.getColumns()) {
            if (!this.isColumnCustomizable(columnId) || !GetterUtil.getBoolean((String)this.getTypeSettingsProperty(CustomizedPages.namespaceColumnId((String)columnId)))) continue;
            typeSettingsProperties.remove((Object)CustomizedPages.namespaceColumnId((String)columnId));
        }
    }

    public void removeModeAboutPortletId(String portletId) {
        this.setModeAbout(StringUtil.removeFromList((String)this.getModeAbout(), (String)portletId));
    }

    public void removeModeConfigPortletId(String portletId) {
        this.setModeConfig(StringUtil.removeFromList((String)this.getModeConfig(), (String)portletId));
    }

    public void removeModeEditDefaultsPortletId(String portletId) {
        this.setModeEditDefaults(StringUtil.removeFromList((String)this.getModeEditDefaults(), (String)portletId));
    }

    public void removeModeEditGuestPortletId(String portletId) {
        this.setModeEditGuest(StringUtil.removeFromList((String)this.getModeEditGuest(), (String)portletId));
    }

    public void removeModeEditPortletId(String portletId) {
        this.setModeEdit(StringUtil.removeFromList((String)this.getModeEdit(), (String)portletId));
    }

    public void removeModeHelpPortletId(String portletId) {
        this.setModeHelp(StringUtil.removeFromList((String)this.getModeHelp(), (String)portletId));
    }

    public void removeModePreviewPortletId(String portletId) {
        this.setModePreview(StringUtil.removeFromList((String)this.getModePreview(), (String)portletId));
    }

    public void removeModePrintPortletId(String portletId) {
        this.setModePrint(StringUtil.removeFromList((String)this.getModePrint(), (String)portletId));
    }

    public void removeModesPortletId(String portletId) {
        this.removeModeAboutPortletId(portletId);
        this.removeModeConfigPortletId(portletId);
        this.removeModeEditPortletId(portletId);
        this.removeModeEditDefaultsPortletId(portletId);
        this.removeModeEditGuestPortletId(portletId);
        this.removeModeHelpPortletId(portletId);
        this.removeModePreviewPortletId(portletId);
        this.removeModePrintPortletId(portletId);
    }

    public void removeNestedColumns(String portletNamespace) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        UnicodeProperties newTypeSettingsProperties = new UnicodeProperties();
        for (Map.Entry entry : typeSettingsProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(portletNamespace)) continue;
            newTypeSettingsProperties.setProperty(key, (String)entry.getValue());
        }
        Layout layout = this.getLayout();
        layout.setTypeSettingsProperties(newTypeSettingsProperties);
        String nestedColumnIds = GetterUtil.getString((String)this.getTypeSettingsProperty("nested-column-ids"));
        Object[] nestedColumnIdsArray = ArrayUtil.removeByPrefix((String[])StringUtil.split((String)nestedColumnIds), (String)portletNamespace);
        this.setTypeSettingsProperty("nested-column-ids", StringUtil.merge((Object[])nestedColumnIdsArray));
    }

    public void removePortletId(long userId, String portletId) {
        this.removePortletId(userId, portletId, true);
    }

    public void removePortletId(long userId, String portletId, boolean cleanUp) {
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
            if (portlet == null) {
                _log.error((Object)("Portlet " + portletId + " cannot be removed because it is not registered"));
                return;
            }
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)this.getLayout(), (String)"UPDATE") && !this.isCustomizable()) {
                return;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return;
        }
        List<String> columns = this.getColumns();
        for (String columnId : columns) {
            if (this.isCustomizable() && this.isColumnDisabled(columnId)) continue;
            String columnValue = null;
            columnValue = this.hasUserPreferences() ? this.getUserPreference(columnId) : this.getTypeSettingsProperty(columnId);
            if (StringUtil.endsWith((String)(columnValue = StringUtil.removeFromList((String)columnValue, (String)portletId)), (String)",")) {
                columnValue = columnValue.substring(0, columnValue.length() - 1);
            }
            if (this.hasUserPreferences()) {
                this.setUserPreference(columnId, columnValue);
                continue;
            }
            this.setTypeSettingsProperty(columnId, columnValue);
        }
        if (cleanUp) {
            try {
                this.onRemoveFromLayout(new String[]{portletId});
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    public void removeStateMaxPortletId(String portletId) {
        this.setStateMax(StringUtil.removeFromList((String)this.getStateMax(), (String)portletId));
    }

    public void removeStateMinPortletId(String portletId) {
        this.setStateMin(StringUtil.removeFromList((String)this.getStateMin(), (String)portletId));
    }

    public void removeStatesPortletId(String portletId) {
        this.removeStateMaxPortletId(portletId);
        this.removeStateMinPortletId(portletId);
    }

    public void reorganizePortlets(List<String> newColumns, List<String> oldColumns) {
        String lastNewColumnId = newColumns.get(newColumns.size() - 1);
        String lastNewColumnValue = this.getTypeSettingsProperty(lastNewColumnId);
        for (String oldColumnId : oldColumns) {
            String[] portletIds;
            if (newColumns.contains(oldColumnId)) continue;
            String oldColumnValue = this.getTypeSettingsProperties().remove((Object)oldColumnId);
            for (String portletId : portletIds = StringUtil.split((String)oldColumnValue)) {
                lastNewColumnValue = StringUtil.add((String)lastNewColumnValue, (String)portletId);
            }
        }
        this.setTypeSettingsProperty(lastNewColumnId, lastNewColumnValue);
    }

    public void resetModes() {
        this.setModeAbout("");
        this.setModeConfig("");
        this.setModeEdit("");
        this.setModeEditDefaults("");
        this.setModeEditGuest("");
        this.setModeHelp("");
        this.setModePreview("");
        this.setModePrint("");
    }

    public void resetStates() {
        this.setStateMax("");
        this.setStateMin("");
    }

    public void resetUserPreferences() {
        if (!this.hasUserPreferences()) {
            return;
        }
        long plid = this.getPlid();
        HashSet<String> customPortletIds = new HashSet<String>();
        for (String columnId : this.getColumns()) {
            String value = this._portalPreferences.getValue(CustomizedPages.namespacePlid((long)plid), columnId);
            for (String customPortletId : StringUtil.split((String)value)) {
                customPortletIds.add(customPortletId);
            }
        }
        try {
            this.onRemoveFromLayout(customPortletIds.toArray(new String[customPortletIds.size()]));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this._portalPreferences.resetValues(CustomizedPages.namespacePlid((long)plid));
        this._portalPreferences.setValue(CustomizedPages.namespacePlid((long)plid), _MODIFIED_DATE, this._dateFormat.format(new Date()));
    }

    public void setCustomizedView(boolean customizedView) {
        this._customizedView = customizedView;
    }

    public void setLayoutTemplateId(long userId, String newLayoutTemplateId) {
        this.setLayoutTemplateId(userId, newLayoutTemplateId, true);
    }

    public void setLayoutTemplateId(long userId, String newLayoutTemplateId, boolean checkPermission) {
        if (checkPermission && !PluginSettingLocalServiceUtil.hasPermission((long)userId, (String)newLayoutTemplateId, (String)"layouttpl")) {
            return;
        }
        LayoutTemplate oldLayoutTemplate = this.getLayoutTemplate();
        String themeId = this.getThemeId();
        LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)newLayoutTemplateId, (boolean)false, (String)themeId);
        if (newLayoutTemplate == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to find layout template " + newLayoutTemplateId));
            }
            return;
        }
        this.setTypeSettingsProperty("layout-template-id", newLayoutTemplateId);
        List oldColumns = oldLayoutTemplate.getColumns();
        List newColumns = newLayoutTemplate.getColumns();
        this.reorganizePortlets(newColumns, oldColumns);
    }

    public void setModeAbout(String modeAbout) {
        this.setTypeSettingsProperty("mode-about", modeAbout);
    }

    public void setModeConfig(String modeConfig) {
        this.setTypeSettingsProperty("mode-config", modeConfig);
    }

    public void setModeCustom(String modeCustom, String portletMode) {
        this.setTypeSettingsProperty("mode-" + portletMode, modeCustom);
    }

    public void setModeEdit(String modeEdit) {
        this.setTypeSettingsProperty("mode-edit", modeEdit);
    }

    public void setModeEditDefaults(String modeEditDefaults) {
        this.setTypeSettingsProperty("mode-edit-defaults", modeEditDefaults);
    }

    public void setModeEditGuest(String modeEditGuest) {
        this.setTypeSettingsProperty("mode-edit-guest", modeEditGuest);
    }

    public void setModeHelp(String modeHelp) {
        this.setTypeSettingsProperty("mode-help", modeHelp);
    }

    public void setModePreview(String modePreview) {
        this.setTypeSettingsProperty("mode-preview", modePreview);
    }

    public void setModePrint(String modePrint) {
        this.setTypeSettingsProperty("mode-print", modePrint);
    }

    public void setPortalPreferences(PortalPreferences portalPreferences) {
        this._portalPreferences = portalPreferences;
    }

    public void setStateMax(String stateMax) {
        this.setTypeSettingsProperty("state-max", stateMax);
    }

    public void setStateMin(String stateMin) {
        this.setTypeSettingsProperty("state-min", stateMin);
    }

    public void setUpdatePermission(boolean updatePermission) {
        this._updatePermission = updatePermission;
    }

    protected void addNestedColumn(String columnId) {
        String nestedColumnIds = this.getTypeSettingsProperty("nested-column-ids", "");
        if (!nestedColumnIds.contains(columnId)) {
            nestedColumnIds = StringUtil.add((String)nestedColumnIds, (String)columnId);
            this.setTypeSettingsProperty("nested-column-ids", nestedColumnIds);
        }
    }

    protected String addPortletId(long userId, String portletId, String columnId, int columnPos, boolean checkPermission, boolean strictHasPortlet) {
        LayoutTemplate layoutTemplate;
        List columns;
        portletId = JS.getSafeName((String)portletId);
        Layout layout = this.getLayout();
        Portlet portlet = null;
        try {
            portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
            if (portlet == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Portlet " + portletId + " cannot be added because it is not registered"));
                }
                return null;
            }
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (checkPermission && !PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (Portlet)portlet, (String)"ADD_TO_PAGE")) {
                return null;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (portlet.isSystem()) {
            return null;
        }
        if (portlet.isInstanceable() && !PortletIdCodec.hasInstanceId((String)portletId)) {
            PortletIdCodec.validatePortletName((String)portletId);
            portletId = PortletIdCodec.encode((String)portletId);
        }
        if (this.hasPortletId(portletId, strictHasPortlet)) {
            return null;
        }
        if (columnId == null && !(columns = (layoutTemplate = this.getLayoutTemplate()).getColumns()).isEmpty()) {
            columnId = (String)columns.get(0);
        }
        if (columnId == null) {
            return null;
        }
        if (this.isCustomizable()) {
            if (this.isColumnDisabled(columnId)) {
                return null;
            }
            if ((PortletIdCodec.hasInstanceId((String)portletId) || portlet.isPreferencesUniquePerLayout()) && this.hasUserPreferences()) {
                portletId = PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletId), (long)userId, (String)PortletIdCodec.decodeInstanceId((String)portletId));
            }
        }
        String columnValue = "";
        columnValue = this.hasUserPreferences() ? this.getUserPreference(columnId) : this.getTypeSettingsProperty(columnId);
        if (columnValue == null && columnId.startsWith(_NESTED_PORTLETS_NAMESPACE)) {
            this.addNestedColumn(columnId);
        }
        if (columnPos >= 0) {
            List portletIds = ListUtil.fromArray((Object[])StringUtil.split((String)columnValue));
            if (columnPos <= portletIds.size()) {
                portletIds.add(columnPos, portletId);
            } else {
                portletIds.add(portletId);
            }
            columnValue = StringUtil.merge((Collection)portletIds);
        } else {
            columnValue = StringUtil.add((String)columnValue, (String)portletId);
        }
        if (this.hasUserPreferences()) {
            this.setUserPreference(columnId, columnValue);
        } else {
            this.setTypeSettingsProperty(columnId, columnValue);
        }
        try {
            PortletLayoutListener portletLayoutListener;
            if (this._enablePortletLayoutListener && !portlet.isUndeployedPortlet() && (portletLayoutListener = portlet.getPortletLayoutListenerInstance()) != null) {
                portletLayoutListener.onAddToLayout(portletId, layout.getPlid());
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to fire portlet layout listener event", (Throwable)e);
        }
        return portletId;
    }

    protected void copyPreferences(long userId, String sourcePortletId, String targetPortletId) {
        Layout layout = this.getLayout();
        try {
            PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((long)layout.getGroupId(), (long)0L, (Layout)layout, (String)sourcePortletId, (boolean)false);
            PortletPreferences sourcePortletPreferences = PortletPreferencesLocalServiceUtil.getStrictPreferences((PortletPreferencesIds)portletPreferencesIds);
            portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((long)layout.getGroupId(), (long)userId, (Layout)layout, (String)targetPortletId, (boolean)false);
            PortletPreferencesLocalServiceUtil.updatePreferences((long)portletPreferencesIds.getOwnerId(), (int)portletPreferencesIds.getOwnerType(), (long)portletPreferencesIds.getPlid(), (String)portletPreferencesIds.getPortletId(), (PortletPreferences)sourcePortletPreferences);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void copyResourcePermissions(String sourcePortletId, String targetPortletId) {
        Layout layout = this.getLayout();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)sourcePortletId);
        String sourcePortletPrimaryKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)sourcePortletId);
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getResourcePermissions((long)portlet.getCompanyId(), (String)portlet.getPortletName(), (int)4, (String)sourcePortletPrimaryKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            String targetPortletPrimaryKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)targetPortletId);
            resourcePermission.setResourcePermissionId(CounterLocalServiceUtil.increment());
            resourcePermission.setPrimKey(targetPortletPrimaryKey);
            ResourcePermissionLocalServiceUtil.addResourcePermission((ResourcePermission)resourcePermission);
        }
    }

    protected String getColumn(String portletId) {
        String portletIdColumnId = "";
        List<String> columnIds = this.getColumns();
        for (String columnId : columnIds) {
            String[] portletIds;
            String columnValue = this.getColumnValue(columnId);
            for (String columnPortletId : portletIds = StringUtil.split((String)columnValue)) {
                if (columnPortletId.equals(portletId)) {
                    return columnId;
                }
                if (!Validator.isNull((String)portletIdColumnId) || !Objects.equals(PortletIdCodec.decodePortletName((String)columnPortletId), PortletIdCodec.decodePortletName((String)portletId))) continue;
                portletIdColumnId = columnId;
            }
        }
        return portletIdColumnId;
    }

    protected List<String> getColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        Layout layout = this.getLayout();
        if (layout.isTypePortlet()) {
            LayoutTemplate layoutTemplate = this.getLayoutTemplate();
            columns.addAll(layoutTemplate.getColumns());
            Collections.addAll(columns, this.getNestedColumns());
        } else if (layout.isTypePanel()) {
            columns.add("panelSelectedPortlets");
        }
        return columns;
    }

    protected String getColumnValue(String columnId) {
        if (this.hasUserPreferences() && this.isCustomizable() && !this.isColumnDisabled(columnId)) {
            return this.getUserPreference(columnId);
        }
        return this.getTypeSettingsProperty(columnId);
    }

    protected long getCompanyId() {
        Layout layout = this.getLayout();
        return layout.getCompanyId();
    }

    protected LayoutTypePortletImpl getDefaultLayoutTypePortletImpl() {
        if (!this.isCustomizedView()) {
            return this;
        }
        LayoutTypePortletImpl defaultLayoutTypePortletImpl = (LayoutTypePortletImpl)LayoutTypePortletFactoryUtil.create((Layout)this.getLayout());
        defaultLayoutTypePortletImpl._layoutSetPrototypeLayout = this._layoutSetPrototypeLayout;
        defaultLayoutTypePortletImpl._updatePermission = this._updatePermission;
        return defaultLayoutTypePortletImpl;
    }

    protected String[] getNestedColumns() {
        String nestedColumnIds = this.getTypeSettingsProperty("nested-column-ids");
        return StringUtil.split((String)nestedColumnIds);
    }

    protected long getPlid() {
        Layout layout = this.getLayout();
        return layout.getPlid();
    }

    protected String[] getStaticPortletIds(String position) {
        Layout layout = this.getLayout();
        String selector1 = "";
        Group group = null;
        try {
            group = this._getGroup();
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to get group " + layout.getGroupId()), (Throwable)pe);
            return new String[0];
        }
        if (group.isUser()) {
            selector1 = "user";
        } else if (group.isOrganization()) {
            selector1 = "organization";
        } else if (group.isRegularSite()) {
            selector1 = "regular-site";
        }
        String selector2 = layout.getFriendlyURL();
        String[] portletIds = PropsUtil.getArray(position, new Filter(selector1, selector2));
        for (int i = 0; i < portletIds.length; ++i) {
            portletIds[i] = JS.getSafeName((String)portletIds[i]);
        }
        return portletIds;
    }

    protected List<Portlet> getStaticPortlets(String position) {
        String[] portletIds = this.getStaticPortletIds(position);
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        for (String portletId : portletIds) {
            Portlet portlet;
            if (Validator.isNull((String)portletId) || this.hasNonstaticPortletId(portletId) || (portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId)) == null) continue;
            Object staticPortlet = portlet;
            if (!portlet.isInstanceable()) {
                staticPortlet = new PortletWrapper(portlet){
                    private boolean _staticPortlet;
                    private boolean _staticPortletStart;

                    public boolean getStatic() {
                        return this._staticPortlet;
                    }

                    public boolean getStaticStart() {
                        return this._staticPortletStart;
                    }

                    public boolean isStatic() {
                        return this._staticPortlet;
                    }

                    public boolean isStaticStart() {
                        return this._staticPortletStart;
                    }

                    public void setStatic(boolean staticPortlet) {
                        this._staticPortlet = staticPortlet;
                    }

                    public void setStaticStart(boolean staticPortletStart) {
                        this._staticPortletStart = staticPortletStart;
                    }
                };
            }
            staticPortlet.setStatic(true);
            if (position.startsWith("layout.static.portlets.start")) {
                staticPortlet.setStaticStart(true);
            }
            portlets.add((Portlet)staticPortlet);
        }
        return portlets;
    }

    protected String getThemeId() {
        try {
            Layout layout = this.getLayout();
            LayoutSet layoutSet = layout.getLayoutSet();
            return layoutSet.getThemeId();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    protected String getUserPreference(String key) {
        String[] portletIds;
        String value = "";
        if (!this.hasUserPreferences()) {
            return value;
        }
        value = this._portalPreferences.getValue(CustomizedPages.namespacePlid((long)this.getPlid()), key, "null");
        if (!value.equals("null")) {
            return value;
        }
        value = this.getTypeSettingsProperty(key);
        if (Validator.isNull((String)value)) {
            return value;
        }
        ArrayList<String> newPortletIds = new ArrayList<String>();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        for (String portletId : portletIds = StringUtil.split((String)value)) {
            try {
                String rootPortletId;
                if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)this.getLayout(), (String)portletId, (String)"VIEW", (boolean)true) || !PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (String)(rootPortletId = PortletIdCodec.decodePortletName((String)portletId)), (String)"ADD_TO_PAGE")) {
                    continue;
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            String newPortletId = null;
            boolean preferencesUniquePerLayout = false;
            try {
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
                preferencesUniquePerLayout = portlet.isPreferencesUniquePerLayout();
            }
            catch (SystemException se) {
                _log.error((Object)se, (Throwable)se);
            }
            if (PortletIdCodec.hasInstanceId((String)portletId) || preferencesUniquePerLayout) {
                String instanceId = null;
                if (PortletIdCodec.hasInstanceId((String)portletId)) {
                    instanceId = PortletIdCodec.generateInstanceId();
                }
                newPortletId = PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletId), (long)this._portalPreferences.getUserId(), (String)instanceId);
                this.copyPreferences(this._portalPreferences.getUserId(), portletId, newPortletId);
                this.copyResourcePermissions(portletId, newPortletId);
            } else {
                newPortletId = portletId;
            }
            newPortletIds.add(newPortletId);
        }
        value = StringUtil.merge(newPortletIds);
        this.setUserPreference(key, value);
        return value;
    }

    protected boolean hasNonstaticPortletId(String portletId) {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate();
        List columns = layoutTemplate.getColumns();
        for (String columnId : columns) {
            if (!this.hasNonstaticPortletId(columnId, portletId)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasNonstaticPortletId(String columnId, String portletId) {
        String[] columnValues;
        String columnValue = this.getColumnValue(columnId);
        for (String nonstaticPortletId : columnValues = StringUtil.split((String)columnValue)) {
            String decodedNonStaticPortletName = PortletIdCodec.decodePortletName((String)nonstaticPortletId);
            if (!nonstaticPortletId.equals(portletId) && !decodedNonStaticPortletName.equals(portletId)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasStaticPortletId(String columnId, String portletId) {
        String decodedStaticPortletName;
        String[] staticPortletIdsStart = this.getStaticPortletIds("layout.static.portlets.start." + columnId);
        String[] staticPortletIdsEnd = this.getStaticPortletIds("layout.static.portlets.end." + columnId);
        for (String staticPortletId : staticPortletIdsStart) {
            decodedStaticPortletName = PortletIdCodec.decodePortletName((String)staticPortletId);
            if (!staticPortletId.equals(portletId) && !decodedStaticPortletName.equals(portletId)) continue;
            return true;
        }
        for (String staticPortletId : staticPortletIdsEnd) {
            decodedStaticPortletName = PortletIdCodec.decodePortletName((String)staticPortletId);
            if (!staticPortletId.equals(portletId) && !decodedStaticPortletName.equals(portletId)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasUserPreferences() {
        return this._portalPreferences != null;
    }

    protected boolean isLayoutSetPrototype() {
        try {
            Layout layout = this.getLayout();
            LayoutSet layoutSet = layout.getLayoutSet();
            Group group = layoutSet.getGroup();
            return group.isLayoutSetPrototype();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected void onRemoveFromLayout(String[] portletIds) {
        HashSet<String> portletIdList = new HashSet<String>();
        for (String portletId : portletIds) {
            PortletLayoutListener portletLayoutListener;
            Portlet portlet;
            this.removeModesPortletId(portletId);
            this.removeStatesPortletId(portletId);
            portletIdList.add(portletId);
            String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
            if (rootPortletId.equals("com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet")) {
                String portletNamespace = PortalUtil.getPortletNamespace((String)portletId);
                this._removeNestedColumns(portletNamespace, portletIdList);
            }
            if ((portlet = PortletLocalServiceUtil.getPortletById((String)portletId)) == null || (portletLayoutListener = portlet.getPortletLayoutListenerInstance()) == null) continue;
            portletLayoutListener.updatePropertiesOnRemoveFromLayout(portletId, this.getTypeSettingsProperties());
        }
        try {
            PortletLocalServiceUtil.deletePortlets((long)this.getCompanyId(), (String[])portletIdList.toArray(new String[portletIdList.size()]), (long)this.getPlid());
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
    }

    protected void setUserPreference(String key, String value) {
        this._portalPreferences.setValue(CustomizedPages.namespacePlid((long)this.getPlid()), key, value);
        this._portalPreferences.setValue(CustomizedPages.namespacePlid((long)this.getPlid()), _MODIFIED_DATE, this._dateFormat.format(new Date()));
    }

    private Group _getGroup() throws PortalException {
        if (this._group == null) {
            Layout layout = this.getLayout();
            this._group = layout.getGroup();
        }
        return this._group;
    }

    private void _removeNestedColumns(String portletNamespace, Set<String> portletIdList) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        UnicodeProperties newTypeSettingsProperties = new UnicodeProperties();
        StringBundler sb = new StringBundler(typeSettingsProperties.size() * 2);
        for (Map.Entry entry : typeSettingsProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(portletNamespace)) continue;
            sb.append((String)entry.getValue());
            sb.append(",");
        }
        if (sb.index() != 0) {
            sb.setIndex(sb.index() - 1);
            for (String nestedPortletId : StringUtil.split((String)sb.toString())) {
                String childNestedPortletNamespace = PortalUtil.getPortletNamespace((String)nestedPortletId);
                this._removeNestedColumns(childNestedPortletNamespace, portletIdList);
                this.removeModesPortletId(nestedPortletId);
                this.removeStatesPortletId(nestedPortletId);
                portletIdList.add(nestedPortletId);
            }
        }
        typeSettingsProperties = this.getTypeSettingsProperties();
        for (Map.Entry entry : typeSettingsProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(portletNamespace)) continue;
            newTypeSettingsProperties.setProperty(key, (String)entry.getValue());
        }
        Layout layout = this.getLayout();
        layout.setTypeSettingsProperties(newTypeSettingsProperties);
        String nestedColumnIds = GetterUtil.getString((String)this.getTypeSettingsProperty("nested-column-ids"));
        Object[] nestedColumnIdsArray = ArrayUtil.removeByPrefix((String[])StringUtil.split((String)nestedColumnIds), (String)portletNamespace);
        this.setTypeSettingsProperty("nested-column-ids", StringUtil.merge((Object[])nestedColumnIdsArray));
    }
}

