/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PluginSetting;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.PluginSettingBaseImpl;

public class PluginSettingImpl
extends PluginSettingBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PluginSettingImpl.class);
    private String[] _rolesArray;

    public PluginSettingImpl() {
    }

    public PluginSettingImpl(PluginSetting pluginSetting) {
        this.setCompanyId(pluginSetting.getCompanyId());
        this.setPluginId(pluginSetting.getPluginId());
        this.setPluginType(pluginSetting.getPluginType());
        this.setRoles(pluginSetting.getRoles());
        this.setActive(pluginSetting.getActive());
    }

    public void addRole(String role) {
        this.setRolesArray((String[])ArrayUtil.append((Object[])this._rolesArray, (Object)role));
    }

    public String[] getRolesArray() {
        return this._rolesArray;
    }

    public boolean hasPermission(long userId) {
        try {
            if (this._rolesArray.length == 0) {
                return true;
            }
            if (RoleLocalServiceUtil.hasUserRoles((long)userId, (long)this.getCompanyId(), (String[])this._rolesArray, (boolean)true)) {
                return true;
            }
            if (RoleLocalServiceUtil.hasUserRole((long)userId, (long)this.getCompanyId(), (String)"Administrator", (boolean)true)) {
                return true;
            }
            User user = UserLocalServiceUtil.getUserById((long)userId);
            if (user.isDefaultUser() && this.hasRoleWithName("Guest")) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to check if user " + userId + " has permission"), (Throwable)e);
        }
        return false;
    }

    public boolean hasRoleWithName(String roleName) {
        for (int i = 0; i < this._rolesArray.length; ++i) {
            if (!StringUtil.equalsIgnoreCase((String)this._rolesArray[i], (String)roleName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRoles(String roles) {
        this._rolesArray = StringUtil.split((String)roles);
        super.setRoles(roles);
    }

    public void setRolesArray(String[] rolesArray) {
        this._rolesArray = rolesArray;
        super.setRoles(StringUtil.merge((Object[])rolesArray));
    }
}

