/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.module.framework;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.module.framework.ModuleFrameworkClassLoader;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ModuleFrameworkAdapterHelper {
    private static final Log _log = LogFactoryUtil.getLog(ModuleFrameworkAdapterHelper.class);
    private static ClassLoader _classLoader;
    private static final Map<MethodKey, Method> _methods;
    private final Object _adaptedObject;

    public static ClassLoader getClassLoader() {
        if (_classLoader != null) {
            return _classLoader;
        }
        try {
            if (FileUtil.getFile() == null) {
                FileUtil fileUtil = new FileUtil();
                fileUtil.setFile((com.liferay.portal.kernel.util.File)DoPrivilegedUtil.wrap(new FileImpl()));
            }
            _classLoader = new ModuleFrameworkClassLoader(ModuleFrameworkAdapterHelper._getClassPathURLs(), ClassLoaderUtil.getPortalClassLoader());
            return _classLoader;
        }
        catch (IOException ioe) {
            _log.error((Object)"Unable to configure the class loader for the module framework", (Throwable)ioe);
            return (ClassLoader)ReflectionUtil.throwException((Throwable)ioe);
        }
    }

    public ModuleFrameworkAdapterHelper(String className) {
        try {
            this._adaptedObject = InstanceFactory.newInstance((ClassLoader)ModuleFrameworkAdapterHelper.getClassLoader(), (String)className);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to load the module framework");
            throw new RuntimeException(e);
        }
    }

    public Object exec(String methodName, Class<?>[] parameterTypes, Object ... parameters) {
        try {
            Method method = this.searchMethod(methodName, parameterTypes);
            return method.invoke(this._adaptedObject, parameters);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public Object execute(String methodName, Object ... parameters) {
        Class[] parameterTypes = ReflectionUtil.getParameterTypes((Object[])parameters);
        return this.exec(methodName, parameterTypes, parameters);
    }

    protected Method searchMethod(String methodName, Class<?>[] parameterTypes) throws Exception {
        MethodKey methodKey = new MethodKey(this._adaptedObject.getClass(), methodName, (Class[])parameterTypes);
        if (_methods.containsKey(methodKey)) {
            return _methods.get(methodKey);
        }
        Method method = ReflectionUtil.getDeclaredMethod(this._adaptedObject.getClass(), (String)methodName, (Class[])parameterTypes);
        _methods.put(methodKey, method);
        return method;
    }

    private static URL[] _getClassPathURLs() throws IOException {
        File coreDir = new File(PropsValues.MODULE_FRAMEWORK_BASE_DIR, "core");
        File[] files = coreDir.listFiles();
        if (files == null) {
            throw new IllegalStateException("Missing " + coreDir.getCanonicalPath());
        }
        URL[] urls = new URL[files.length];
        for (int i = 0; i < urls.length; ++i) {
            URI uri = files[i].toURI();
            urls[i] = uri.toURL();
        }
        return urls;
    }

    static {
        _methods = new HashMap<MethodKey, Method>();
    }
}

