/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.StringBundler;

public class RepositoryEntryChecker {
    private final DocumentRepository _documentRepository;

    public RepositoryEntryChecker(DocumentRepository documentRepository) {
        this._documentRepository = documentRepository;
    }

    public DLFileEntry checkDLFileEntry(DLFileEntry dlFileEntry) {
        long repositoryId = this._documentRepository.getRepositoryId();
        if (dlFileEntry.getRepositoryId() != repositoryId) {
            throw new SystemException(StringBundler.concat((String[])new String[]{"File entry ", String.valueOf(dlFileEntry.getFileEntryId()), " does not belong to repository ", String.valueOf(repositoryId)}));
        }
        return dlFileEntry;
    }

    public FileEntry checkFileEntry(FileEntry fileEntry) {
        long repositoryId = this._documentRepository.getRepositoryId();
        if (fileEntry.getRepositoryId() != repositoryId) {
            throw new SystemException(StringBundler.concat((String[])new String[]{"File entry ", String.valueOf(fileEntry.getFileEntryId()), " does not belong to repository ", String.valueOf(repositoryId)}));
        }
        return fileEntry;
    }
}

