/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.access.control;

import com.liferay.portal.kernel.security.access.control.AccessControlPolicy;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.security.access.control.AccessControlAdvisor;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.aopalliance.intercept.MethodInvocation;

public class AccessControlAdvisorImpl
implements AccessControlAdvisor {
    private final List<AccessControlPolicy> _accessControlPolicies = new CopyOnWriteArrayList<AccessControlPolicy>();
    private final ServiceTracker<?, AccessControlPolicy> _serviceTracker;

    public AccessControlAdvisorImpl() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(AccessControlPolicy.class, (ServiceTrackerCustomizer)new AccessControlPolicyTrackerCustomizer());
        this._serviceTracker.open();
    }

    @Override
    public void accept(MethodInvocation methodInvocation, AccessControlled accessControlled) throws SecurityException {
        if (AccessControlThreadLocal.isRemoteAccess()) {
            for (AccessControlPolicy accessControlPolicy : this._accessControlPolicies) {
                accessControlPolicy.onServiceRemoteAccess(methodInvocation.getMethod(), methodInvocation.getArguments(), accessControlled);
            }
        } else {
            for (AccessControlPolicy accessControlPolicy : this._accessControlPolicies) {
                accessControlPolicy.onServiceAccess(methodInvocation.getMethod(), methodInvocation.getArguments(), accessControlled);
            }
        }
    }

    private class AccessControlPolicyTrackerCustomizer
    implements ServiceTrackerCustomizer<AccessControlPolicy, AccessControlPolicy> {
        private AccessControlPolicyTrackerCustomizer() {
        }

        public AccessControlPolicy addingService(ServiceReference<AccessControlPolicy> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            AccessControlPolicy accessControlPolicy = (AccessControlPolicy)registry.getService(serviceReference);
            AccessControlAdvisorImpl.this._accessControlPolicies.add(accessControlPolicy);
            return accessControlPolicy;
        }

        public void modifiedService(ServiceReference<AccessControlPolicy> serviceReference, AccessControlPolicy accessControlPolicy) {
        }

        public void removedService(ServiceReference<AccessControlPolicy> serviceReference, AccessControlPolicy accessControlPolicy) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            AccessControlAdvisorImpl.this._accessControlPolicies.remove(accessControlPolicy);
        }
    }
}

